/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.schemasummary;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ObjectTypeDistribution {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(ObjectTypeDistribution.class.getName());
    @HtmlProperty(labelKey="SRC_SCH_SUMM_OWNER", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The owner of the database object")
    private String owner;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_OBJ_TYPE", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The type of the database object (e.g., TABLE, INDEX, PROCEDURE, etc.)")
    private String objectType;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_STATUS", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The status of the database object (e.g., VALID, INVALID, etc.)")
    private String status;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_TOTAL", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The total number of database objects matching the specified criteria")
    private long total;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ObjectTypeDistribution> getObjectTypeDistributionStats(ExecutionContext exeCtx) throws SQLException {
        String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        String dbObjectStatsQuery = "SELECT OWNER, OBJECT_TYPE, STATUS, COUNT(*) AS TOTAL  FROM SYS.DBA_OBJECTS " + whereClause + " GROUP BY OWNER, OBJECT_TYPE, STATUS  ORDER BY 1, 2, 3, 4";
        log.fine("Fetching Object Type Distribution stats with query: " + dbObjectStatsQuery);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<ObjectTypeDistribution> objectDistributionStats = new ArrayList<ObjectTypeDistribution>();
        long startTime = System.currentTimeMillis();
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, dbObjectStatsQuery);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String owner = rs.getString("OWNER");
                String objectType = rs.getString("OBJECT_TYPE");
                String status = rs.getString("STATUS");
                long total = rs.getLong("TOTAL");
                ObjectTypeDistribution dbObjectTypeStat = new ObjectTypeDistribution(owner, objectType, status, total);
                objectDistributionStats.add(dbObjectTypeStat);
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return objectDistributionStats;
    }

    public static ObjectTypeDistributionBuilder builder() {
        return new ObjectTypeDistributionBuilder();
    }

    private ObjectTypeDistribution(String owner, String objectType, String status, long total) {
        this.owner = owner;
        this.objectType = objectType;
        this.status = status;
        this.total = total;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getStatus() {
        return this.status;
    }

    public long getTotal() {
        return this.total;
    }

    public static class ObjectTypeDistributionBuilder {
        private String owner;
        private String objectType;
        private String status;
        private long total;

        ObjectTypeDistributionBuilder() {
        }

        public ObjectTypeDistributionBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public ObjectTypeDistributionBuilder objectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        public ObjectTypeDistributionBuilder status(String status) {
            this.status = status;
            return this;
        }

        public ObjectTypeDistributionBuilder total(long total) {
            this.total = total;
            return this;
        }

        public ObjectTypeDistribution build() {
            return new ObjectTypeDistribution(this.owner, this.objectType, this.status, this.total);
        }

        public String toString() {
            return "ObjectTypeDistribution.ObjectTypeDistributionBuilder(owner=" + this.owner + ", objectType=" + this.objectType + ", status=" + this.status + ", total=" + this.total + ")";
        }
    }
}

