/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector;

import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.fixups.Fixable;
import com.oracle.premigration.dbinspector.fixups.Fixup;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class CheckRunner {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(CheckRunner.class.getName());

    private CheckRunner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runCheck(ExecutionContext exeCtx, Check check, List<String> reportAnalysisNotes) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block5: {
            String checkName = check.getName();
            if (check.isSkipExecution()) {
                log.info("Skipping Execution of Check: " + checkName + ".  Skip reason: " + check.getErrorMessage());
                return;
            }
            log.info("Running: " + check);
            conn = null;
            stmt = null;
            rs = null;
            try {
                long start = System.currentTimeMillis();
                conn = exeCtx.getConnection();
                log.fine("Elapsed time obtaining a connection: " + Utilities.formatTimeInterval(System.currentTimeMillis() - start));
                String sql = check.getSqlQuery();
                check.setExecutedSQL(sql);
                start = System.currentTimeMillis();
                stmt = SqlUtils.createPreparedStatement(conn, sql);
                log.fine("Elapsed time preparing statement: " + Utilities.formatTimeInterval(System.currentTimeMillis() - start));
                start = System.currentTimeMillis();
                rs = stmt.executeQuery();
                log.fine("Elapsed time executing query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - start));
                rs.setFetchSize(500);
                start = System.currentTimeMillis();
                List<Map<String, String>> relevantObjects = check.resultSetToListMap(rs, exeCtx);
                log.fine("Elapsed time producing " + relevantObjects.size() + " relevant data objects: " + Utilities.formatTimeInterval(System.currentTimeMillis() - start));
                check.setRelevantObjectsData(relevantObjects);
                CheckRunner.generateFixupForCheck(check, exeCtx);
                Integer maxRelevantObjects = exeCtx.getParsedArgs().getMaxRelevantObjects();
                CheckRunner.trimRelevantObjects(maxRelevantObjects, relevantObjects, check);
                if (check.fetchNotesMessages(exeCtx) == null) break block5;
                reportAnalysisNotes.addAll(check.fetchNotesMessages(exeCtx));
            }
            catch (SQLException e) {
                try {
                    check.setRelevantObjectsData(Collections.emptyList());
                    check.setResult(CheckResult.FATAL);
                    String sqlForLog = check.getExecutedSQL() == null ? check.getSqlQuery() : check.getExecutedSQL();
                    log.warning("Error executing query: " + sqlForLog);
                    String checkFailMsg = Utilities.getErrorText("ERROR2000", e, checkName);
                    check.setErrorMessage(checkFailMsg);
                    Utilities.printAndLogErrorMessage(checkFailMsg, exeCtx.getEnvCtx(), Level.SEVERE, e);
                }
                catch (Throwable throwable) {
                    exeCtx.closeIfNotNull(rs, stmt, conn);
                    throw throwable;
                }
                exeCtx.closeIfNotNull(rs, stmt, conn);
            }
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
    }

    private static void trimRelevantObjects(Integer maxRelevantObjects, List<Map<String, String>> relevantObjects, Check check) {
        if (maxRelevantObjects == null) {
            return;
        }
        int omittedObjectCount = 0;
        if (maxRelevantObjects == 0) {
            omittedObjectCount = relevantObjects.size();
            relevantObjects.clear();
        } else {
            while (relevantObjects.size() > maxRelevantObjects) {
                ++omittedObjectCount;
                relevantObjects.remove(relevantObjects.size() - 1);
            }
        }
        check.setOmittedRelevantObjectsCount(omittedObjectCount);
    }

    private static void generateFixupForCheck(Check check, ExecutionContext exeCtx) {
        if (exeCtx.getParsedArgs().isGenFixups() && check.getResult() != CheckResult.PASS && check instanceof Fixable) {
            Fixable fixableCheck = (Fixable)((Object)check);
            try {
                fixableCheck.generateFixups(exeCtx);
            }
            catch (Exception e) {
                String errorMessage = Utilities.getErrorText("ERROR3000", e, new String[0]);
                log.severe(errorMessage);
                check.setErrorMessage(errorMessage);
            }
            if (exeCtx.getParsedArgs().isGenZipFile() && check.getFixups() != null) {
                for (Fixup fixup : check.getFixups()) {
                    exeCtx.getZipContents().add(fixup);
                }
            }
        }
    }
}

