/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.commons.io;

import com.oracle.premigration.exceptions.AccessDeniedException;
import com.oracle.premigration.helpers.Utilities;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

public final class OutputFilenamesContainer {
    private final String logOutputFilename;
    private final String jsonOutputFilename;
    private final String textOutputFilename;
    private final String htmlOutputFilename;
    private final String propsOutputFilename;
    private final String zipOutputFilename;
    private final String csvOutputFilename;
    private final String originalPrefix;
    private final String prefix;
    private final String outDir;

    public OutputFilenamesContainer(String outFilePrefix, String outDir) {
        this("premigration_advisor", outFilePrefix, outDir);
    }

    public OutputFilenamesContainer(String baseOutputFilename, String outFilePrefix, String outDir) {
        this.originalPrefix = outFilePrefix;
        this.prefix = this.processOutFilePrefix(outFilePrefix);
        this.outDir = outDir;
        this.logOutputFilename = this.prefix + baseOutputFilename + ".log";
        this.jsonOutputFilename = this.prefix + baseOutputFilename + "_report.json";
        this.textOutputFilename = this.prefix + baseOutputFilename + "_report.txt";
        this.htmlOutputFilename = this.prefix + baseOutputFilename + "_report.html";
        this.propsOutputFilename = this.prefix + baseOutputFilename + "_analysis.properties";
        this.zipOutputFilename = this.prefix + baseOutputFilename + ".zip";
        this.csvOutputFilename = this.prefix + "mpack_metrics.csv";
    }

    private String processOutFilePrefix(String outFilePrefix) {
        String defaultPrefix = "";
        if (outFilePrefix == null) {
            return "";
        }
        String validFilePrefix = this.getValidFilePrefix(outFilePrefix);
        if (validFilePrefix == null) {
            String errorMsg = Utilities.getErrorText("ERROR1011", new String[0]);
            System.out.println(errorMsg);
            return "";
        }
        if (!validFilePrefix.isEmpty()) {
            return validFilePrefix + "_";
        }
        return "";
    }

    private String getValidatedFilePath(String fileName) throws IOException, AccessDeniedException {
        String validatedPath = OutputFilenamesContainer.getOutdirValidated(this.outDir);
        Path path = Paths.get(validatedPath, new String[0]).resolve(fileName);
        String pathString = path.toAbsolutePath().toString();
        if (Files.exists(path, new LinkOption[0])) {
            if (!Files.isWritable(path)) {
                throw new AccessDeniedException(pathString);
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                throw new IOException(Utilities.getErrorText("ERROR3001", pathString));
            }
        }
        return pathString;
    }

    public String getValidatedLogFilePath() throws IOException, AccessDeniedException {
        return this.getValidatedFilePath(this.logOutputFilename);
    }

    public String getValidatedTextReportPath() throws IOException, AccessDeniedException {
        return this.getValidatedFilePath(this.textOutputFilename);
    }

    public String getValidatedHtmlReportPath() throws IOException, AccessDeniedException {
        return this.getValidatedFilePath(this.htmlOutputFilename);
    }

    public String getValidatedJSONReportPath() throws IOException, AccessDeniedException {
        return this.getValidatedFilePath(this.jsonOutputFilename);
    }

    public String getValidatedPropertiesFilePath() throws IOException, AccessDeniedException {
        return this.getValidatedFilePath(this.propsOutputFilename);
    }

    public String getValidatedZipFilePath() throws IOException, AccessDeniedException {
        return this.getValidatedFilePath(this.zipOutputFilename);
    }

    public String getValidatedMpackReportPath() throws IOException, AccessDeniedException {
        return this.getValidatedFilePath(this.csvOutputFilename);
    }

    private String getValidFilePrefix(String fileName) {
        String name = fileName.replaceAll("[^-_.A-Za-z0-9]", "").trim();
        if (name.isEmpty()) {
            return "";
        }
        if (!Character.isAlphabetic(name.charAt(0))) {
            return null;
        }
        if (name.length() > 200) {
            name = name.substring(0, 199);
        }
        return name;
    }

    public static String getOutdirValidated(String outDir) throws IOException, AccessDeniedException {
        File file = OutputFilenamesContainer.getOutDirFile(outDir);
        if (file.canWrite()) {
            return file.getCanonicalPath();
        }
        throw new AccessDeniedException("Cannot write on " + file.getCanonicalPath());
    }

    private static File getOutDirFile(String outDir) throws IOException {
        File file = new File(outDir);
        if (file.exists()) {
            return file;
        }
        if (file.mkdirs()) {
            return file;
        }
        throw new IOException("Cannot create dir " + outDir);
    }

    public OutputFilenamesContainer renameFilesForCDBSummary() throws IOException, AccessDeniedException {
        Path dest;
        OutputFilenamesContainer summaryContainerNames = new OutputFilenamesContainer("premigration_advisor_summary", this.originalPrefix, this.outDir);
        Path src = Paths.get(this.getValidatedLogFilePath(), new String[0]);
        if (Files.exists(src, new LinkOption[0])) {
            dest = Paths.get(summaryContainerNames.getValidatedLogFilePath(), new String[0]);
            Files.move(src, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        if (Files.exists(src = Paths.get(this.getValidatedJSONReportPath(), new String[0]), new LinkOption[0])) {
            dest = Paths.get(summaryContainerNames.getValidatedJSONReportPath(), new String[0]);
            Files.move(src, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        if (Files.exists(src = Paths.get(this.getValidatedHtmlReportPath(), new String[0]), new LinkOption[0])) {
            dest = Paths.get(summaryContainerNames.getValidatedHtmlReportPath(), new String[0]);
            Files.move(src, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        if (Files.exists(src = Paths.get(this.getValidatedTextReportPath(), new String[0]), new LinkOption[0])) {
            dest = Paths.get(summaryContainerNames.getValidatedTextReportPath(), new String[0]);
            Files.move(src, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        if (Files.exists(src = Paths.get(this.getValidatedZipFilePath(), new String[0]), new LinkOption[0])) {
            dest = Paths.get(summaryContainerNames.getValidatedZipFilePath(), new String[0]);
            Files.move(src, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        return summaryContainerNames;
    }

    public String getLogOutputFilename() {
        return this.logOutputFilename;
    }

    public String getJsonOutputFilename() {
        return this.jsonOutputFilename;
    }

    public String getTextOutputFilename() {
        return this.textOutputFilename;
    }

    public String getHtmlOutputFilename() {
        return this.htmlOutputFilename;
    }

    public String getPropsOutputFilename() {
        return this.propsOutputFilename;
    }

    public String getZipOutputFilename() {
        return this.zipOutputFilename;
    }

    public String getCsvOutputFilename() {
        return this.csvOutputFilename;
    }

    public String getOriginalPrefix() {
        return this.originalPrefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getOutDir() {
        return this.outDir;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutputFilenamesContainer)) {
            return false;
        }
        OutputFilenamesContainer other = (OutputFilenamesContainer)o;
        String this$logOutputFilename = this.getLogOutputFilename();
        String other$logOutputFilename = other.getLogOutputFilename();
        if (this$logOutputFilename == null ? other$logOutputFilename != null : !this$logOutputFilename.equals(other$logOutputFilename)) {
            return false;
        }
        String this$jsonOutputFilename = this.getJsonOutputFilename();
        String other$jsonOutputFilename = other.getJsonOutputFilename();
        if (this$jsonOutputFilename == null ? other$jsonOutputFilename != null : !this$jsonOutputFilename.equals(other$jsonOutputFilename)) {
            return false;
        }
        String this$textOutputFilename = this.getTextOutputFilename();
        String other$textOutputFilename = other.getTextOutputFilename();
        if (this$textOutputFilename == null ? other$textOutputFilename != null : !this$textOutputFilename.equals(other$textOutputFilename)) {
            return false;
        }
        String this$htmlOutputFilename = this.getHtmlOutputFilename();
        String other$htmlOutputFilename = other.getHtmlOutputFilename();
        if (this$htmlOutputFilename == null ? other$htmlOutputFilename != null : !this$htmlOutputFilename.equals(other$htmlOutputFilename)) {
            return false;
        }
        String this$propsOutputFilename = this.getPropsOutputFilename();
        String other$propsOutputFilename = other.getPropsOutputFilename();
        if (this$propsOutputFilename == null ? other$propsOutputFilename != null : !this$propsOutputFilename.equals(other$propsOutputFilename)) {
            return false;
        }
        String this$zipOutputFilename = this.getZipOutputFilename();
        String other$zipOutputFilename = other.getZipOutputFilename();
        if (this$zipOutputFilename == null ? other$zipOutputFilename != null : !this$zipOutputFilename.equals(other$zipOutputFilename)) {
            return false;
        }
        String this$csvOutputFilename = this.getCsvOutputFilename();
        String other$csvOutputFilename = other.getCsvOutputFilename();
        if (this$csvOutputFilename == null ? other$csvOutputFilename != null : !this$csvOutputFilename.equals(other$csvOutputFilename)) {
            return false;
        }
        String this$originalPrefix = this.getOriginalPrefix();
        String other$originalPrefix = other.getOriginalPrefix();
        if (this$originalPrefix == null ? other$originalPrefix != null : !this$originalPrefix.equals(other$originalPrefix)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$outDir = this.getOutDir();
        String other$outDir = other.getOutDir();
        return !(this$outDir == null ? other$outDir != null : !this$outDir.equals(other$outDir));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $logOutputFilename = this.getLogOutputFilename();
        result = result * 59 + ($logOutputFilename == null ? 43 : $logOutputFilename.hashCode());
        String $jsonOutputFilename = this.getJsonOutputFilename();
        result = result * 59 + ($jsonOutputFilename == null ? 43 : $jsonOutputFilename.hashCode());
        String $textOutputFilename = this.getTextOutputFilename();
        result = result * 59 + ($textOutputFilename == null ? 43 : $textOutputFilename.hashCode());
        String $htmlOutputFilename = this.getHtmlOutputFilename();
        result = result * 59 + ($htmlOutputFilename == null ? 43 : $htmlOutputFilename.hashCode());
        String $propsOutputFilename = this.getPropsOutputFilename();
        result = result * 59 + ($propsOutputFilename == null ? 43 : $propsOutputFilename.hashCode());
        String $zipOutputFilename = this.getZipOutputFilename();
        result = result * 59 + ($zipOutputFilename == null ? 43 : $zipOutputFilename.hashCode());
        String $csvOutputFilename = this.getCsvOutputFilename();
        result = result * 59 + ($csvOutputFilename == null ? 43 : $csvOutputFilename.hashCode());
        String $originalPrefix = this.getOriginalPrefix();
        result = result * 59 + ($originalPrefix == null ? 43 : $originalPrefix.hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $outDir = this.getOutDir();
        result = result * 59 + ($outDir == null ? 43 : $outDir.hashCode());
        return result;
    }

    public String toString() {
        return "OutputFilenamesContainer(logOutputFilename=" + this.getLogOutputFilename() + ", jsonOutputFilename=" + this.getJsonOutputFilename() + ", textOutputFilename=" + this.getTextOutputFilename() + ", htmlOutputFilename=" + this.getHtmlOutputFilename() + ", propsOutputFilename=" + this.getPropsOutputFilename() + ", zipOutputFilename=" + this.getZipOutputFilename() + ", csvOutputFilename=" + this.getCsvOutputFilename() + ", originalPrefix=" + this.getOriginalPrefix() + ", prefix=" + this.getPrefix() + ", outDir=" + this.getOutDir() + ")";
    }
}

