/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.datapump.generators;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.rest.RestMessages;
import org.stringtemplate.v4.NoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.STWriter;

public class DataPumpCodeGenerator {
    private static volatile DataPumpCodeGenerator _instance;
    private static final String DATAPUMP_GROUP_FILE = "oracle/dbtools/extension/datapump/generators/templates/datapump.stg";
    private STGroup m_templateGroup;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataPumpCodeGenerator getInstance() {
        if (_instance != null) return _instance;
        Class<DataPumpCodeGenerator> clazz = DataPumpCodeGenerator.class;
        synchronized (DataPumpCodeGenerator.class) {
            if (_instance != null) return _instance;
            _instance = new DataPumpCodeGenerator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private DataPumpCodeGenerator() {
    }

    protected STGroup getTemplateGroup() {
        if (this.m_templateGroup == null) {
            ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(DataPumpCodeGenerator.class.getClassLoader());
            try {
                this.m_templateGroup = new STGroupFile(DATAPUMP_GROUP_FILE);
            }
            catch (Throwable e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(ctxLoader);
            }
        }
        return this.m_templateGroup;
    }

    public String getTemplate(String templateName, Map<String, Object> properties) {
        if (this.getTemplateGroup() != null) {
            ST st = this.getTemplateGroup().getInstanceOf(templateName);
            if (st != null) {
                Set<String> keys = properties.keySet();
                for (String k : keys) {
                    st.add(k, properties.get(k));
                }
                NoIndentWriter out = new NoIndentWriter((Writer)new StringWriter());
                try {
                    st.write((STWriter)out);
                }
                catch (IOException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
                }
                return st.render();
            }
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, RestMessages.format((String)"GEN_TEMPLATE_NOT_FOUND", (Object[])new Object[]{templateName}));
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, RestMessages.format((String)"GEN_GROUP_FILE_NOT_FOUND", (Object[])new Object[]{DATAPUMP_GROUP_FILE}));
        }
        return null;
    }
}

