/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extract.models;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import oracle.dbtools.extract.ExtractResources;
import oracle.dbtools.util.Logger;

public class ExtractScript {
    public static final int EXEC_BEFORE_CREATE = 110;
    public static final int EXEC_AFTER_CREATE = 111;
    public static final int EXEC_BEFORE_LOAD = 112;
    public static final int EXEC_AFTER_LOAD = 113;
    public static final int EXEC_INITIAL = 114;
    public static final int EXEC_FINAL = 115;
    public static final String TYPE_BEFORE_CREATE = "BEFORE_CREATE";
    public static final String TYPE_AFTER_CREATE = "AFTER_CREATE";
    public static final String TYPE_BEFORE_LOAD = "BEFORE_LOAD";
    public static final String TYPE_AFTER_LOAD = "AFTER_LOAD";
    public static final String TYPE_INITIAL = "INITIAL";
    public static final String TYPE_FINAL = "FINAL";
    private static final HashMap<String, Integer> XML_IDS = new HashMap(4);
    public static final String BEFORE_CREATE_NAME;
    public static final String AFTER_CREATE_NAME;
    public static final String BEFORE_LOAD_NAME;
    public static final String AFTER_LOAD_NAME;
    public static final String INITIAL_NAME;
    public static final String FINAL_NAME;
    private int _executeWhen = 110;
    private String _path;
    private String _encoding;
    private boolean _isSelectedFile = false;

    public ExtractScript(String path, String encoding, int executeWhen, boolean isSelectedFile) {
        this._path = path;
        this._encoding = encoding;
        this._executeWhen = executeWhen;
        this._isSelectedFile = isSelectedFile;
    }

    public void setExecuteWhen(int executeWhen) {
        this._executeWhen = executeWhen;
    }

    public int getExecuteWhen() {
        return this._executeWhen;
    }

    public void isSelectedFile(boolean isSelectedFile) {
        this._isSelectedFile = isSelectedFile;
    }

    public boolean isSelectedFile() {
        return this._isSelectedFile;
    }

    public String getPath() {
        return this._path;
    }

    public void setPath(String value) {
        this._path = value;
    }

    public URL getUrl() {
        try {
            return new File(this._path).toURI().toURL();
        }
        catch (MalformedURLException e) {
            Logger.warn(this.getClass(), (Throwable)e);
            return null;
        }
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String value) {
        this._encoding = value;
    }

    public ExtractScript clone() {
        ExtractScript clone = new ExtractScript(this._path, this._encoding, this._executeWhen, this._isSelectedFile);
        return clone;
    }

    public String getIndent(int idx) {
        char[] indent = new char[idx];
        for (int i = 0; i < idx; ++i) {
            indent[i] = 9;
        }
        return new String(indent);
    }

    public String toXML(int indent) {
        return this.toXML(new StringBuffer(), indent).toString();
    }

    public StringBuffer toXML(StringBuffer sb, int indent) {
        sb.append(this.getIndent(indent) + "<script");
        sb.append(">\n");
        sb.append(this.getIndent(indent + 1) + "<execWhen><![CDATA[" + this.getType() + "]]></execWhen>\n");
        sb.append(this.getIndent(indent + 1) + "<fileurl><![CDATA[" + String.valueOf(this.getUrl()) + "]]></fileurl>\n");
        sb.append(this.getIndent(indent + 1) + "<encoding><![CDATA[" + this._encoding + "]]></encoding>\n");
        if (this._isSelectedFile) {
            sb.append(this.getIndent(indent + 1) + "<includefile><![CDATA[true]]></includefile>\n");
        } else {
            sb.append(this.getIndent(indent + 1) + "<includefile><![CDATA[false]]></includefile>\n");
        }
        sb.append(this.getIndent(indent) + "</script>\n");
        return sb;
    }

    public String getName() {
        switch (this._executeWhen) {
            case 110: {
                return BEFORE_CREATE_NAME;
            }
            case 111: {
                return AFTER_CREATE_NAME;
            }
            case 112: {
                return BEFORE_LOAD_NAME;
            }
            case 113: {
                return AFTER_LOAD_NAME;
            }
            case 114: {
                return INITIAL_NAME;
            }
            case 115: {
                return FINAL_NAME;
            }
        }
        return "";
    }

    public String getType() {
        switch (this._executeWhen) {
            case 110: {
                return TYPE_BEFORE_CREATE;
            }
            case 111: {
                return TYPE_AFTER_CREATE;
            }
            case 112: {
                return TYPE_BEFORE_LOAD;
            }
            case 113: {
                return TYPE_AFTER_LOAD;
            }
            case 114: {
                return TYPE_INITIAL;
            }
            case 115: {
                return TYPE_FINAL;
            }
        }
        return "";
    }

    public static int getExecuteWhen(String id) {
        return XML_IDS.get(id);
    }

    static {
        XML_IDS.put(TYPE_BEFORE_CREATE, 110);
        XML_IDS.put(TYPE_AFTER_CREATE, 111);
        XML_IDS.put(TYPE_BEFORE_LOAD, 112);
        XML_IDS.put(TYPE_AFTER_LOAD, 113);
        XML_IDS.put(TYPE_INITIAL, 114);
        XML_IDS.put(TYPE_FINAL, 115);
        BEFORE_CREATE_NAME = ExtractResources.getString("BEFORE_CREATE_SCRIPT");
        AFTER_CREATE_NAME = ExtractResources.getString("AFTER_CREATE_SCRIPT");
        BEFORE_LOAD_NAME = ExtractResources.getString("BEFORE_LOAD_SCRIPT");
        AFTER_LOAD_NAME = ExtractResources.getString("AFTER_LOAD_SCRIPT");
        INITIAL_NAME = ExtractResources.getString("INITIAL_SCRIPT");
        FINAL_NAME = ExtractResources.getString("FINAL_SCRIPT");
    }

    public static enum xmlIds {
        xmlIdPreCreate,
        xmlIdPostCreate,
        xmlIdPreLoad,
        xmlIdPostLoad;

    }
}

