/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extract.models;

import oracle.dbtools.common.config.ICommonConfig;
import oracle.dbtools.common.config.IStorage;
import oracle.dbtools.datatools.BaseDataFormat;
import oracle.dbtools.export.ExportDataFormatConfig;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.format.IExportFormatOptions;
import oracle.dbtools.raptor.format.IResultFormatter;

public class ExtractDataFormat
extends BaseDataFormat {
    public static final String KEY_DATAFORMAT = "DATAFORMAT";
    public static String LDR_DEFAULT_DELIMITER;
    public static String SCHEMA;
    private boolean _exportEnabled;
    private String _tableName;
    private boolean _isTableNameVisible;
    private boolean _saveQuery;
    private String _queryName;
    private String _dataName;
    private boolean _isTruncate = false;
    private boolean _isDisableConstraints = false;
    private boolean _commit;
    private int _commitRows;
    private boolean _separateDataFile;
    private boolean _ldrLogFile = true;
    private String _ldrLogDir;
    private boolean _ldrBadFile = false;
    private String _ldrBadDir;
    private String _title;
    private String _subject;
    private String _keywords;
    private boolean _useConfigOptions = true;
    private int _variableLengthMax = -1;

    public ExtractDataFormat(int usage, String format) {
        super(usage, format);
    }

    public ExtractDataFormat(int usage) {
        super(usage);
    }

    public boolean isExportEnabled() {
        return this._exportEnabled;
    }

    public void isExportEnabled(boolean value) {
        this._exportEnabled = value;
    }

    public IResultFormatter getFormatter() {
        return this._formatter;
    }

    public boolean getHeader() {
        return this._options != null && this._options.isHeaderOptionSupported() ? this._header : false;
    }

    public void setHeader(boolean value) {
        if (this._options == null) {
            return;
        }
        this._header = value;
    }

    public boolean isSeparateDataFile() {
        return this._options != null && ((IExportFormatOptions)this._options).isSeparateDataFileSupported() ? this._separateDataFile : false;
    }

    public void isSeparateDataFile(boolean value) {
        if (this._options == null) {
            return;
        }
        this._separateDataFile = value;
    }

    public boolean isCommit() {
        return this._options != null && ((IExportFormatOptions)this._options).isCommitSupported() ? this._commit : false;
    }

    public void isCommit(boolean value) {
        if (this._options == null) {
            return;
        }
        this._commit = value;
    }

    public int getCommitRows() {
        return this._options != null && ((IExportFormatOptions)this._options).isCommitSupported() ? this._commitRows : 0;
    }

    public void setCommitRows(int value) {
        if (this._options == null) {
            return;
        }
        this._commitRows = value;
    }

    public boolean isTableNameVisible() {
        return this._isTableNameVisible;
    }

    public void isTableNameVisible(boolean value) {
        this._isTableNameVisible = value;
    }

    public String getTableName() {
        return this._options != null && ((IExportFormatOptions)this._options).isTableNameSupported() ? this._tableName : "";
    }

    public void setTableName(String value) {
        if (this._options == null) {
            return;
        }
        this._tableName = value;
    }

    public boolean isQuerySaved() {
        return this._saveQuery;
    }

    public void isQuerySaved(boolean value) {
        this._saveQuery = value;
    }

    public String getQueryName() {
        return this._queryName != null ? this._queryName : "";
    }

    public void setQueryName(String value) {
        this._queryName = value;
    }

    public String getDataName() {
        return this._dataName != null ? this._dataName : "";
    }

    public void setDataName(String value) {
        this._dataName = value;
    }

    public int getVariableLengthMax() {
        return this._variableLengthMax;
    }

    public void setVariableLengthMax(int value) {
        this._variableLengthMax = value;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getTitle() {
        return this._title;
    }

    public void setSubject(String subject) {
        this._subject = subject;
    }

    public String getSubject() {
        return this._subject;
    }

    public void setKeywords(String keywords) {
        this._keywords = keywords;
    }

    public String getKeywords() {
        return this._keywords;
    }

    public void setFormat(String value, boolean initFormat) {
        super.setFormat(value);
        if (initFormat) {
            this.initConfigFormatOptions();
        }
    }

    @Override
    public void setFormat(String value) {
        super.setFormat(value);
        this.initConfigFormatOptions();
    }

    public void setFormat(String value, boolean initFormat, IStorage config) {
        super.setFormat(value);
        if (initFormat) {
            this.initConfigFormatOptions(config);
        }
    }

    public void setFormat(String value, IStorage config) {
        super.setFormat(value);
        this.initConfigFormatOptions(config);
    }

    public String getFileExtension() {
        if (this._exportEnabled && this._formatter != null) {
            return this._formatter.getExt();
        }
        return "sql";
    }

    public boolean isTextEditorReadable() {
        if (this._exportEnabled && this._formatter != null) {
            return this._formatter.isTextEditorReadable();
        }
        return false;
    }

    public boolean isStandardEncodings() {
        if (this._exportEnabled && this._formatter != null) {
            return this._formatter.isStandardEncodings();
        }
        return false;
    }

    public String[] getEncodings() {
        if (this._exportEnabled && this._formatter != null) {
            return this._formatter.getEncodings();
        }
        return null;
    }

    public boolean isTruncate() {
        return this._isTruncate;
    }

    public void isTruncate(boolean value) {
        this._isTruncate = value;
    }

    public boolean isDisableConstraints() {
        return this._isDisableConstraints;
    }

    public void isDisableConstraints(boolean value) {
        this._isDisableConstraints = value;
    }

    @Override
    protected void initFormat() {
        IStorage config = ICommonConfig.Storage.getInstance();
        if (this._usage == EXPORT_WIZARD || this._format == null || this._format.length() == 0) {
            super.setFormat(config.getString("EXPORT_DATA_FORMAT"));
        }
        this.initExportConfigOptions();
    }

    protected void initExportConfigOptions() {
        IStorage config = ICommonConfig.Storage.getInstance();
        this.initExportConfigOptions(config);
    }

    protected void initExportConfigOptions(IStorage config) {
        Boolean x = config.getBoolean("EXPORT_DATA_ENABLED");
        if (x != null) {
            this._exportEnabled = x;
        }
        this.initConfigFormatOptions(config);
    }

    public void initConfigFormatOptions() {
        IStorage config = ICommonConfig.Storage.getInstance();
        this.initConfigFormatOptions(config);
    }

    public void initConfigFormatOptions(IStorage config) {
        IResultFormatter formatter;
        Boolean x;
        super.initConfigOptions(config);
        IExportFormatOptions exportOptions = (IExportFormatOptions)this._options;
        if (exportOptions.isSeparateDataFileSupported() && (x = config.getBoolean(exportOptions.getSeparateDataFileConfigKey())) != null) {
            this._separateDataFile = x;
        }
        if (exportOptions.isCommitSupported()) {
            x = config.getBoolean(exportOptions.getCommitConfigKey());
            if (x != null) {
                this._commit = x;
            }
            this._commitRows = config.getInt(exportOptions.getCommitRowsConfigKey());
        }
        if (exportOptions.isDataNameSupported()) {
            this._dataName = config.getString(exportOptions.getDataNameConfigKey());
        }
        if (exportOptions.isQuerySupported()) {
            x = config.getBoolean(exportOptions.getQueryConfigKey());
            if (x != null) {
                this._saveQuery = x;
            }
            this._queryName = config.getString(exportOptions.getQueryNameConfigKey());
        }
        if ((x = config.getBoolean("EXPORT_LDR_LOG_FILE")) != null) {
            this._ldrLogFile = x;
        }
        this._ldrLogDir = config.getString("EXPORT_LDR_LOG_DIR");
        x = config.getBoolean("EXPORT_LDR_BAD_FILE");
        if (x != null) {
            this._ldrBadFile = x;
        }
        this._ldrBadDir = config.getString("EXPORT_LDR_BAD_DIR");
        String format = this.getFormat();
        String PDF = "PDF";
        String PDF_EXT = "pdf";
        if ((format != null && format.equals(PDF) || format.equals(PDF_EXT)) && (formatter = FormatRegistry.getFormatter((String)format)) != null && this._useConfigOptions) {
            this.setTitle(config.getString("PDF_TITLE"));
            this.setSubject(config.getString("PDF_SUBJECT"));
            this.setKeywords(config.getString("PDF_KEYWORDS"));
        }
    }

    public void saveBasicPreferences(IStorage config) {
        config.putBoolean("EXPORT_DATA_ENABLED", this.isExportEnabled());
        config.putString("EXPORT_DATA_FORMAT", this._format);
    }

    @Override
    public void saveFormatPreferences(IStorage config) {
        super.saveFormatPreferences(config);
        IExportFormatOptions exportOptions = (IExportFormatOptions)this._options;
        if (exportOptions.isSeparateDataFileSupported()) {
            config.putBoolean(exportOptions.getSeparateDataFileConfigKey(), this._separateDataFile);
        }
        if (exportOptions.isCommitSupported()) {
            config.putBoolean(exportOptions.getCommitConfigKey(), this._commit);
            config.putInt(exportOptions.getCommitRowsConfigKey(), this._commitRows);
        }
        if (exportOptions.isDataNameSupported()) {
            config.putString(exportOptions.getDataNameConfigKey(), this._dataName);
        }
        if (exportOptions.isQuerySupported()) {
            config.putBoolean(exportOptions.getQueryConfigKey(), this._saveQuery);
            config.putString(exportOptions.getQueryNameConfigKey(), this._queryName);
        }
    }

    public void setUseConfigOptions(boolean useConfig) {
        this._useConfigOptions = useConfig;
    }

    public boolean useConfigOptions() {
        return this._useConfigOptions;
    }

    static {
        ExportDataFormatConfig.DefaultInitializer.init();
        LDR_DEFAULT_DELIMITER = "|";
        SCHEMA = "SCHEMA";
    }
}

