/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.langdata.commands.handler;

import java.util.List;
import oracle.dbtools.core.feature.flags.FeatureFlag;
import oracle.dbtools.extension.MultiCommandSQLCLService;
import oracle.dbtools.extension.langdata.Messages;
import oracle.dbtools.extension.langdata.commands.LangDataCommand;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;

public class LangDataExtension
implements MultiCommandSQLCLService {
    private static final FeatureFlag LANG_DATA_FEATURE = FeatureFlag.of((CharSequence)"sqlcl", (CharSequence)"langdata");

    public List<Class<? extends CommandListener>> getCommandListeners() {
        if (Boolean.TRUE.equals(LangDataExtension.isLandDataEnabled())) {
            return List.of(LangDataCommand.class);
        }
        return List.of();
    }

    public Class<? extends CommandListener> getCommandListener() {
        return null;
    }

    public String getExtensionDescription() {
        return Messages.getString("EXTENSION_DESC");
    }

    public String getExtensionName() {
        return Messages.getString("EXTENSION_NAME");
    }

    public String getExtensionVersion() {
        return Messages.getString("SQLclVersion.VERSION");
    }

    private static Boolean isLandDataEnabled() {
        Boolean langDataFeatureFlag = LangDataFeatureFlag.getLangDataEnabledOverride();
        if (langDataFeatureFlag != null) {
            return langDataFeatureFlag;
        }
        return LANG_DATA_FEATURE.isEnabled();
    }

    public static class LangDataFeatureFlag {
        private static final ThreadLocal<Boolean> langDataEnabledOverride = new ThreadLocal();

        private LangDataFeatureFlag() {
        }

        public static void setLangDataEnabledOverride(Boolean enabled) {
            langDataEnabledOverride.set(enabled);
        }

        public static Boolean getLangDataEnabledOverride() {
            return langDataEnabledOverride.get();
        }

        public static void removeLangDataEnabledOverride() {
            langDataEnabledOverride.remove();
        }
    }
}

