/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.langdata.commands.config.subcommand;

import java.sql.Connection;
import java.util.Arrays;
import oracle.dbtools.extension.langdata.commands.ConfigMessages;
import oracle.dbtools.extension.langdata.commands.handler.CommandInterface;
import oracle.dbtools.extension.langdata.commands.handler.LangDataOptions;
import oracle.dbtools.extension.langdata.core.LangDataConfig;
import oracle.dbtools.extension.langdata.core.exceptions.LangDataException;
import oracle.dbtools.extension.langdata.core.messages.GeneralMessages;
import oracle.dbtools.extension.langdata.core.utils.ConfigUtils;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ConfigImportCommand
implements CommandInterface {
    @Override
    public void run(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        LangDataConfig.setupDebugVerbose(parsedCommand);
        String filepath = (String)parsedCommand.getOptionValue((Id)LangDataOptions.Symbols.FILEPATH);
        try {
            ConfigUtils.importConfigFromJsonFile(filepath, conn);
            GeneralMessages.successMessage(ConfigMessages.getString("IMPORT_SUCCESS"));
        }
        catch (LangDataException e) {
            if (LangDataConfig.isDebug()) {
                ctx.writeln(Arrays.toString(e.getStackTrace()));
            }
            GeneralMessages.errorMessage(e.getLocalizedMessage());
        }
    }
}

