/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.langdata.commands.config.subcommand;

import java.io.IOException;
import java.sql.Connection;
import java.util.Arrays;
import oracle.dbtools.extension.langdata.commands.ConfigMessages;
import oracle.dbtools.extension.langdata.commands.handler.CommandInterface;
import oracle.dbtools.extension.langdata.commands.handler.LangDataOptions;
import oracle.dbtools.extension.langdata.core.LangDataConfig;
import oracle.dbtools.extension.langdata.core.exceptions.SQLQueryExecutionException;
import oracle.dbtools.extension.langdata.core.messages.GeneralMessages;
import oracle.dbtools.extension.langdata.core.utils.ConfigUtils;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ConfigExportCommand
implements CommandInterface {
    @Override
    public void run(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        LangDataConfig.setupDebugVerbose(parsedCommand);
        String directory = (String)parsedCommand.getOptionValue((Id)LangDataOptions.Symbols.DIRECTORY);
        try {
            ConfigUtils.writeJsonToFile(directory, ConfigUtils.getConfigListJson(ConfigUtils.getLangdataConfig(conn)));
            GeneralMessages.successMessage(ConfigMessages.format("EXPORT_SUCCESS", directory));
        }
        catch (IOException | SQLQueryExecutionException e) {
            if (LangDataConfig.isDebug()) {
                ctx.writeln(Arrays.toString(e.getStackTrace()));
            }
            GeneralMessages.errorMessage(e.getLocalizedMessage());
        }
    }
}

