/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.mcp.container;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.server.transport.StdioServerTransportProvider;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.SQLCLServices;
import oracle.dbtools.extension.mcp.prompts.ConnectionHelper;
import oracle.dbtools.extension.mcp.tools.ConnectTool;
import oracle.dbtools.extension.mcp.tools.DisconnectTool;
import oracle.dbtools.extension.mcp.tools.ListConnectionsTool;
import oracle.dbtools.extension.mcp.tools.RunSqlCLTool;
import oracle.dbtools.extension.mcp.tools.RunSqlTool;
import oracle.dbtools.mcp.api.Mcp;
import oracle.dbtools.mcp.api.TransportCloseWatcher;
import oracle.dbtools.mcp.container.Services;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class ExistingMcpContainer
implements Mcp.Stdio {
    private final McpSyncServer syncServer;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Runnable onClose;

    public ExistingMcpContainer(Builder builder) {
        Logger.getLogger("io.modelcontextprotocol.server.transport.StdioServerTransportProvider").setLevel(Level.OFF);
        System.err.println("---------- MCP SERVER STARTUP ----------");
        System.err.println("MCP Server started successfully on " + String.valueOf(new Date()));
        System.err.println("Press Ctrl+C to stop the server");
        System.err.println("----------------------------------------");
        SQLCLServices.getInstance().registerServices();
        TransportCloseWatcher transportProvider = TransportCloseWatcher.of((McpServerTransportProvider)new StdioServerTransportProvider(builder.find(ObjectMapper.class).orElseGet(ObjectMapper::new), builder.input(), builder.output()));
        this.onClose = () -> builder.onClose().forEach(Runnable::run);
        transportProvider.onClose(this::shutdown);
        ScriptRunnerContext ctx = builder.find(ScriptRunnerContext.class).orElseGet(ScriptRunnerContext::new);
        this.syncServer = McpServer.sync((McpServerTransportProvider)transportProvider).serverInfo("sqlcl-mcp-server", "1.0.0").capabilities(McpSchema.ServerCapabilities.builder().resources(Boolean.valueOf(true), Boolean.valueOf(true)).tools(Boolean.valueOf(true)).prompts(Boolean.valueOf(true)).logging().build()).tools(new McpServerFeatures.SyncToolSpecification[]{new RunSqlTool().create(ctx), new ListConnectionsTool().create(ctx), new ConnectTool().create(ctx), new DisconnectTool().create(ctx), new RunSqlCLTool().create(ctx)}).prompts(new McpServerFeatures.SyncPromptSpecification[]{new ConnectionHelper().create()}).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private void shutdown() {
        if (this.closed.compareAndSet(false, true)) {
            this.onClose.run();
        }
    }

    @Override
    public void close() {
        this.syncServer.close();
    }

    public static class Builder
    extends Mcp.Stdio.Builder {
        private final Services services = Services.of();

        private Builder() {
        }

        @Override
        protected ExistingMcpContainer newContainer() {
            return new ExistingMcpContainer(this);
        }

        @Override
        public <T> Builder set(Class<T> serviceType, T service) {
            this.services.set(serviceType, service);
            return this;
        }

        @Override
        public <T> Optional<T> find(Class<T> service) {
            return this.services.find(service);
        }
    }
}

