/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.mcp.api;

import com.fasterxml.jackson.core.type.TypeReference;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerSession;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import java.util.concurrent.atomic.AtomicBoolean;
import reactor.core.publisher.Mono;

public class TransportCloseWatcher
implements McpServerTransportProvider {
    private final McpServerTransportProvider target;
    private Runnable onClose;
    private final AtomicBoolean closed;

    private TransportCloseWatcher(McpServerTransportProvider target) {
        this.target = target;
        this.onClose = () -> {};
        this.closed = new AtomicBoolean();
    }

    public static TransportCloseWatcher of(McpServerTransportProvider target) {
        return new TransportCloseWatcher(target);
    }

    public void setSessionFactory(McpServerSession.Factory sessionFactory) {
        this.target.setSessionFactory(sessionTransport -> new SessionCloseWatcher(sessionFactory.create(sessionTransport), this::shutdown));
    }

    public Mono<Void> notifyClients(String method, Object params) {
        return this.target.notifyClients(method, params);
    }

    private void shutdown() {
        if (this.closed.compareAndSet(false, true)) {
            this.onClose.run();
        }
    }

    public Mono<Void> closeGracefully() {
        return this.target.closeGracefully().then(Mono.fromRunnable(this::shutdown));
    }

    public void onClose(Runnable onClose) {
        this.onClose = onClose == null ? () -> {} : onClose;
    }

    private static class SessionCloseWatcher
    extends McpServerSession {
        private final McpServerSession target;
        private final Runnable onClose;

        public SessionCloseWatcher(McpServerSession target, Runnable onClose) {
            super(null, null, null, null, null, null);
            this.target = target;
            this.onClose = onClose;
        }

        public String getId() {
            return this.target.getId();
        }

        public void init(McpSchema.ClientCapabilities clientCapabilities, McpSchema.Implementation clientInfo) {
            this.target.init(clientCapabilities, clientInfo);
        }

        public <T> Mono<T> sendRequest(String method, Object requestParams, TypeReference<T> typeRef) {
            return this.target.sendRequest(method, requestParams, typeRef);
        }

        public Mono<Void> sendNotification(String method) {
            return this.target.sendNotification(method);
        }

        public Mono<Void> sendNotification(String method, Object params) {
            return this.target.sendNotification(method, params);
        }

        public Mono<Void> handle(McpSchema.JSONRPCMessage message) {
            return this.target.handle(message);
        }

        public Mono<Void> closeGracefully() {
            return this.target.closeGracefully();
        }

        public String toString() {
            return this.target.toString();
        }

        public void close() {
            this.closeGracefully();
            this.onClose.run();
        }
    }
}

