/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.mcp.api;

import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import oracle.dbtools.mcp.api.McpStdioContainers;
import oracle.dbtools.mcp.api.TransportCloseWatcher;

public abstract class Mcp {
    public static Stdio.Builder stdio() {
        return McpStdioContainers.stdio();
    }

    public static interface Stdio
    extends AutoCloseable {
        @Override
        public void close();

        public static abstract class Builder {
            private OutputStream output;
            private InputStream input = System.in;
            private final List<Runnable> onClose;

            protected Builder() {
                this.output = System.out;
                this.onClose = new ArrayList<Runnable>();
            }

            public final Stdio build() {
                return this.newContainer();
            }

            public List<Runnable> onClose() {
                return this.onClose;
            }

            public Builder onClose(Runnable task) {
                this.onClose.add(task);
                return this;
            }

            public InputStream input() {
                return this.input;
            }

            public Builder input(InputStream input) {
                this.input = input;
                return this;
            }

            public OutputStream output() {
                return this.output;
            }

            public Builder output(OutputStream output) {
                this.output = output;
                return this;
            }

            public abstract <T> Builder set(Class<T> var1, T var2);

            protected abstract Stdio newContainer();

            public boolean enabled(String[] args) {
                return args.length > 0 && args[0].equals("-mcp");
            }

            public abstract <T> Optional<T> find(Class<T> var1);
        }
    }

    public static interface Feature {
        public void configure(Definition var1);
    }

    public static interface Definition
    extends Context {
        public McpServer.SyncSpecification specification();
    }

    public static interface Context {
        public <T> Optional<T> find(Class<T> var1);
    }

    public static interface Container
    extends AutoCloseable {
        @Override
        public void close();

        public static abstract class Builder
        implements Definition {
            private final Context context;
            private final McpServer.SyncSpecification specification;
            private final TransportCloseWatcher closeWatcher;

            protected Builder(Context context, McpServerTransportProvider transportProvider) {
                this.context = context;
                this.closeWatcher = TransportCloseWatcher.of(transportProvider);
                this.specification = McpServer.sync((McpServerTransportProvider)this.closeWatcher);
            }

            public Context context() {
                return this.context;
            }

            @Override
            public <T> Optional<T> find(Class<T> service) {
                return this.context().find(service);
            }

            @Override
            public McpServer.SyncSpecification specification() {
                return this.specification;
            }

            public Builder register(Feature feature) {
                feature.configure(this);
                return this;
            }

            public Builder loadFeatures() {
                ServiceLoader.load(Feature.class).forEach(this::register);
                return this;
            }

            public abstract Container build();

            public Builder onClose(Runnable task) {
                this.closeWatcher.onClose(task);
                return this;
            }
        }
    }
}

