/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mcp.utils;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import oracle.dbtools.core.collections.ConfigurationProperties;
import oracle.dbtools.core.connections.ConnectionException;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.connections.storage.ConnectionStorage;
import oracle.dbtools.core.oci.AuthenticationProvider;
import oracle.dbtools.core.oci.DatabaseDetails;
import oracle.dbtools.core.oci.InstancePrincipalProvider;
import oracle.dbtools.core.oci.Messages;
import oracle.dbtools.core.oci.OCIClientException;
import oracle.dbtools.core.oci.OCIDBToolsConnection;
import oracle.dbtools.core.oci.OCIDatabaseClient;
import oracle.dbtools.core.oci.OCIProfile;
import oracle.dbtools.core.oci.OCIProfiles;
import oracle.dbtools.extension.mcp.utils.ConnectionDetailsFactory;
import oracle.dbtools.extension.mcp.utils.ConnectionFilter;

public class ConnectionUtils {
    private static List<ConnectionDetailsFactory.ConnectionDetails> loadConnections(boolean showDetails) {
        ConnectionStorage storage = ConnectionStorage.instance();
        ConnectionDetailsFactory displayFactory = ConnectionDetailsFactory.of(storage, showDetails);
        return storage.listConnectionDirectories().stream().map(identifier -> displayFactory.createConnectionDisplay((String)identifier)).collect(Collectors.toUnmodifiableList());
    }

    public static List<ConnectionDetailsFactory.ConnectionDetails> listConnections(boolean showDetails, ConnectionFilter ... filters) {
        List<ConnectionDetailsFactory.ConnectionDetails> connections = ConnectionUtils.loadConnections(showDetails);
        return connections.stream().filter(r -> ConnectionFilter.createFilterChain(filters).match((ConnectionDetailsFactory.ConnectionDetails)r)).collect(Collectors.toUnmodifiableList());
    }

    static DatabaseDetails getConnectionDetails(ConnectionDetailsFactory.ConnectionDetails connection) {
        DatabaseDetails dbDetails = null;
        ConnectionDefinition connectionDefinition = connection.getConnectionDefinition();
        ConfigurationProperties props = connectionDefinition.getDbtoolsProperties();
        try {
            InstancePrincipalProvider authenticationProvider;
            String authenticationType = (String)props.getOrDefault((Object)"ociAuthenticationMethod", (Object)"PROFILE");
            String region = null;
            if ("PROFILE".equals(authenticationType)) {
                OCIProfiles profiles;
                OCIProfile profile;
                String profileName = props.getProperty((CharSequence)"ociProfile");
                if (profileName == null) {
                    profileName = "DEFAULT";
                }
                if ((profile = (profiles = OCIProfiles.builder().build()).getProfile(profileName)) == null) {
                    throw OCIClientException.of((Throwable)new IllegalStateException(Messages.format((String)"OCI_MISSING_PROFILE", (Object[])new Object[]{profileName})));
                }
                profile = profile.wrap(props);
                region = props.getProperty((CharSequence)"ociRegion");
                authenticationProvider = profile;
            } else if ("INSTANCE_PRINCIPAL".equals(authenticationType)) {
                authenticationProvider = InstancePrincipalProvider.builder().build();
            } else {
                throw ConnectionException.of((String)Messages.format((String)"OCI_INVALID_AUTHENTICATION_TYPE", (Object[])new Object[]{authenticationType}));
            }
            OCIDatabaseClient.Builder dbClientBuilder = OCIDatabaseClient.builder((AuthenticationProvider)authenticationProvider);
            if (region != null) {
                dbClientBuilder.region(region);
            }
            OCIDatabaseClient client = dbClientBuilder.build();
            String ocid = props.getProperty((CharSequence)"databaseToolsConnectionId");
            OCIDBToolsConnection ocidbToolsConnection = client.createDBToolsConnection(ocid);
            dbDetails = DatabaseDetails.of((OCIDBToolsConnection)ocidbToolsConnection);
        }
        catch (IOException | OCIClientException e) {
            throw ConnectionException.of((Throwable)e);
        }
        return dbDetails;
    }
}

