/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mcp.utils;

import java.util.Collection;
import oracle.dbtools.core.connections.helpers.ConnectionHelper;
import oracle.dbtools.core.connections.helpers.ConnectionHelperContext;
import oracle.dbtools.core.connections.helpers.ConnectionHelperFactory;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.connections.storage.ConnectionReference;
import oracle.dbtools.core.connections.storage.ConnectionStorage;

public abstract class ConnectionDetailsFactory {
    protected final ConnectionStorage connectionStorage;

    public static ConnectionDetailsFactory of(ConnectionStorage connectionStorage, boolean showDetails) {
        return showDetails ? new ExtendedConnectionDetailsFactory(connectionStorage) : new BasicConnectionDetailsFactory(connectionStorage);
    }

    protected ConnectionDetailsFactory(ConnectionStorage connectionStorage) {
        this.connectionStorage = connectionStorage;
    }

    public abstract ConnectionDetails createConnectionDisplay(String var1);

    private static class ExtendedConnectionDetailsFactory
    extends ConnectionDetailsFactory {
        private ExtendedConnectionDetailsFactory(ConnectionStorage connectionStorage) {
            super(connectionStorage);
        }

        @Override
        public ConnectionDetails createConnectionDisplay(String connectionIdentifier) {
            final ConnectionDefinition connectionDefinition = this.connectionStorage.loadConnection(connectionIdentifier);
            return new ConnectionDetails(){

                @Override
                public String getConnectionName() {
                    return connectionDefinition.getConnectionName();
                }

                @Override
                public String getConnectionDisplay() {
                    ConnectionHelper helper = ConnectionHelperFactory.findHelper((ConnectionHelperContext)ConnectionHelperContext.of((ConnectionDefinition)connectionDefinition, null));
                    Collection displayEntries = helper.getDisplayProperties();
                    StringBuilder sb = new StringBuilder();
                    if (displayEntries == null || displayEntries.isEmpty()) {
                        sb.append("No details found");
                    } else {
                        for (ConnectionHelper.DisplayEntry entry : displayEntries) {
                            sb.append(entry.getDisplayOutput());
                        }
                    }
                    return sb.toString();
                }

                @Override
                public String getConnectionProperty(String key) {
                    return connectionDefinition.getDbtoolsProperties().getProperty((CharSequence)key);
                }

                @Override
                public ConnectionDefinition getConnectionDefinition() {
                    return connectionDefinition;
                }
            };
        }
    }

    private static class BasicConnectionDetailsFactory
    extends ConnectionDetailsFactory {
        private BasicConnectionDetailsFactory(ConnectionStorage connectionStorage) {
            super(connectionStorage);
        }

        @Override
        public ConnectionDetails createConnectionDisplay(String connectionIdentifier) {
            final ConnectionReference connectionReference = this.connectionStorage.loadConnectionReference(connectionIdentifier);
            return new ConnectionDetails(){

                @Override
                public String getConnectionName() {
                    return connectionReference.getConnectionName();
                }

                @Override
                public String getConnectionDisplay() {
                    return this.getConnectionName();
                }

                @Override
                public String getConnectionProperty(String key) {
                    return connectionReference.getDbtoolsProperty(key);
                }

                @Override
                public ConnectionDefinition getConnectionDefinition() {
                    return connectionReference.getConnectionDefinition();
                }
            };
        }
    }

    public static abstract class ConnectionDetails {
        public abstract String getConnectionName();

        public abstract String getConnectionDisplay();

        public abstract String getConnectionProperty(String var1);

        public abstract ConnectionDefinition getConnectionDefinition();
    }
}

