/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mcp.tools;

import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import oracle.dbtools.extension.mcp.exceptions.ArgumentException;
import oracle.dbtools.extension.mcp.exceptions.AuditTableException;
import oracle.dbtools.extension.mcp.schemas.Schemas;
import oracle.dbtools.extension.mcp.tools.McpTool;
import oracle.dbtools.extension.mcp.utils.McpUtils;
import oracle.dbtools.mcp.McpMessages;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class DisconnectTool
implements McpTool {
    private final String toolName = "disconnect";

    @Override
    public McpServerFeatures.SyncToolSpecification create(ScriptRunnerContext ctx) {
        return new McpServerFeatures.SyncToolSpecification(new McpSchema.Tool("disconnect", "This tool performs a disconnection from the current session in an Oracle database. If a user is connected, it logs out cleanly and returns to the SQL prompt without an active database connection." + McpUtils.MCP_FIXED_ARGS_PROMPT, Schemas.getSchema(Schemas.SchemaName.DISCONNECT_SCHEMA)), (exchange, arguments) -> {
            ArrayList<McpSchema.TextContent> contents = new ArrayList<McpSchema.TextContent>();
            try {
                String model = McpUtils.optionalArgument(arguments, "model", McpUtils.MODEL_DEFAULT_VALUE);
                String mcp_client = exchange.getClientInfo().name();
                if (model.isEmpty()) {
                    throw new ArgumentException(McpMessages.getString("MODEL_NAME_REQUIRED"));
                }
                if (mcp_client.isEmpty()) {
                    throw new ArgumentException(McpMessages.getString("CLIENT_NAME_REQUORED"));
                }
                if (ctx.getCurrentConnection() != null && !ctx.getCurrentConnection().isClosed()) {
                    McpUtils.mcpLogs(ctx, "disconnect", model, mcp_client, McpUtils.McpCapabilities.TOOL, McpMessages.format("DISCONNECT_LOG_MESSAGE", ctx.getCurrentConnection().getSchema()));
                    ctx.getCurrentConnection().close();
                    ctx.setCurrentConnection(null);
                    contents.add(new McpSchema.TextContent(McpMessages.getString("DISCONNECTED_SUCCESSFULLY")));
                } else {
                    contents.add(new McpSchema.TextContent(McpMessages.getString("NO_ACTIVE_DB")));
                }
            }
            catch (SQLException | ArgumentException | AuditTableException e) {
                return new McpSchema.CallToolResult(Collections.singletonList(new McpSchema.TextContent(McpMessages.format("MCP_ERROR", ((Throwable)e).getLocalizedMessage()))), Boolean.valueOf(true));
            }
            return new McpSchema.CallToolResult(contents, Boolean.valueOf(false));
        });
    }
}

