/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetPrivateIpRequest
extends BmcRequest<Void> {
    private String privateIpId;

    public String getPrivateIpId() {
        return this.privateIpId;
    }

    public Builder toBuilder() {
        return new Builder().privateIpId(this.privateIpId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",privateIpId=").append(String.valueOf(this.privateIpId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetPrivateIpRequest)) {
            return false;
        }
        GetPrivateIpRequest other = (GetPrivateIpRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.privateIpId, other.privateIpId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.privateIpId == null ? 43 : this.privateIpId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPrivateIpRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String privateIpId = null;

        public Builder privateIpId(String privateIpId) {
            this.privateIpId = privateIpId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPrivateIpRequest o) {
            this.privateIpId(o.getPrivateIpId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPrivateIpRequest build() {
            GetPrivateIpRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetPrivateIpRequest buildWithoutInvocationCallback() {
            GetPrivateIpRequest request = new GetPrivateIpRequest();
            request.privateIpId = this.privateIpId;
            return request;
        }
    }
}

