/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.core.model.NetworkingTopology;
import com.oracle.bmc.core.model.SubnetTopology;
import com.oracle.bmc.core.model.TopologyEntityRelationship;
import com.oracle.bmc.core.model.VcnTopology;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=Topology.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=VcnTopology.class, name="VCN"), @JsonSubTypes.Type(value=NetworkingTopology.class, name="NETWORKING"), @JsonSubTypes.Type(value=SubnetTopology.class, name="SUBNET")})
@JsonFilter(value="explicitlySetFilter")
public class Topology
extends ExplicitlySetBmcModel {
    @JsonProperty(value="entities")
    private final List<Object> entities;
    @JsonProperty(value="relationships")
    private final List<TopologyEntityRelationship> relationships;
    @JsonProperty(value="limitedEntities")
    private final List<String> limitedEntities;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;

    @Deprecated
    @ConstructorProperties(value={"entities", "relationships", "limitedEntities", "timeCreated"})
    protected Topology(List<Object> entities, List<TopologyEntityRelationship> relationships, List<String> limitedEntities, Date timeCreated) {
        this.entities = entities;
        this.relationships = relationships;
        this.limitedEntities = limitedEntities;
        this.timeCreated = timeCreated;
    }

    public List<Object> getEntities() {
        return this.entities;
    }

    public List<TopologyEntityRelationship> getRelationships() {
        return this.relationships;
    }

    public List<String> getLimitedEntities() {
        return this.limitedEntities;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Topology(");
        sb.append("super=").append(super.toString());
        sb.append("entities=").append(String.valueOf(this.entities));
        sb.append(", relationships=").append(String.valueOf(this.relationships));
        sb.append(", limitedEntities=").append(String.valueOf(this.limitedEntities));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Topology)) {
            return false;
        }
        Topology other = (Topology)((Object)o);
        return Objects.equals(this.entities, other.entities) && Objects.equals(this.relationships, other.relationships) && Objects.equals(this.limitedEntities, other.limitedEntities) && Objects.equals(this.timeCreated, other.timeCreated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.entities == null ? 43 : this.entities.hashCode());
        result = result * 59 + (this.relationships == null ? 43 : this.relationships.hashCode());
        result = result * 59 + (this.limitedEntities == null ? 43 : this.limitedEntities.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        Networking("NETWORKING"),
        Vcn("VCN"),
        Subnet("SUBNET"),
        Path("PATH"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

