/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InstanceConfigurationLaunchOptions
extends ExplicitlySetBmcModel {
    @JsonProperty(value="bootVolumeType")
    private final BootVolumeType bootVolumeType;
    @JsonProperty(value="firmware")
    private final Firmware firmware;
    @JsonProperty(value="networkType")
    private final NetworkType networkType;
    @JsonProperty(value="remoteDataVolumeType")
    private final RemoteDataVolumeType remoteDataVolumeType;
    @JsonProperty(value="isPvEncryptionInTransitEnabled")
    private final Boolean isPvEncryptionInTransitEnabled;
    @JsonProperty(value="isConsistentVolumeNamingEnabled")
    private final Boolean isConsistentVolumeNamingEnabled;

    @Deprecated
    @ConstructorProperties(value={"bootVolumeType", "firmware", "networkType", "remoteDataVolumeType", "isPvEncryptionInTransitEnabled", "isConsistentVolumeNamingEnabled"})
    public InstanceConfigurationLaunchOptions(BootVolumeType bootVolumeType, Firmware firmware, NetworkType networkType, RemoteDataVolumeType remoteDataVolumeType, Boolean isPvEncryptionInTransitEnabled, Boolean isConsistentVolumeNamingEnabled) {
        this.bootVolumeType = bootVolumeType;
        this.firmware = firmware;
        this.networkType = networkType;
        this.remoteDataVolumeType = remoteDataVolumeType;
        this.isPvEncryptionInTransitEnabled = isPvEncryptionInTransitEnabled;
        this.isConsistentVolumeNamingEnabled = isConsistentVolumeNamingEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public BootVolumeType getBootVolumeType() {
        return this.bootVolumeType;
    }

    public Firmware getFirmware() {
        return this.firmware;
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public RemoteDataVolumeType getRemoteDataVolumeType() {
        return this.remoteDataVolumeType;
    }

    public Boolean getIsPvEncryptionInTransitEnabled() {
        return this.isPvEncryptionInTransitEnabled;
    }

    public Boolean getIsConsistentVolumeNamingEnabled() {
        return this.isConsistentVolumeNamingEnabled;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InstanceConfigurationLaunchOptions(");
        sb.append("super=").append(super.toString());
        sb.append("bootVolumeType=").append(String.valueOf((Object)this.bootVolumeType));
        sb.append(", firmware=").append(String.valueOf((Object)this.firmware));
        sb.append(", networkType=").append(String.valueOf((Object)this.networkType));
        sb.append(", remoteDataVolumeType=").append(String.valueOf((Object)this.remoteDataVolumeType));
        sb.append(", isPvEncryptionInTransitEnabled=").append(String.valueOf(this.isPvEncryptionInTransitEnabled));
        sb.append(", isConsistentVolumeNamingEnabled=").append(String.valueOf(this.isConsistentVolumeNamingEnabled));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstanceConfigurationLaunchOptions)) {
            return false;
        }
        InstanceConfigurationLaunchOptions other = (InstanceConfigurationLaunchOptions)((Object)o);
        return Objects.equals((Object)this.bootVolumeType, (Object)other.bootVolumeType) && Objects.equals((Object)this.firmware, (Object)other.firmware) && Objects.equals((Object)this.networkType, (Object)other.networkType) && Objects.equals((Object)this.remoteDataVolumeType, (Object)other.remoteDataVolumeType) && Objects.equals(this.isPvEncryptionInTransitEnabled, other.isPvEncryptionInTransitEnabled) && Objects.equals(this.isConsistentVolumeNamingEnabled, other.isConsistentVolumeNamingEnabled) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.bootVolumeType == null ? 43 : this.bootVolumeType.hashCode());
        result = result * 59 + (this.firmware == null ? 43 : this.firmware.hashCode());
        result = result * 59 + (this.networkType == null ? 43 : this.networkType.hashCode());
        result = result * 59 + (this.remoteDataVolumeType == null ? 43 : this.remoteDataVolumeType.hashCode());
        result = result * 59 + (this.isPvEncryptionInTransitEnabled == null ? 43 : this.isPvEncryptionInTransitEnabled.hashCode());
        result = result * 59 + (this.isConsistentVolumeNamingEnabled == null ? 43 : this.isConsistentVolumeNamingEnabled.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum BootVolumeType implements BmcEnum
    {
        Iscsi("ISCSI"),
        Scsi("SCSI"),
        Ide("IDE"),
        Vfio("VFIO"),
        Paravirtualized("PARAVIRTUALIZED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, BootVolumeType> map;

        private BootVolumeType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BootVolumeType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'BootVolumeType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(BootVolumeType.class);
            map = new HashMap<String, BootVolumeType>();
            for (BootVolumeType v : BootVolumeType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Firmware implements BmcEnum
    {
        Bios("BIOS"),
        Uefi64("UEFI_64"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Firmware> map;

        private Firmware(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Firmware create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Firmware', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Firmware.class);
            map = new HashMap<String, Firmware>();
            for (Firmware v : Firmware.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum NetworkType implements BmcEnum
    {
        E1000("E1000"),
        Vfio("VFIO"),
        Paravirtualized("PARAVIRTUALIZED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, NetworkType> map;

        private NetworkType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static NetworkType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'NetworkType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(NetworkType.class);
            map = new HashMap<String, NetworkType>();
            for (NetworkType v : NetworkType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum RemoteDataVolumeType implements BmcEnum
    {
        Iscsi("ISCSI"),
        Scsi("SCSI"),
        Ide("IDE"),
        Vfio("VFIO"),
        Paravirtualized("PARAVIRTUALIZED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RemoteDataVolumeType> map;

        private RemoteDataVolumeType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RemoteDataVolumeType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RemoteDataVolumeType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RemoteDataVolumeType.class);
            map = new HashMap<String, RemoteDataVolumeType>();
            for (RemoteDataVolumeType v : RemoteDataVolumeType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="bootVolumeType")
        private BootVolumeType bootVolumeType;
        @JsonProperty(value="firmware")
        private Firmware firmware;
        @JsonProperty(value="networkType")
        private NetworkType networkType;
        @JsonProperty(value="remoteDataVolumeType")
        private RemoteDataVolumeType remoteDataVolumeType;
        @JsonProperty(value="isPvEncryptionInTransitEnabled")
        private Boolean isPvEncryptionInTransitEnabled;
        @JsonProperty(value="isConsistentVolumeNamingEnabled")
        private Boolean isConsistentVolumeNamingEnabled;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder bootVolumeType(BootVolumeType bootVolumeType) {
            this.bootVolumeType = bootVolumeType;
            this.__explicitlySet__.add("bootVolumeType");
            return this;
        }

        public Builder firmware(Firmware firmware) {
            this.firmware = firmware;
            this.__explicitlySet__.add("firmware");
            return this;
        }

        public Builder networkType(NetworkType networkType) {
            this.networkType = networkType;
            this.__explicitlySet__.add("networkType");
            return this;
        }

        public Builder remoteDataVolumeType(RemoteDataVolumeType remoteDataVolumeType) {
            this.remoteDataVolumeType = remoteDataVolumeType;
            this.__explicitlySet__.add("remoteDataVolumeType");
            return this;
        }

        public Builder isPvEncryptionInTransitEnabled(Boolean isPvEncryptionInTransitEnabled) {
            this.isPvEncryptionInTransitEnabled = isPvEncryptionInTransitEnabled;
            this.__explicitlySet__.add("isPvEncryptionInTransitEnabled");
            return this;
        }

        public Builder isConsistentVolumeNamingEnabled(Boolean isConsistentVolumeNamingEnabled) {
            this.isConsistentVolumeNamingEnabled = isConsistentVolumeNamingEnabled;
            this.__explicitlySet__.add("isConsistentVolumeNamingEnabled");
            return this;
        }

        public InstanceConfigurationLaunchOptions build() {
            InstanceConfigurationLaunchOptions model = new InstanceConfigurationLaunchOptions(this.bootVolumeType, this.firmware, this.networkType, this.remoteDataVolumeType, this.isPvEncryptionInTransitEnabled, this.isConsistentVolumeNamingEnabled);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InstanceConfigurationLaunchOptions model) {
            if (model.wasPropertyExplicitlySet("bootVolumeType")) {
                this.bootVolumeType(model.getBootVolumeType());
            }
            if (model.wasPropertyExplicitlySet("firmware")) {
                this.firmware(model.getFirmware());
            }
            if (model.wasPropertyExplicitlySet("networkType")) {
                this.networkType(model.getNetworkType());
            }
            if (model.wasPropertyExplicitlySet("remoteDataVolumeType")) {
                this.remoteDataVolumeType(model.getRemoteDataVolumeType());
            }
            if (model.wasPropertyExplicitlySet("isPvEncryptionInTransitEnabled")) {
                this.isPvEncryptionInTransitEnabled(model.getIsPvEncryptionInTransitEnabled());
            }
            if (model.wasPropertyExplicitlySet("isConsistentVolumeNamingEnabled")) {
                this.isConsistentVolumeNamingEnabled(model.getIsConsistentVolumeNamingEnabled());
            }
            return this;
        }
    }
}

