/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class IPSecConnection
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="cpeId")
    private final String cpeId;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="drgId")
    private final String drgId;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="cpeLocalIdentifier")
    private final String cpeLocalIdentifier;
    @JsonProperty(value="cpeLocalIdentifierType")
    private final CpeLocalIdentifierType cpeLocalIdentifierType;
    @JsonProperty(value="staticRoutes")
    private final List<String> staticRoutes;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="transportType")
    private final TransportType transportType;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "cpeId", "definedTags", "displayName", "drgId", "freeformTags", "id", "lifecycleState", "cpeLocalIdentifier", "cpeLocalIdentifierType", "staticRoutes", "timeCreated", "transportType"})
    public IPSecConnection(String compartmentId, String cpeId, Map<String, Map<String, Object>> definedTags, String displayName, String drgId, Map<String, String> freeformTags, String id, LifecycleState lifecycleState, String cpeLocalIdentifier, CpeLocalIdentifierType cpeLocalIdentifierType, List<String> staticRoutes, Date timeCreated, TransportType transportType) {
        this.compartmentId = compartmentId;
        this.cpeId = cpeId;
        this.definedTags = definedTags;
        this.displayName = displayName;
        this.drgId = drgId;
        this.freeformTags = freeformTags;
        this.id = id;
        this.lifecycleState = lifecycleState;
        this.cpeLocalIdentifier = cpeLocalIdentifier;
        this.cpeLocalIdentifierType = cpeLocalIdentifierType;
        this.staticRoutes = staticRoutes;
        this.timeCreated = timeCreated;
        this.transportType = transportType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getCpeId() {
        return this.cpeId;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDrgId() {
        return this.drgId;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String getId() {
        return this.id;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getCpeLocalIdentifier() {
        return this.cpeLocalIdentifier;
    }

    public CpeLocalIdentifierType getCpeLocalIdentifierType() {
        return this.cpeLocalIdentifierType;
    }

    public List<String> getStaticRoutes() {
        return this.staticRoutes;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public TransportType getTransportType() {
        return this.transportType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("IPSecConnection(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", cpeId=").append(String.valueOf(this.cpeId));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", drgId=").append(String.valueOf(this.drgId));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", cpeLocalIdentifier=").append(String.valueOf(this.cpeLocalIdentifier));
        sb.append(", cpeLocalIdentifierType=").append(String.valueOf((Object)this.cpeLocalIdentifierType));
        sb.append(", staticRoutes=").append(String.valueOf(this.staticRoutes));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", transportType=").append(String.valueOf((Object)this.transportType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IPSecConnection)) {
            return false;
        }
        IPSecConnection other = (IPSecConnection)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.cpeId, other.cpeId) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.drgId, other.drgId) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.cpeLocalIdentifier, other.cpeLocalIdentifier) && Objects.equals((Object)this.cpeLocalIdentifierType, (Object)other.cpeLocalIdentifierType) && Objects.equals(this.staticRoutes, other.staticRoutes) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.transportType, (Object)other.transportType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.cpeId == null ? 43 : this.cpeId.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.drgId == null ? 43 : this.drgId.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.cpeLocalIdentifier == null ? 43 : this.cpeLocalIdentifier.hashCode());
        result = result * 59 + (this.cpeLocalIdentifierType == null ? 43 : this.cpeLocalIdentifierType.hashCode());
        result = result * 59 + (this.staticRoutes == null ? 43 : this.staticRoutes.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.transportType == null ? 43 : this.transportType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Provisioning("PROVISIONING"),
        Available("AVAILABLE"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum CpeLocalIdentifierType implements BmcEnum
    {
        IpAddress("IP_ADDRESS"),
        Hostname("HOSTNAME"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, CpeLocalIdentifierType> map;

        private CpeLocalIdentifierType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CpeLocalIdentifierType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'CpeLocalIdentifierType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(CpeLocalIdentifierType.class);
            map = new HashMap<String, CpeLocalIdentifierType>();
            for (CpeLocalIdentifierType v : CpeLocalIdentifierType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum TransportType implements BmcEnum
    {
        Internet("INTERNET"),
        Fastconnect("FASTCONNECT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TransportType> map;

        private TransportType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TransportType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TransportType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TransportType.class);
            map = new HashMap<String, TransportType>();
            for (TransportType v : TransportType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="cpeId")
        private String cpeId;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="drgId")
        private String drgId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="cpeLocalIdentifier")
        private String cpeLocalIdentifier;
        @JsonProperty(value="cpeLocalIdentifierType")
        private CpeLocalIdentifierType cpeLocalIdentifierType;
        @JsonProperty(value="staticRoutes")
        private List<String> staticRoutes;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="transportType")
        private TransportType transportType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder cpeId(String cpeId) {
            this.cpeId = cpeId;
            this.__explicitlySet__.add("cpeId");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder drgId(String drgId) {
            this.drgId = drgId;
            this.__explicitlySet__.add("drgId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder cpeLocalIdentifier(String cpeLocalIdentifier) {
            this.cpeLocalIdentifier = cpeLocalIdentifier;
            this.__explicitlySet__.add("cpeLocalIdentifier");
            return this;
        }

        public Builder cpeLocalIdentifierType(CpeLocalIdentifierType cpeLocalIdentifierType) {
            this.cpeLocalIdentifierType = cpeLocalIdentifierType;
            this.__explicitlySet__.add("cpeLocalIdentifierType");
            return this;
        }

        public Builder staticRoutes(List<String> staticRoutes) {
            this.staticRoutes = staticRoutes;
            this.__explicitlySet__.add("staticRoutes");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder transportType(TransportType transportType) {
            this.transportType = transportType;
            this.__explicitlySet__.add("transportType");
            return this;
        }

        public IPSecConnection build() {
            IPSecConnection model = new IPSecConnection(this.compartmentId, this.cpeId, this.definedTags, this.displayName, this.drgId, this.freeformTags, this.id, this.lifecycleState, this.cpeLocalIdentifier, this.cpeLocalIdentifierType, this.staticRoutes, this.timeCreated, this.transportType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(IPSecConnection model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("cpeId")) {
                this.cpeId(model.getCpeId());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("drgId")) {
                this.drgId(model.getDrgId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("cpeLocalIdentifier")) {
                this.cpeLocalIdentifier(model.getCpeLocalIdentifier());
            }
            if (model.wasPropertyExplicitlySet("cpeLocalIdentifierType")) {
                this.cpeLocalIdentifierType(model.getCpeLocalIdentifierType());
            }
            if (model.wasPropertyExplicitlySet("staticRoutes")) {
                this.staticRoutes(model.getStaticRoutes());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("transportType")) {
                this.transportType(model.getTransportType());
            }
            return this;
        }
    }
}

