/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BlockVolumeReplicaDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="xrrKmsKeyId")
    private final String xrrKmsKeyId;

    @Deprecated
    @ConstructorProperties(value={"displayName", "availabilityDomain", "xrrKmsKeyId"})
    public BlockVolumeReplicaDetails(String displayName, String availabilityDomain, String xrrKmsKeyId) {
        this.displayName = displayName;
        this.availabilityDomain = availabilityDomain;
        this.xrrKmsKeyId = xrrKmsKeyId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getXrrKmsKeyId() {
        return this.xrrKmsKeyId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BlockVolumeReplicaDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", xrrKmsKeyId=").append(String.valueOf(this.xrrKmsKeyId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockVolumeReplicaDetails)) {
            return false;
        }
        BlockVolumeReplicaDetails other = (BlockVolumeReplicaDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.xrrKmsKeyId, other.xrrKmsKeyId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.xrrKmsKeyId == null ? 43 : this.xrrKmsKeyId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="xrrKmsKeyId")
        private String xrrKmsKeyId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder xrrKmsKeyId(String xrrKmsKeyId) {
            this.xrrKmsKeyId = xrrKmsKeyId;
            this.__explicitlySet__.add("xrrKmsKeyId");
            return this;
        }

        public BlockVolumeReplicaDetails build() {
            BlockVolumeReplicaDetails model = new BlockVolumeReplicaDetails(this.displayName, this.availabilityDomain, this.xrrKmsKeyId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BlockVolumeReplicaDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("xrrKmsKeyId")) {
                this.xrrKmsKeyId(model.getXrrKmsKeyId());
            }
            return this;
        }
    }
}

