/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.util;

import java.io.IOException;
import java.util.Formatter;
import java.util.Locale;
import lombok.Generated;
import oracle.dbtools.raptor.liquibase.util.LbUtils;

public class ProcessTimer {
    private final String action;
    private final boolean write;
    private long startTime;
    private long splitTime;
    private long endTime;
    private final StringBuilder sb = new StringBuilder();
    private boolean isSplit;

    public ProcessTimer(String action, boolean write) {
        this.action = action;
        this.write = write;
    }

    public ProcessTimer(String action, boolean write, boolean start) {
        this.action = action;
        this.write = write;
        if (start) {
            this.start();
        }
    }

    public String getResultString() {
        return this.sb.toString();
    }

    private String getFormattedTime(long timeMs) {
        StringBuilder mFormatBuilder = new StringBuilder();
        try (Formatter mFormatter = new Formatter(mFormatBuilder, Locale.getDefault());){
            long totalSeconds = timeMs / 1000L;
            long millis = timeMs % 1000L;
            long seconds = totalSeconds % 60L;
            long minutes = totalSeconds / 60L % 60L;
            long hours = totalSeconds / 3600L;
            mFormatBuilder.setLength(0);
            if (hours > 0L) {
                String string = mFormatter.format("%dh %dm %ds %dms", hours, minutes, seconds, millis).toString();
                return string;
            }
            if (minutes > 0L) {
                String string = mFormatter.format("%dm %ds %dms", minutes, seconds, millis).toString();
                return string;
            }
            if (seconds > 0L) {
                String string = mFormatter.format("%ds %dms", seconds, millis).toString();
                return string;
            }
            String string = mFormatter.format("%dms", millis).toString();
            return string;
        }
    }

    private void conditionalPrint(String line) {
        if (this.write) {
            LbUtils.getContext().write(line);
            try {
                LbUtils.getContext().getOutputStream().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void end() {
        this.endTime = System.currentTimeMillis();
        if (this.isSplit) {
            String format = "%1$-46s %2$10s";
            String tag = "[" + this.action + "]: ";
            String time = this.getFormattedTime(this.endTime - this.startTime);
            String line = String.format(format, tag, time);
            this.sb.append("\n").append(line).append("\n");
            this.conditionalPrint("\n" + line + "\n");
        } else {
            String format = "%1$-" + (42 - this.action.length()) + "s %2$10s";
            String tag = "";
            String time = this.getFormattedTime(this.endTime - this.startTime);
            String line = String.format(format, tag, time);
            this.sb.append(line).append("\n");
            this.conditionalPrint(line + "\n");
        }
    }

    public void split() {
        this.split("");
    }

    public void split(String msg) {
        if (!this.isSplit) {
            this.isSplit = true;
            this.sb.append("\n");
            this.conditionalPrint("\n");
        } else {
            this.endTime = System.currentTimeMillis();
            String format = "%1$-38s %2$10s";
            String tag = "[" + msg + "]: ";
            String time = this.getFormattedTime(this.endTime - this.splitTime);
            String line = "\t" + String.format(format, tag, time);
            this.sb.append(line).append("\n");
            this.conditionalPrint(line + "\n");
            this.splitTime = this.endTime;
        }
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        this.splitTime = System.currentTimeMillis();
        this.endTime = System.currentTimeMillis();
        this.sb.setLength(0);
        this.sb.append("[").append(this.action).append("]: ");
        this.conditionalPrint(this.sb.toString());
    }

    @Generated
    public void setSplit(boolean isSplit) {
        this.isSplit = isSplit;
    }
}

