/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.generator;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import liquibase.exception.LiquibaseException;
import lombok.Generated;
import lombok.NonNull;
import oracle.dbtools.app.SqlRecognizer;
import oracle.dbtools.raptor.liquibase.core.ActiveCommand;
import oracle.dbtools.raptor.liquibase.generator.ChangeSetFactory;
import oracle.dbtools.raptor.liquibase.generator.SchemaGeneratorUtils;
import oracle.dbtools.raptor.liquibase.generator.changesets.data.ChangeData;
import oracle.dbtools.raptor.liquibase.service.LbExecutorService;
import oracle.dbtools.raptor.liquibase.service.LbRunnable;
import oracle.dbtools.raptor.liquibase.service.LbThread;
import oracle.dbtools.raptor.liquibase.util.DbmsMetaUtils;
import oracle.dbtools.raptor.liquibase.util.LbFileUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.liquibase.util.LiquibaseStringUtils;
import oracle.dbtools.raptor.liquibase.util.ProcessTimer;
import oracle.dbtools.raptor.liquibase.util.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LBOptions;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.Messages;
import oracle.dbtools.util.Logger;

public class SchemaGenerator {
    public static final String REF_CONSTRAINT = "REF_CONSTRAINT";
    public static final String CONSTRAINT = "CONSTRAINT";
    public static final String DIMENSION = "DIMENSION";
    public static final String FUNCTION = "FUNCTION";
    public static final String PROCEDURE = "PROCEDURE";
    public static final String PACKAGE_SPEC = "PACKAGE_SPEC";
    public static final String PACKAGE_BODY = "PACKAGE_BODY";
    public static final String TYPE_SPEC = "TYPE_SPEC";
    public static final String TYPE_BODY = "TYPE_BODY";
    public static final String PUBLIC_SYNONYM = "PUBLIC_SYNONYM";
    public static final String SYNONYM = "SYNONYM";
    public static final String OBJECT_GRANT = "OBJECT_GRANT";
    public static final String DB_LINK = "DB_LINK";
    public static final String TRIGGER = "TRIGGER";
    public static final String JOB = "JOB";
    public static final String DIRECTORY = "DIRECTORY";
    public static final String COMMENT = "COMMENT";
    public static final String ROLE_GRANT = "ROLE_GRANT";
    public static final String SYSTEM_GRANT = "SYSTEM_GRANT";
    public static final String MATERIALIZED_VIEW_LOG = "MATERIALIZED_VIEW_LOG";
    public static final String MATERIALIZED_VIEW = "MATERIALIZED_VIEW";
    public static final String SEQUENCE = "SEQUENCE";
    public static final String CLUSTER = "CLUSTER";
    public static final String TABLE = "TABLE";
    public static final String VIEW = "VIEW";
    public static final String INDEX = "INDEX";
    public static final Map<String, String> typeNameTransform;
    public static final List<String> ddlTypes;
    public static final String CREATEORACLEGRANT = "createOracleGrant";
    public static final Map<String, String> ddlChangeTypes;
    public static final String CONTROLLERFOOTER = "</databaseChangeLog> \n";
    public static final String WRITE_SERVICE = "writeService";
    protected static Map<String, Integer> orderedTypesLong;
    final ConcurrentHashMap<String, Object> ret = new ConcurrentHashMap();
    private final Connection conn;
    private final LbExecutorService loadService;
    private final LbExecutorService writeService;
    private final ProcessTimer loadTimer = new ProcessTimer("Method loadCaptureTable", true, false);
    private final ProcessTimer totalTimer = new ProcessTimer("Total Time (Wall Clock)", false, false);
    private final ProcessTimer writeTimer = new ProcessTimer("Method writeChangeLogs", false, false);
    private final ActiveCommand command;
    private String SQLCL_SAVE_CAPTURE;
    private boolean capture;

    public SchemaGenerator() {
        this.conn = LbUtils.getContext().getCurrentConnection();
        this.command = LbUtils.getCommand();
        this.loadService = new LbExecutorService(LbUtils.getContext(), 5, 10, 1, TimeUnit.DAYS, "runService");
        this.writeService = new LbExecutorService(LbUtils.getContext(), 5, 10, 1, TimeUnit.DAYS, WRITE_SERVICE);
        try {
            this.SQLCL_SAVE_CAPTURE = LbUtils.getParameter("SAVE_CAPTURE");
        }
        catch (IOException e) {
            this.SQLCL_SAVE_CAPTURE = "OFF";
        }
    }

    public static void writeMasterLog(Path path) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(path.toFile()), StandardCharsets.UTF_8);){
            writer.write(SchemaGenerator.getMasterLog());
        }
    }

    public static String getMasterLog() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<databaseChangeLog\n  xmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog\n                      http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-latest.xsd\">\n  <include file=\"{filename.xml}\"/> \n</databaseChangeLog> \n";
    }

    private static String getQueryString(String oType) {
        String filesToWrite = oType != null ? "select object_name,object_type,rowid,object_doc from databasechangelog_export where object_type = ? and written = 0 and  rownum < 10 order by object_type, object_name for update skip locked" : "select object_name,object_type,rowid,object_doc from databasechangelog_export where written = 0 and  rownum < 10 order by object_type, object_name for update skip locked";
        return filesToWrite;
    }

    public Map<String, Object> doSchemaExport(boolean createFiles) throws IOException, SQLException, LiquibaseException {
        this.totalTimer.start();
        SchemaGeneratorUtils.createCaptureObjects();
        if ("ON".equals(this.SQLCL_SAVE_CAPTURE)) {
            this.capture = true;
        }
        boolean pubSyns = this.command.isFlagSet(LBOptions.Options.SYNONYMS);
        boolean grants = this.command.isFlagSet(LBOptions.Options.GRANTS);
        ScriptRunnerContext ctx = LbUtils.getContext();
        if (createFiles) {
            if (ctx != null) {
                ctx.write("\n" + Messages.getString("LB_FLAGS") + "\n");
                ctx.write(Messages.getString("LB_GRANTS") + "\t\t" + grants + "\n");
                ctx.write(Messages.getString("LB_SYNS") + "\t\t" + pubSyns + "\n\n");
            }
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("\n").append(Messages.getString("LB_FLAGS")).append("\n");
            sb.append(Messages.getString("LB_GRANTS")).append("\t\t").append(grants).append("\n");
            sb.append(Messages.getString("LB_SYNS")).append("\t\t").append(pubSyns).append("\n");
        }
        this.loadTimer.start();
        this.loadTimer.split();
        this.loadCaptureTable();
        this.loadTimer.end();
        this.writeTimer.start();
        this.writeCaptureTable(this.writeService, createFiles, "ALL");
        this.shutdownServiceAndWait(this.loadService, "loadService");
        this.shutdownServiceAndWait(this.writeService, WRITE_SERVICE);
        if (this.capture) {
            SchemaGeneratorUtils.cloneCaptureTable(LbUtils.getContext().getCurrentConnection(), "exp_load");
        }
        if (((Boolean)this.command.getOptionValue(LBOptions.Options.PERFORM_DETAIL_PARSE)).booleanValue()) {
            this.processCaptureTable();
        }
        this.sortCaptureTable();
        String rows = DbmsMetaUtils.executeSql("select count(*) from databasechangelog_export where written = 0", this.conn);
        int rowCount = 0;
        if (rows != null && !rows.isEmpty()) {
            rowCount = Integer.parseInt(rows);
        }
        if (rowCount > 0) {
            LbExecutorService writeService2 = new LbExecutorService(LbUtils.getContext(), 2, 5, 1, TimeUnit.DAYS, "writeService2");
            this.writeCaptureTable(writeService2, createFiles, null);
            this.shutdownServiceAndWait(writeService2, WRITE_SERVICE);
        }
        this.writeTimer.end();
        LbUtils.getContext().write(this.writeTimer.getResultString());
        try {
            LbUtils.getContext().getOutputStream().flush();
        }
        catch (IOException writeService2) {
            // empty catch block
        }
        ProcessTimer stopWatch = new ProcessTimer("Method writeController", true);
        stopWatch.start();
        String query = "select object_name,object_type,file_name from DATABASECHANGELOG_EXPORT order by OBJECT_RANK,OBJECT_SEQUENCE,OBJECT_NAME";
        StringBuilder contFile = new StringBuilder();
        contFile.append(this.genControllerHeader());
        try (PreparedStatement pstatement = this.conn.prepareStatement(query);){
            ResultSet rs = pstatement.executeQuery();
            while (rs.next()) {
                contFile.append(this.genControllerInclude(rs.getString(3)));
            }
        }
        contFile.append(CONTROLLERFOOTER);
        if (createFiles) {
            String fileName;
            String cleanFileName = fileName = LbFileUtils.writeFile("controller.xml", contFile.toString());
            if (fileName.contains(LbUtils.getCWD())) {
                cleanFileName = fileName.replace(LbUtils.getCWD(), "");
                cleanFileName = cleanFileName.substring(1);
            }
            cleanFileName = cleanFileName.replace("\\", "/");
            this.ret.put(cleanFileName, contFile.toString());
            this.command.setOptionValue(LBOptions.Options.CHANGELOG_FILE, cleanFileName);
        } else {
            this.ret.put("controller.xml", contFile.toString());
            this.command.setOptionValue(LBOptions.Options.CHANGELOG_FILE, "controller.xml");
        }
        stopWatch.end();
        this.totalTimer.end();
        LbUtils.getContext().write(this.totalTimer.getResultString());
        try {
            LbUtils.getContext().getOutputStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.ret;
    }

    private void shutdownServiceAndWait(LbExecutorService threadService, String name) throws LiquibaseException {
        threadService.shutdown();
        try {
            if (!threadService.awaitTermination(1L, TimeUnit.DAYS)) {
                throw new LiquibaseException(Messages.format("SERVICE_ERROR", name));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new LiquibaseException(Throwables.getStackTraceAsString((Throwable)e), (Throwable)e);
        }
    }

    private void loadCaptureTable() {
        boolean pubSyns = this.command.isFlagSet(LBOptions.Options.SYNONYMS);
        boolean grants = this.command.isFlagSet(LBOptions.Options.GRANTS);
        Map<String, Integer> orderedTypes = orderedTypesLong;
        for (Map.Entry<String, Integer> entry : orderedTypes.entrySet()) {
            final String key = entry.getKey();
            if (PUBLIC_SYNONYM.equals(key) && !pubSyns || (OBJECT_GRANT.equals(key) || SYSTEM_GRANT.equals(key) || ROLE_GRANT.equals(key)) && !grants) continue;
            this.loadService.execute(new LbRunnable(){

                @Override
                public void runJob() {
                    Connection tConn = ((LbThread)Thread.currentThread()).getConnection();
                    try {
                        SchemaGenerator.this.loadType(key, LbUtils.getContext(), SchemaGenerator.this.command, tConn, SchemaGenerator.this.loadTimer);
                    }
                    catch (SQLException e) {
                        throw new RejectedExecutionException(Throwables.getStackTraceAsString((Throwable)e));
                    }
                }
            });
        }
    }

    @NonNull
    private HashMap<RowId, ChangeData> getWork(ActiveCommand command, String oType, Connection tCon) throws LiquibaseException {
        ResultSet rs = null;
        HashMap<RowId, Object> work = new HashMap<RowId, Object>();
        String filesToWrite = SchemaGenerator.getQueryString(oType);
        try {
            Object data2;
            block25: {
                PreparedStatement pstatement = tCon.prepareStatement(filesToWrite);
                try {
                    if (oType != null) {
                        pstatement.setString(1, oType);
                    }
                    rs = pstatement.executeQuery();
                    while (rs.next()) {
                        data2 = new ChangeData(command);
                        ((ChangeData)data2).setObject(rs.getString(1), rs.getString(2));
                        RowId rowId = rs.getRowId(3);
                        ((ChangeData)data2).setDDL(LiquibaseStringUtils.clobToString(rs.getClob(4)));
                        ((ChangeData)data2).setCHANGELOG(this.getChangeLog((ChangeData)data2));
                        work.put(rowId, data2);
                        PreparedStatement updateStatement = tCon.prepareStatement("UPDATE DATABASECHANGELOG_EXPORT SET written = 1 WHERE rowid = ?");
                        try {
                            updateStatement.setRowId(1, rowId);
                            updateStatement.executeUpdate();
                        }
                        finally {
                            if (updateStatement == null) continue;
                            updateStatement.close();
                        }
                    }
                    tCon.commit();
                    data2 = work;
                    if (pstatement == null) break block25;
                }
                catch (Throwable data2) {
                    try {
                        if (pstatement != null) {
                            try {
                                pstatement.close();
                            }
                            catch (Throwable throwable) {
                                data2.addSuppressed(throwable);
                            }
                        }
                        throw data2;
                    }
                    catch (IOException | SQLException | LiquibaseException e) {
                        try {
                            tCon.rollback();
                        }
                        catch (SQLException ex) {
                            throw new LiquibaseException(Throwables.getStackTraceAsString((Throwable)e), e);
                        }
                        throw new LiquibaseException(Throwables.getStackTraceAsString((Throwable)e), e);
                    }
                }
                pstatement.close();
            }
            return data2;
        }
        finally {
            try {
                if (rs != null && !rs.isClosed()) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private LbRunnable makeRunner(final String type, final boolean createFiles) {
        return new LbRunnable(){

            @Override
            public void runJob() {
                try {
                    Connection tConn = ((LbThread)Thread.currentThread()).getConnection();
                    HashMap<RowId, ChangeData> work = SchemaGenerator.this.getWork(SchemaGenerator.this.command, type, tConn);
                    int l_counter = 0;
                    while (l_counter < 10) {
                        if (work.isEmpty()) {
                            ++l_counter;
                            tConn.commit();
                            Thread.sleep(10L);
                        }
                        if (!work.isEmpty() || !SchemaGenerator.this.loadService.isTerminated()) {
                            l_counter = 0;
                        }
                        for (Map.Entry<RowId, ChangeData> entry : work.entrySet()) {
                            ChangeData data = entry.getValue();
                            if (createFiles) {
                                LbFileUtils.writeFile(data);
                                if (data.isSQL()) {
                                    LbFileUtils.writeSqlFile(data, tConn);
                                }
                            }
                            SchemaGenerator.this.ret.put(data.getFILENAME(), data.getCHANGELOG());
                            PreparedStatement updateStatement = tConn.prepareStatement("UPDATE DATABASECHANGELOG_EXPORT SET written = 2, file_name = ? WHERE rowid = ?");
                            try {
                                updateStatement.setString(1, entry.getValue().getFILENAME());
                                updateStatement.setRowId(2, entry.getKey());
                                updateStatement.executeUpdate();
                            }
                            finally {
                                if (updateStatement == null) continue;
                                updateStatement.close();
                            }
                        }
                        tConn.commit();
                        work = SchemaGenerator.this.getWork(SchemaGenerator.this.command, type, tConn);
                        if (!work.isEmpty()) continue;
                        tConn.rollback();
                        work = SchemaGenerator.this.getWork(SchemaGenerator.this.command, null, tConn);
                    }
                    tConn.commit();
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                    throw new RejectedExecutionException(Throwables.getStackTraceAsString((Throwable)e));
                }
            }
        };
    }

    private void writeCaptureTable(LbExecutorService service, boolean createFiles, String type) {
        if (type == null || !orderedTypesLong.containsKey(type.toUpperCase())) {
            service.execute(this.makeRunner(null, createFiles));
        } else if (type.equalsIgnoreCase("ALL")) {
            Map<String, Integer> orderedTypes = orderedTypesLong;
            for (Map.Entry<String, Integer> entry : orderedTypes.entrySet()) {
                this.writeCaptureTable(service, createFiles, entry.getKey());
            }
        } else {
            service.execute(this.makeRunner(type, createFiles));
        }
    }

    private void processCaptureTable() throws SQLException, IOException {
        ProcessTimer stopWatch = new ProcessTimer("Method processCaptureTable", true, true);
        String queryCaptureTable = QueryUtils.getXMLQueries().getQuery("queryCaptureTable", this.conn).getSql();
        try (PreparedStatement pstatement = this.conn.prepareStatement(queryCaptureTable);){
            ResultSet rs = pstatement.executeQuery();
            while (rs.next()) {
                ExportRec expRec = new ExportRec(rs.getInt(1), rs.getString(2), rs.getInt(3), rs.getClob(4), rs.getString(5), rs.getString(6), rs.getString(7));
                ExportRec expRec2 = this.loadDeps(expRec);
                expRec2.updateBySeq();
            }
            if (this.capture) {
                SchemaGeneratorUtils.cloneCaptureTable(LbUtils.getLbConnection().getUnderlyingConnection(), "exp_process");
            }
            stopWatch.end();
        }
    }

    private void loadType(String oType, ScriptRunnerContext ctx, ActiveCommand ac, Connection conn, ProcessTimer timer) throws SQLException {
        String callLoadCapture = QueryUtils.getXMLQueries().getQuery("callLoadCapture", conn).getSql();
        try (CallableStatement statement = conn.prepareCall(callLoadCapture);){
            statement.registerOutParameter(1, 12);
            Integer rank = orderedTypesLong.get(oType);
            statement.setInt(2, (int)rank);
            statement.setString(3, oType);
            ScriptRunnerContext.Parameters parms = ctx.getParameterInstance();
            HashMap ddls = null;
            if (parms != null) {
                ddls = parms.getParameters("ddl.parms");
            }
            if (ddls == null) {
                throw new SQLException("Unable to load DDL parameters");
            }
            statement.setString(4, (String)ddls.get("BODY"));
            statement.setString(5, (String)ddls.get("CONSTRAINTS"));
            statement.setString(6, (String)ddls.get("CONSTRAINTS_AS_ALTER"));
            statement.setString(7, (String)ddls.get("FORCE"));
            statement.setString(8, (String)ddls.get("INHERIT"));
            statement.setString(9, (String)ddls.get("INSERT"));
            statement.setString(10, (String)ddls.get("PARTITIONING"));
            statement.setString(11, (String)ddls.get("PRETTY"));
            statement.setString(12, (String)ddls.get("REF_CONSTRAINTS"));
            statement.setString(13, (String)ddls.get("SEGMENT_ATTRIBUTES"));
            statement.setString(14, (String)ddls.get("SIZE_BYTE_KEYWORD"));
            statement.setString(15, (String)ddls.get("SPECIFICATION"));
            statement.setString(16, (String)ddls.get("SQLTERMINATOR"));
            statement.setString(17, (String)ddls.get("STORAGE"));
            statement.setString(18, (String)ddls.get("TABLESPACE"));
            statement.setString(19, (String)ac.getOptionValue(LBOptions.Options.DATABASE_CHANGELOG_TABLE_NAME));
            String filter = (String)ac.getOptionValue(LBOptions.Options.FILTER);
            if (null != filter) {
                statement.setString(20, filter.replace("\"", ""));
            } else {
                statement.setString(20, null);
            }
            statement.executeUpdate();
            conn.commit();
        }
        timer.split("Load Type " + oType);
    }

    private void sortCaptureTable() throws SQLException {
        ProcessTimer stopWatch = new ProcessTimer("Method sortCaptureTable", true, true);
        String query = QueryUtils.getXMLQueries().getQuery("callSortCapture", this.conn).getSql();
        try (CallableStatement statement = this.conn.prepareCall(query);){
            statement.execute();
            stopWatch.end();
        }
        catch (SQLException e) {
            try {
                this.conn.commit();
            }
            catch (SQLException e1) {
                Logger.warn(SchemaGenerator.class, (Throwable)e1);
                throw e1;
            }
            Logger.warn(SchemaGenerator.class, (Throwable)e);
            throw e;
        }
        if (this.capture) {
            SchemaGeneratorUtils.cloneCaptureTable(LbUtils.getLbConnection().getUnderlyingConnection(), "exp_sort");
        }
    }

    public String getChangeLog(ChangeData data) throws LiquibaseException {
        ChangeSetFactory factory = new ChangeSetFactory();
        String cType = data.getCHANGETYPE();
        if (cType == null || cType.isEmpty()) {
            return factory.getChangeGenerator(ChangeSetFactory.TYPE.XML.toString(), data).getChange();
        }
        if (cType.equals("SQL")) {
            return factory.getChangeGenerator(ChangeSetFactory.TYPE.SQL.toString(), data).getChange();
        }
        if (cType.equals("YAML")) {
            return factory.getChangeGenerator(ChangeSetFactory.TYPE.YAML.toString(), data).getChange();
        }
        if (cType.equals("JSON")) {
            return factory.getChangeGenerator(ChangeSetFactory.TYPE.JSON.toString(), data).getChange();
        }
        if (cType.equals("XML")) {
            return factory.getChangeGenerator(ChangeSetFactory.TYPE.XML.toString(), data).getChange();
        }
        throw new UnsupportedOperationException("\nERROR: " + cType + " is not a supported change format please adjsut your CHANGE_TYPE.");
    }

    private ExportRec loadDeps(ExportRec expRec) throws SQLException, IOException {
        String ddl;
        try {
            ddl = expRec.getDDL();
        }
        catch (Exception e) {
            Logger.warn(SchemaGenerator.class, (Throwable)e);
            throw e;
        }
        SqlRecognizer recognizer = new SqlRecognizer(ddl);
        List names = recognizer.getObjectNames();
        List deps = recognizer.getReferencedTypes();
        LinkedList<String> cleandep = new LinkedList<String>();
        if (null != names && !names.isEmpty()) {
            expRec.setObjName(((String)names.get(0)).replace("\"", ""));
        }
        for (String dep : deps) {
            String replace = dep.toUpperCase().replace("\"", "");
            cleandep.add(replace);
        }
        String depList = Joiner.on((String)",").join(cleandep);
        String finalList = depList.length() > 4000 ? depList.substring(0, 4000).substring(0, depList.lastIndexOf(",")) : depList;
        expRec.setDeps(finalList);
        return expRec;
    }

    private String genControllerHeader() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<databaseChangeLog \n        xmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\" \n        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n        xmlns:n0=\"http://www.oracle.com/xml/ns/dbchangelog-ext\" \n        xsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog \n        http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-latest.xsd\">\n";
    }

    private String genControllerInclude(String filename) {
        String cleanFileName = filename;
        if (filename.contains(LbUtils.getCWD())) {
            cleanFileName = filename.replace(LbUtils.getCWD(), "");
            cleanFileName = cleanFileName.substring(1);
        }
        cleanFileName = cleanFileName.replace("\\", "/");
        String include = "  <include file=\"%FILE%\"/> \n";
        return LiquibaseStringUtils.replaceVal("%FILE%", cleanFileName, "  <include file=\"%FILE%\"/> \n");
    }

    public String getOrdsModuleChangeLog() throws SQLException {
        String module = (String)this.command.getOptionValue(LBOptions.Options.MODULE_NAME);
        boolean enable = (Boolean)this.command.getOptionValue(LBOptions.Options.EXCLUDE_ENABLE_SCHEMA);
        boolean privs = (Boolean)this.command.getOptionValue(LBOptions.Options.EXCLUDE_PRIVS);
        String ordsQuery = "begin ? := ords_metadata.ords_export.export_module(P_MODULE_NAME => ?, P_INCLUDE_ENABLE_SCHEMA => case when ?=0 then true else false end, P_INCLUDE_PRIVS => case when ?=0 then true else false end); end;";
        try (CallableStatement stmt = this.conn.prepareCall("begin ? := ords_metadata.ords_export.export_module(P_MODULE_NAME => ?, P_INCLUDE_ENABLE_SCHEMA => case when ?=0 then true else false end, P_INCLUDE_PRIVS => case when ?=0 then true else false end); end;");){
            stmt.registerOutParameter(1, 2005);
            stmt.setString(2, module);
            stmt.setInt(3, enable ? 0 : 1);
            stmt.setInt(4, privs ? 0 : 1);
            String string = this.getOrdsChangelog(stmt);
            return string;
        }
    }

    public String getOrdsSchemaChangeLog() throws SQLException {
        boolean enable = (Boolean)this.command.getOptionValue(LBOptions.Options.EXCLUDE_ENABLE_SCHEMA);
        boolean privs = (Boolean)this.command.getOptionValue(LBOptions.Options.EXCLUDE_PRIVS);
        String ordsQuery = "begin ? := ords_metadata.ords_export.export_schema(P_INCLUDE_ENABLE_SCHEMA => case when ?=0 then true else false end , P_INCLUDE_PRIVS => case when ?=0 then true else false end); end; ";
        try (CallableStatement stmt = this.conn.prepareCall(ordsQuery);){
            stmt.registerOutParameter(1, 2005);
            stmt.setInt(2, enable ? 0 : 1);
            stmt.setInt(3, privs ? 0 : 1);
            String string = this.getOrdsChangelog(stmt);
            return string;
        }
    }

    private String getOrdsChangelog(CallableStatement stmt) {
        try {
            stmt.execute();
            Clob script = stmt.getClob(1);
            this.command.setOptionValue(LBOptions.Options.OBJECT_NAME, "ORDS");
            this.command.setOptionValue(LBOptions.Options.OBJECT_TYPE, "SCRIPT");
            this.command.setOptionValue(LBOptions.Options.DDL, LiquibaseStringUtils.clobToString(script));
            ChangeData data = new ChangeData(this.command);
            return this.getChangeLog(data);
        }
        catch (Exception e1) {
            Logger.warn(SchemaGenerator.class, (Throwable)e1);
            LbUtils.report(e1.getLocalizedMessage());
            return null;
        }
    }

    static {
        ddlTypes = ImmutableList.copyOf((Collection)new ArrayList<String>(){
            private static final long serialVersionUID = 1L;
            {
                this.add(SchemaGenerator.CONSTRAINT);
                this.add(SchemaGenerator.REF_CONSTRAINT);
                this.add(SchemaGenerator.DIMENSION);
                this.add(SchemaGenerator.FUNCTION);
                this.add(SchemaGenerator.PROCEDURE);
                this.add(SchemaGenerator.PACKAGE_SPEC);
                this.add(SchemaGenerator.PACKAGE_BODY);
                this.add(SchemaGenerator.TYPE_SPEC);
                this.add(SchemaGenerator.TYPE_BODY);
                this.add(SchemaGenerator.PUBLIC_SYNONYM);
                this.add(SchemaGenerator.SYNONYM);
                this.add(SchemaGenerator.OBJECT_GRANT);
                this.add(SchemaGenerator.DB_LINK);
                this.add(SchemaGenerator.TRIGGER);
                this.add(SchemaGenerator.JOB);
                this.add(SchemaGenerator.DIRECTORY);
                this.add(SchemaGenerator.COMMENT);
            }
        });
        ddlChangeTypes = ImmutableMap.copyOf((Map)new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(SchemaGenerator.CONSTRAINT, "createOracleConstraint");
                this.put(SchemaGenerator.REF_CONSTRAINT, "createOracleRefConstraint");
                this.put(SchemaGenerator.DIMENSION, "createOracleDimension");
                this.put(SchemaGenerator.FUNCTION, "createOracleFunction");
                this.put(SchemaGenerator.PROCEDURE, "createOracleProcedure");
                this.put(SchemaGenerator.PACKAGE_SPEC, "createOraclePackageSpec");
                this.put(SchemaGenerator.PACKAGE_BODY, "createOraclePackageBody");
                this.put(SchemaGenerator.TYPE_SPEC, "createOracleTypeSpec");
                this.put(SchemaGenerator.TYPE_BODY, "createOracleTypeBody");
                this.put(SchemaGenerator.PUBLIC_SYNONYM, "createOraclePublicSynonym");
                this.put(SchemaGenerator.SYNONYM, "createOracleSynonym");
                this.put(SchemaGenerator.OBJECT_GRANT, SchemaGenerator.CREATEORACLEGRANT);
                this.put(SchemaGenerator.ROLE_GRANT, SchemaGenerator.CREATEORACLEGRANT);
                this.put(SchemaGenerator.SYSTEM_GRANT, SchemaGenerator.CREATEORACLEGRANT);
                this.put(SchemaGenerator.DB_LINK, "createOracleDbLink");
                this.put(SchemaGenerator.TRIGGER, "createOracleTrigger");
                this.put(SchemaGenerator.JOB, "createOracleJob");
                this.put(SchemaGenerator.DIRECTORY, "createOracleDirectory");
                this.put(SchemaGenerator.COMMENT, "createOracleComment");
            }
        });
        orderedTypesLong = Collections.unmodifiableMap(new LinkedHashMap<String, Integer>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(SchemaGenerator.TYPE_SPEC, 10);
                this.put(SchemaGenerator.TYPE_BODY, 13);
                this.put(SchemaGenerator.SEQUENCE, 15);
                this.put(SchemaGenerator.DIRECTORY, 17);
                this.put(SchemaGenerator.CLUSTER, 19);
                this.put(SchemaGenerator.TABLE, 21);
                this.put(SchemaGenerator.MATERIALIZED_VIEW_LOG, 23);
                this.put(SchemaGenerator.MATERIALIZED_VIEW, 25);
                this.put(SchemaGenerator.VIEW, 27);
                this.put(SchemaGenerator.REF_CONSTRAINT, 29);
                this.put(SchemaGenerator.DIMENSION, 31);
                this.put(SchemaGenerator.PACKAGE_SPEC, 33);
                this.put(SchemaGenerator.FUNCTION, 35);
                this.put(SchemaGenerator.PROCEDURE, 37);
                this.put(SchemaGenerator.DB_LINK, 39);
                this.put(SchemaGenerator.SYNONYM, 41);
                this.put(SchemaGenerator.INDEX, 42);
                this.put(SchemaGenerator.TRIGGER, 45);
                this.put(SchemaGenerator.PACKAGE_BODY, 47);
                this.put(SchemaGenerator.JOB, 49);
                this.put(SchemaGenerator.PUBLIC_SYNONYM, 51);
                this.put(SchemaGenerator.OBJECT_GRANT, 53);
            }
        });
        typeNameTransform = ImmutableMap.copyOf(Collections.unmodifiableMap(new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(SchemaGenerator.PACKAGE_SPEC, "PACKAGE");
                this.put(SchemaGenerator.PACKAGE_BODY, "PACKAGE BODY");
                this.put(SchemaGenerator.TYPE_SPEC, "TYPE");
                this.put(SchemaGenerator.TYPE_BODY, "TYPE BODY");
                this.put(SchemaGenerator.MATERIALIZED_VIEW_LOG, "MATERIALIZED VIEW LOG");
                this.put(SchemaGenerator.MATERIALIZED_VIEW, "MATERIALIZED VIEW");
                this.put(SchemaGenerator.DB_LINK, "DATABASE LINK");
                this.put(SchemaGenerator.PUBLIC_SYNONYM, "PUBLIC SYNONYM");
            }
        }));
    }

    public class ExportRec {
        int rank;
        String oType;
        int seq;
        Clob source;
        String oName;
        String fName;
        String deps;

        public ExportRec(int rank, String oType, int seq, Clob source, String oName, String fName, String deps) {
            this.rank = rank;
            this.oType = oType;
            this.seq = seq;
            this.source = source;
            this.oName = oName;
            this.fName = fName;
            this.deps = deps;
        }

        public void setSource(String source) throws SQLException {
            Clob sourceClob = SchemaGenerator.this.conn.createClob();
            sourceClob.setString(1L, source);
            this.source = sourceClob;
        }

        public void setObjName(String oName) {
            this.oName = oName;
        }

        public String getDDL() throws SQLException, IOException {
            if (ddlChangeTypes.containsKey(this.oType)) {
                return LiquibaseStringUtils.trim(LiquibaseStringUtils.clobToString(this.source)).replace("REFERENCING FOR EACH ROW", "");
            }
            SchemaGenerator.this.command.setOptionValue(LBOptions.Options.OBJECT_TYPE, this.oType);
            return DbmsMetaUtils.getDdlFromXmlorSxml(SchemaGenerator.this.conn, this.source.getSubString(1L, (int)this.source.length()).trim(), this.oType, "sxml");
        }

        public void updateBySeq() throws SQLException {
            String updateCaptureTable = QueryUtils.getXMLQueries().getQuery("updateCaptureTablebySeq", SchemaGenerator.this.conn).getSql();
            try (PreparedStatement update = SchemaGenerator.this.conn.prepareStatement(updateCaptureTable);){
                update.setClob(1, this.source);
                update.setString(2, this.oName);
                update.setString(3, this.fName);
                update.setString(4, this.deps);
                update.setString(5, this.oType);
                update.setInt(6, this.seq);
                update.executeUpdate();
                SchemaGenerator.this.conn.commit();
            }
            catch (SQLException e) {
                Logger.warn(SchemaGenerator.class, (Throwable)e);
                SchemaGenerator.this.conn.rollback();
                throw e;
            }
        }

        @Generated
        public Clob getSource() {
            return this.source;
        }

        @Generated
        public void setDeps(String deps) {
            this.deps = deps;
        }
    }
}

