/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.ext.ora.change;

import java.sql.SQLException;
import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.statement.SqlStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.change.AbstractCommonSxmlChange;
import oracle.dbtools.raptor.liquibase.ext.ora.change.AbstractOracleChange;
import oracle.dbtools.raptor.liquibase.ext.ora.change.DropInternalSxmlChange;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.CreateInternalSxmlStatement;
import oracle.dbtools.raptor.liquibase.util.LbUtils;

@DatabaseChange(name="CreateInternalSxmlChange", description="Create Oracle Sxml Object", priority=1)
public class CreateInternalSxmlChange
extends AbstractCommonSxmlChange {
    public CreateInternalSxmlChange() {
    }

    public CreateInternalSxmlChange(AbstractOracleChange change) {
        super(change);
    }

    protected Change[] createInverses() {
        DropInternalSxmlChange stmt = new DropInternalSxmlChange(this);
        return new Change[]{stmt};
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("{0} {1} created successfully", this.getObjectType(), this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        String schema;
        try {
            schema = LbUtils.getLiquibaseSchema(LbUtils.getCommand().getDb());
        }
        catch (LiquibaseException e) {
            try {
                schema = LbUtils.getConfig().getContext().getCurrentConnection().getSchema();
            }
            catch (SQLException ex) {
                schema = "UNKNOWN";
            }
        }
        CreateInternalSxmlStatement stmt = new CreateInternalSxmlStatement();
        stmt.setObjectName(this.getObjectName());
        stmt.setObjectOwner(schema);
        stmt.setObjectType(this.getObjectType());
        stmt.setSource(this.getSource());
        stmt.setId(this.getId());
        stmt.setFile(this.getFile());
        stmt.setAuthor(this.getAuthor());
        return new SqlStatement[]{stmt};
    }
}

