/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.version;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.List;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.util.command.ParsedCommandListener;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.raptor.scriptrunner.commands.Messages;
import oracle.dbtools.raptor.scriptrunner.commands.version.VersionMessages;
import oracle.dbtools.raptor.scriptrunner.commands.version.VersionType;
import oracle.dbtools.versions.SQLclVersion;

public class VersionCommand
extends ParsedCommandListener {
    @Override
    protected boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        block16: {
            String check = (String)parsedCommand.getOptionValue(VersionType.Options.CHECK);
            String check_min = (String)parsedCommand.getOptionValue(VersionType.Options.CHECK_MIN);
            String check_max = (String)parsedCommand.getOptionValue(VersionType.Options.CHECK_MAX);
            String check_in = (String)parsedCommand.getOptionValue(VersionType.Options.CHECK_IN);
            try {
                Version currentVersion = new Version(SQLclVersion.getSQLclVersion());
                if (check == null && check_min == null && check_max == null && check_in == null) {
                    ctx.writeln(MessageFormat.format(Messages.getString("ShowVersion.1"), SQLclVersion.getSQLclVersion(), SQLclVersion.getSQLclBuildVersion()));
                    return true;
                }
                if (check != null && check_min == null && check_max == null && check_in == null) {
                    Version checkVersion = new Version(check);
                    if (checkVersion.compareTo(currentVersion) != 0) {
                        ctx.writeln(VersionMessages.format("VERSION_ERROR_CHECK", currentVersion, checkVersion));
                        ScriptUtils.doWhenever(ctx, cmd, conn, true);
                        return true;
                    }
                    ctx.writeln(VersionMessages.format("VERSION_CHECK_SUCCESS", new Object[0]));
                    break block16;
                }
                if (check == null && check_min != null && check_max == null && check_in == null) {
                    Version checkVersion = new Version(check_min);
                    if (currentVersion.compareTo(checkVersion) < 0) {
                        ctx.writeln(VersionMessages.format("VERSION_ERROR_CHECK_MIN", currentVersion, checkVersion));
                        ScriptUtils.doWhenever(ctx, cmd, conn, true);
                        return true;
                    }
                    ctx.writeln(VersionMessages.format("VERSION_CHECK_SUCCESS", new Object[0]));
                    break block16;
                }
                if (check == null && check_min == null && check_max != null && check_in == null) {
                    Version checkVersion = new Version(check_max);
                    if (currentVersion.compareTo(checkVersion) > 0) {
                        ctx.writeln(VersionMessages.format("VERSION_ERROR_CHECK_MAX", currentVersion, checkVersion));
                        ScriptUtils.doWhenever(ctx, cmd, conn, true);
                        return true;
                    }
                    ctx.writeln(VersionMessages.format("VERSION_CHECK_SUCCESS", new Object[0]));
                    break block16;
                }
                if (check == null && check_min != null && check_max != null && check_in == null) {
                    Version minVersion = new Version(check_min);
                    Version maxVersion = new Version(check_max);
                    if (minVersion.compareTo(maxVersion) > 0 || maxVersion.compareTo(minVersion) < 0) {
                        ctx.writeln(VersionMessages.format("VERSION_ERROR_CHECK_MIN_MAX_LOGIC", new Object[0]));
                        ScriptUtils.doWhenever(ctx, cmd, conn, true);
                        return true;
                    }
                    if (currentVersion.compareTo(minVersion) < 0 || currentVersion.compareTo(maxVersion) > 0) {
                        ctx.writeln(VersionMessages.format("VERSION_ERROR_CHECK_MIN_MAX", currentVersion, minVersion, maxVersion));
                        ScriptUtils.doWhenever(ctx, cmd, conn, true);
                        return true;
                    }
                    ctx.writeln(VersionMessages.format("VERSION_CHECK_SUCCESS", new Object[0]));
                    break block16;
                }
                if (check == null && check_min == null && check_max == null && check_in != null) {
                    List<String> allowedVersions = List.of(check_in.split(","));
                    boolean found = false;
                    for (String allowedVersion : allowedVersions) {
                        if (currentVersion.compareTo(new Version(allowedVersion)) != 0) continue;
                        found = true;
                    }
                    if (!found) {
                        ctx.writeln(VersionMessages.format("VERSION_ERROR_CHECK_IN", currentVersion, check_in));
                        ScriptUtils.doWhenever(ctx, cmd, conn, true);
                        return true;
                    }
                    ctx.writeln(VersionMessages.format("VERSION_CHECK_SUCCESS", new Object[0]));
                    break block16;
                }
                ctx.writeln(VersionMessages.format("VERSION_ERROR_COMBINATION", new Object[0]));
                ScriptUtils.doWhenever(ctx, cmd, conn, true);
                return true;
            }
            catch (NumberFormatException e) {
                ctx.writeln(VersionMessages.format("VERSION_CONVERSION_EXCEPTION", new Object[0]));
            }
            catch (Exception e) {
                ctx.writeln(VersionMessages.format(e.getLocalizedMessage(), new Object[0]));
            }
        }
        return false;
    }

    @Override
    protected Type createType() {
        return VersionType.versionType();
    }

    @Override
    public String getDescription() {
        return VersionMessages.format("VERSION_DESC", new Object[0]);
    }
}

