/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import oracle.dbtools.raptor.console.ConsoleService;
import oracle.dbtools.raptor.console.HighlighterService;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class SetHighlighting
extends CommandListener
implements IShowCommand,
IStoreCommand {
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ConsoleService consoleService = (ConsoleService)ctx.getProperty("script.runner.jline");
        HighlighterService highlighterService = consoleService.getHighlighterService();
        if (cmd.getSql().trim().toLowerCase().replaceAll(" ", "").startsWith("sethighlighting") || cmd.getSql().trim().toLowerCase().replaceAll(" ", "").startsWith("sethighli")) {
            String[] parts = cmd.getSQLOrig().split("\\s+");
            if (parts.length == 3) {
                if ("on".equals(parts[2].toLowerCase())) {
                    highlighterService.setEnabled(true);
                } else if ("off".equals(parts[2].toLowerCase())) {
                    highlighterService.setEnabled(false);
                } else if ("reset".equals(parts[2].toLowerCase())) {
                    highlighterService.reset();
                } else {
                    ctx.write("Highlighting: unrecognized option '" + parts[2] + "'\n");
                }
            } else if (parts.length == 4) {
                HighlighterService.InputType type = this.getInputType(parts[2].toUpperCase());
                if (type != null) {
                    if ("reset".equals(parts[3].toLowerCase())) {
                        highlighterService.reset(type);
                    } else {
                        ctx.write("Highlighting: unrecognized option '" + parts[3] + "'\n");
                    }
                } else {
                    ctx.write("Highlighting: unrecognized syntax type '" + parts[2] + "'\n");
                }
            } else if (parts.length == 5) {
                HighlighterService.InputType type = this.getInputType(parts[2].toUpperCase());
                if (type != null) {
                    if ("foreground".equals(parts[3].toLowerCase())) {
                        if ("reset".equals(parts[4].toLowerCase())) {
                            highlighterService.resetForegroundColor(type);
                        } else {
                            HighlighterService.TerminalColor color = this.getColor(parts[4].toUpperCase());
                            if (color != null) {
                                highlighterService.setForegroundColor(type, color);
                            } else {
                                ctx.write("Highlighting: unrecognized color '" + parts[4] + "'\n");
                            }
                        }
                    } else if ("background".equals(parts[3].toLowerCase())) {
                        if ("reset".equals(parts[4].toLowerCase())) {
                            highlighterService.resetBackgroundColor(type);
                        } else {
                            HighlighterService.TerminalColor color = this.getColor(parts[4].toUpperCase());
                            if (color != null) {
                                highlighterService.setBackgroundColor(type, color);
                            } else {
                                ctx.write("Highlighting: unrecognized color '" + parts[4] + "'\n");
                            }
                        }
                    } else if ("bold".equals(parts[3].toLowerCase())) {
                        if ("reset".equals(parts[4].toLowerCase())) {
                            highlighterService.resetBold(type);
                        } else if ("on".equals(parts[4].toLowerCase())) {
                            highlighterService.setBold(type, true);
                        } else if ("off".equals(parts[4].toLowerCase())) {
                            highlighterService.setBold(type, false);
                        } else {
                            ctx.write("Highlighting: unrecognized option '" + parts[4] + "'\n");
                        }
                    } else if ("uline".equals(parts[3].toLowerCase())) {
                        if ("reset".equals(parts[4].toLowerCase())) {
                            highlighterService.resetUnderline(type);
                        } else if ("on".equals(parts[4].toLowerCase())) {
                            highlighterService.setUnderline(type, true);
                        } else if ("off".equals(parts[4].toLowerCase())) {
                            highlighterService.setUnderline(type, false);
                        } else {
                            ctx.write("Highlighting: unrecognized option '" + parts[4] + "'\n");
                        }
                    } else if ("inverse".equals(parts[3].toLowerCase())) {
                        if ("reset".equals(parts[4].toLowerCase())) {
                            highlighterService.resetInverse(type);
                        } else if ("on".equals(parts[4].toLowerCase())) {
                            highlighterService.setInverse(type, true);
                        } else if ("off".equals(parts[4].toLowerCase())) {
                            highlighterService.setInverse(type, false);
                        } else {
                            ctx.write("Highlighting: unrecognized option '" + parts[4] + "'\n");
                        }
                    } else {
                        ctx.write("Highlighting: unrecognized property '" + parts[3] + "'\n");
                    }
                } else {
                    ctx.write("Highlighting: unrecognized syntax type '" + parts[2] + "'\n");
                }
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"highli", "highlighting"};
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ConsoleService consoleService = (ConsoleService)ctx.getProperty("script.runner.jline");
        HighlighterService highlighterService = consoleService.getHighlighterService();
        ctx.write("HIGHLIGHTING: " + (highlighterService.isEnabled() ? "on" : "off") + "\n");
        if (highlighterService.isEnabled()) {
            for (HighlighterService.InputType inputType : HighlighterService.InputType.values()) {
                HighlighterService.TerminalColor foreground = highlighterService.getForegroundColor(inputType);
                HighlighterService.TerminalColor background = highlighterService.getBackgroundColor(inputType);
                boolean bold = highlighterService.isBold(inputType);
                boolean underline = highlighterService.isUnderline(inputType);
                boolean inverse = highlighterService.isInverse(inputType);
                StringBuilder sb = new StringBuilder();
                sb.append("\t").append(inputType.toString()).append(": ");
                sb.append("\t").append(" foreground ").append(foreground != null ? foreground.toString().toLowerCase() : "default");
                sb.append("\t").append(" background ").append(background != null ? background.toString().toLowerCase() : "default");
                if (bold) {
                    sb.append("\t").append(" bold");
                }
                if (underline) {
                    sb.append("\t").append(" underline");
                }
                if (inverse) {
                    sb.append("\t").append(" inverse");
                }
                sb.append('\n');
                ctx.write(sb.toString());
            }
        }
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        ConsoleService consoleService = (ConsoleService)ctx.getProperty("script.runner.jline");
        HighlighterService highlighterService = consoleService.getHighlighterService();
        StringBuilder sb = new StringBuilder();
        sb.append("set highlighting ").append(highlighterService.isEnabled() ? "on" : "off").append('\n');
        for (HighlighterService.InputType inputType : HighlighterService.InputType.values()) {
            HighlighterService.TerminalColor foreground = highlighterService.getForegroundColor(inputType);
            HighlighterService.TerminalColor background = highlighterService.getBackgroundColor(inputType);
            boolean bold = highlighterService.isBold(inputType);
            boolean underline = highlighterService.isUnderline(inputType);
            boolean inverse = highlighterService.isInverse(inputType);
            if (foreground != null) {
                sb.append("set highlighting ").append(inputType.toString().toLowerCase()).append(" foreground ").append(foreground.toString().toLowerCase()).append('\n');
            }
            if (background != null) {
                sb.append("set highlighting ").append(inputType.toString().toLowerCase()).append(" background ").append(background.toString().toLowerCase()).append('\n');
            }
            if (bold) {
                sb.append("set highlighting ").append(inputType.toString().toLowerCase()).append(" bold on").append('\n');
            }
            if (underline) {
                sb.append("set highlighting ").append(inputType.toString().toLowerCase()).append(" uline on").append('\n');
            }
            if (!inverse) continue;
            sb.append("set highlighting ").append(inputType.toString().toLowerCase()).append(" inverse on").append('\n');
        }
        return sb.toString();
    }

    private HighlighterService.InputType getInputType(String arg) {
        HighlighterService.InputType type = null;
        try {
            type = HighlighterService.InputType.valueOf(arg);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return type;
    }

    private HighlighterService.TerminalColor getColor(String arg) {
        HighlighterService.TerminalColor type = null;
        try {
            type = HighlighterService.TerminalColor.valueOf(arg);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return type;
    }
}

