/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import oracle.dbtools.app.CompletionItem;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreResources;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.command.ParsedCommandListener;
import oracle.dbtools.raptor.newscriptrunner.util.completer.FileCompleter;
import oracle.dbtools.raptor.newscriptrunner.util.completer.SemanticCompleter;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Factory;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Option;
import oracle.dbtools.raptor.newscriptrunner.util.parser.OptionBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.file.FileExists;

public class OraPKICommand
extends ParsedCommandListener
implements IHelp {
    private final String cmdName = "ORAPKI";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        if (!OraPKICommand.matches("ORAPKI", cmd.getSQLOrig())) return false;
        String[] args = cmd.getSQLOrig().replace("\n", " ").split("\\s");
        if (args.length <= 2) return true;
        try {
            String[] a = Arrays.copyOfRange(args, 1, args.length);
            List<String> command = this.buildOraclePKICommand(a);
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.inheritIO();
            Process process = pb.start();
            if (process.waitFor(60L, TimeUnit.SECONDS)) {
                int exitCode = process.exitValue();
                if (exitCode == 0) return true;
            }
            process.destroyForcibly();
            return true;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public String getCommand() {
        return "ORAPKI";
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public String getDescription() {
        return ConnectionStoreResources.get("ORA_PKI_DESCRIPTION");
    }

    private List<String> buildOraclePKICommand(String[] args) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("java");
        command.add("-cp");
        command.add(System.getProperty("java.class.path"));
        command.add("oracle.security.pki.textui.OraclePKITextUI");
        command.addAll(Arrays.asList(args));
        return command;
    }

    @Override
    protected Type createType() {
        return Factory.type(ORAPKISymbols.ORAPKI).base().add(Factory.type(ORAPKISymbols.CERT).add(Factory.type(ORAPKISymbols.DISPLAY).add(ORAPKIOptions.CERT_O).add(ORAPKIOptions.SUMMARY_O).add(ORAPKIOptions.COMPLETE_O).build()).add(Factory.type(ORAPKISymbols.CREATE).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_O).add(ORAPKIOptions.REQUEST_O).add(ORAPKIOptions.CERT_O).add(ORAPKIOptions.SERIAL_FILE_O).add(ORAPKIOptions.SERIAL_NUM_O).add(ORAPKIOptions.VALIDITY_O).add(ORAPKIOptions.VALID_FROM_O).add(ORAPKIOptions.VALID_UNTIL_O).add(ORAPKIOptions.SUMMARY_O).add(ORAPKIOptions.SIGN_ALG_O).add(ORAPKIOptions.ISSUER_SUBJECT_DN_O).add(ORAPKIOptions.ISSUER_DN_O).add(ORAPKIOptions.ISSUER_SERIAL_NUM_O).build()).build()).add(Factory.type(ORAPKISymbols.CRL).add(Factory.type(ORAPKISymbols.CREATE).helpId("CREATE_CRL").add(ORAPKIOptions.CRL_O).add(ORAPKIOptions.WALLET_CRL_O).add(ORAPKIOptions.PWD_O).add(ORAPKIOptions.ISSUER_O).add(ORAPKIOptions.ISSUERSISSUER_O).add(ORAPKIOptions.SERIAL_NUM_O).add(ORAPKIOptions.NEXTUPDATE_O).add(ORAPKIOptions.SIGN_ALG_O).build()).add(Factory.type(ORAPKISymbols.REVOKE).add(ORAPKIOptions.CRL_O).add(ORAPKIOptions.WALLET_CRL_O).add(ORAPKIOptions.PWD_O).add(ORAPKIOptions.CERT_O).add(ORAPKIOptions.SIGN_ALG_O).build()).add(Factory.type(ORAPKISymbols.VERIFY).add(ORAPKIOptions.CRL_O).add(ORAPKIOptions.CERT_O).build()).add(Factory.type(ORAPKISymbols.STATUS).add(ORAPKIOptions.CRL_O).add(ORAPKIOptions.CERT_O).build()).add(Factory.type(ORAPKISymbols.DISPLAY).helpId("DISPLAY_CRL").add(ORAPKIOptions.CRL_O).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_O).add(ORAPKIOptions.SUMMARY_O).add(ORAPKIOptions.COMPLETE_O).build()).add(Factory.type(ORAPKISymbols.HASH).add(ORAPKIOptions.CRL_O).add(ORAPKIOptions.WALLET_NOT_REQ_O).add(ORAPKIOptions.PWD_O).add(ORAPKIOptions.SYMLINK_O).add(ORAPKIOptions.COPY_O).add(ORAPKIOptions.SUMMARY_CRL_HASH_O).build()).add(Factory.type(ORAPKISymbols.UPLOAD).add(ORAPKIOptions.CRL_O).add(ORAPKIOptions.WALLET_NOT_REQ_O).add(ORAPKIOptions.PWD_O).add(ORAPKIOptions.SUMMARY_O).add(ORAPKIOptions.LDAP_O).add(ORAPKIOptions.USER_O).add(ORAPKIOptions.LDAPPWD_O).build()).add(Factory.type(ORAPKISymbols.LIST).add(ORAPKIOptions.LDAP_O).build()).add(Factory.type(ORAPKISymbols.DELETE).add(ORAPKIOptions.ISSUER_CRL_REQ_O).add(ORAPKIOptions.LDAP_O).add(ORAPKIOptions.USER_O).add(ORAPKIOptions.SUMMARY_O).build()).build()).add(Factory.type(ORAPKISymbols.SECRETSTORE).add(Factory.type(ORAPKISymbols.CREATE_ENTRY).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_REQ_O).add(ORAPKIOptions.ALIAS_REQ_O).add(ORAPKIOptions.SECRET_O).build()).add(Factory.type(ORAPKISymbols.DELETE_ENTRY).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_REQ_O).add(ORAPKIOptions.ALIAS_REQ_O).build()).add(Factory.type(ORAPKISymbols.MODIFY_ENTRY).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_REQ_O).add(ORAPKIOptions.ALIAS_REQ_O).add(ORAPKIOptions.SECRET_O).build()).add(Factory.type(ORAPKISymbols.VIEW_ENTRY).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_REQ_O).add(ORAPKIOptions.ALIAS_REQ_O).build()).add(Factory.type(ORAPKISymbols.LIST_ENTRIES).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_REQ_O).build()).add(Factory.type(ORAPKISymbols.LIST_ENTRIES_UNSORTED).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_REQ_O).build()).add(Factory.type(ORAPKISymbols.CREATE_CREDENTIAL).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_REQ_O).add(ORAPKIOptions.CONNECT_STRING_O).add(ORAPKIOptions.USERNAME_O).add(ORAPKIOptions.PASSWORD_O).build()).add(Factory.type(ORAPKISymbols.DELETE_CREDENTIAL).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_REQ_O).add(ORAPKIOptions.CONNECT_STRING_O).build()).add(Factory.type(ORAPKISymbols.MODIFY_CREDENTIAL).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_REQ_O).add(ORAPKIOptions.CONNECT_STRING_O).add(ORAPKIOptions.USERNAME_O).add(ORAPKIOptions.PASSWORD_O).build()).add(Factory.type(ORAPKISymbols.LIST_CREDENTIALS).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_REQ_O).build()).add(Factory.type(ORAPKISymbols.CREATE_USER_CREDENTIAL).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_REQ_O).add(ORAPKIOptions.MAP_O).add(ORAPKIOptions.KEY_O).add(ORAPKIOptions.USERNAME_O).add(ORAPKIOptions.PASSWORD_O).build()).add(Factory.type(ORAPKISymbols.DELETE_USER_CREDENTIAL).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_REQ_O).add(ORAPKIOptions.MAP_O).add(ORAPKIOptions.KEY_O).build()).add(Factory.type(ORAPKISymbols.MODIFY_USER_CREDENTIAL).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_REQ_O).add(ORAPKIOptions.MAP_O).add(ORAPKIOptions.KEY_O).add(ORAPKIOptions.USERNAME_O).add(ORAPKIOptions.PASSWORD_O).build()).build()).add(Factory.type(ORAPKISymbols.WALLET).add(Factory.type(ORAPKISymbols.CREATE_WLT).name("CREATE").add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_O).add(ORAPKIOptions.AUTO_LOGIN_O).add(ORAPKIOptions.AUTO_LOGIN_LOCAL_O).add(ORAPKIOptions.AUTO_LOGIN_ONLY_O).add(ORAPKIOptions.WITH_TRUST_FLAGS_O).add(ORAPKIOptions.COMPAT_V12_O).build()).add(Factory.type(ORAPKISymbols.DISPLAY_WLT).name("DISPLAY").add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_O).add(ORAPKIOptions.SUMMARY_WLT_DISPLAY_O).add(ORAPKIOptions.COMPLETE_WLT_DISPLAY_O).add(ORAPKIOptions.DETAILS_O).build()).add(Factory.type(ORAPKISymbols.CONVERT).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_O).add(ORAPKIOptions.AUTO_LOGIN_ONLY_WLT_CONVERT_O).add(ORAPKIOptions.COMPAT_V12_WLT_CONVERT_O).build()).add(Factory.type(ORAPKISymbols.CHANGE_PWD).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.OLDPWD_O).add(ORAPKIOptions.NEWPWD_O).build()).add(Factory.type(ORAPKISymbols.ENABLE_TRUST_FLAGS).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_O).add(ORAPKIOptions.AUTO_LOGIN_ONLY_GEN_O).add(ORAPKIOptions.UNTRUST_ALL_O).build()).add(Factory.type(ORAPKISymbols.ADD).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_O).add(ORAPKIOptions.DN_O).add(ORAPKIOptions.ALIAS_WLT_O).add(ORAPKIOptions.ASYM_ALG_O).add(ORAPKIOptions.KEYSIZE_O).add(ORAPKIOptions.ECCURVE_O).add(ORAPKIOptions.SELF_SIGNED_O).add(ORAPKIOptions.VALIDITY_NOT_REQ_O).add(ORAPKIOptions.VALID_FROM_NOT_REQ_O).add(ORAPKIOptions.VALID_UNTIL_NOT_REQ_O).add(ORAPKIOptions.SERIAL_FILE_O).add(ORAPKIOptions.SERIAL_NUM_O).add(ORAPKIOptions.ADDEXT_SKI_O).add(ORAPKIOptions.ADDEXT_KU_O).add(ORAPKIOptions.ADDEXT_BASIC_CONS_O).add(ORAPKIOptions.PATHLEN_O).add(ORAPKIOptions.ADDEXT_SAN_O).add(ORAPKIOptions.CERT_O).add(ORAPKIOptions.TRUSTED_CERT_O).add(ORAPKIOptions.USER_CERT_O).add(ORAPKIOptions.AUTO_LOGIN_ONLY_GEN_O).add(ORAPKIOptions.SIGN_ALG_O).add(ORAPKIOptions.TRUST_FLAGS_O).build()).add(Factory.type(ORAPKISymbols.ASSIGN_TRUST_FLAGS).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_O).add(ORAPKIOptions.TRUST_FLAGS_O).add(ORAPKIOptions.DN_O).add(ORAPKIOptions.ISSUER_WLT_ATF_O).add(ORAPKIOptions.SERIAL_NUM_O).build()).add(Factory.type(ORAPKISymbols.REMOVE).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_O).add(ORAPKIOptions.DN_O).add(ORAPKIOptions.ALIAS_WLT_O).add(ORAPKIOptions.ISSUER_DN_O).add(ORAPKIOptions.SERIAL_NUM_O).add(ORAPKIOptions.TRUSTED_CERT_ALL_O).add(ORAPKIOptions.TRUSTED_CERT_O).add(ORAPKIOptions.USER_CERT_O).add(ORAPKIOptions.CERT_REQ_O).add(ORAPKIOptions.AUTO_LOGIN_ONLY_GEN_O).build()).add(Factory.type(ORAPKISymbols.REPLACE).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_O).add(ORAPKIOptions.ISSUER_DN_O).add(ORAPKIOptions.SERIAL_NUM_O).add(ORAPKIOptions.ALIAS_WLT_O).add(ORAPKIOptions.CERT_O).add(ORAPKIOptions.TRUSTED_CERT_O).add(ORAPKIOptions.USER_CERT_O).add(ORAPKIOptions.TRUST_FLAGS_O).build()).add(Factory.type(ORAPKISymbols.EXPORT).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_O).add(ORAPKIOptions.DN_O).add(ORAPKIOptions.ALIAS_WLT_O).add(ORAPKIOptions.CERT_O).add(ORAPKIOptions.REQUEST_O).add(ORAPKIOptions.ISSUER_DN_O).add(ORAPKIOptions.SERIAL_NUM_O).build()).add(Factory.type(ORAPKISymbols.EXPORT_TRUST_CHAIN).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_O).add(ORAPKIOptions.CERTCHAIN_O).add(ORAPKIOptions.DN_O).add(ORAPKIOptions.ALIAS_WLT_O).add(ORAPKIOptions.ISSUER_DN_O).add(ORAPKIOptions.SERIAL_NUM_O).build()).add(Factory.type(ORAPKISymbols.EXPORT_PRIVATE_KEY).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_O).add(ORAPKIOptions.PVTKEYFILE_O).add(ORAPKIOptions.ALIAS_WLT_PVTKEY_O).add(ORAPKIOptions.PVTKEYPWD_O).add(ORAPKIOptions.SALT_O).build()).add(Factory.type(ORAPKISymbols.IMPORT_PRIVATE_KEY).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_O).add(ORAPKIOptions.ALIAS_WLT_PVTKEY_O).add(ORAPKIOptions.PVTKEYFILE_IMPORT_O).add(ORAPKIOptions.PVTKEYPWD_O).add(ORAPKIOptions.SALT_O).add(ORAPKIOptions.CERT_O).add(ORAPKIOptions.CACERT_O).build()).add(Factory.type(ORAPKISymbols.UPLOAD).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_O).add(ORAPKIOptions.LDAP_O).add(ORAPKIOptions.USER_O).add(ORAPKIOptions.USERPWD_O).build()).add(Factory.type(ORAPKISymbols.DOWNLOAD).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_O).add(ORAPKIOptions.LDAP_O).add(ORAPKIOptions.USER_O).add(ORAPKIOptions.USERPWD_O).build()).add(Factory.type(ORAPKISymbols.JKS_TO_PKCS12).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_O).add(ORAPKIOptions.KEYSTORE_O).add(ORAPKIOptions.JKSPWD_O).add(ORAPKIOptions.ALIASES_O).build()).add(Factory.type(ORAPKISymbols.PKCS12_TO_JKS).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_O).add(ORAPKIOptions.JKS_KEY_STORE_LOC_O).add(ORAPKIOptions.JKS_KEY_STORE_PWD_O).add(ORAPKIOptions.JKS_TRUST_STORE_LOC_O).add(ORAPKIOptions.JKS_TRUST_STORE_PWD_O).build()).add(Factory.type(ORAPKISymbols.P11_ADD).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_O).add(ORAPKIOptions.P11_LIB_O).add(ORAPKIOptions.P11_TOKEN_LABEL_O).add(ORAPKIOptions.P11_TOKENPW_O).add(ORAPKIOptions.P11_CERTLABEL_O).build()).add(Factory.type(ORAPKISymbols.P11_VERIFY).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_O).build()).add(Factory.type(ORAPKISymbols.IMPORT_PKCS12).add(ORAPKIOptions.WALLET_O).add(ORAPKIOptions.PWD_O).add(ORAPKIOptions.AUTO_LOGIN_ONLY_GEN_O).add(ORAPKIOptions.PKCS12FILE_O).add(ORAPKIOptions.PKCS12PWD_O).build()).build()).build();
    }

    public static enum ORAPKISymbols implements Id
    {
        ORAPKI,
        SYMBOL1,
        SYMBOL2,
        CERT,
        WALLET,
        CREATE,
        OPEN,
        PWD,
        AUTO_LOGIN,
        AUTO_LOGIN_FILE,
        WALLET_TYPE,
        DISPLAY,
        SUMMARY,
        COMPLETE,
        REQUEST,
        SERIAL_FILE,
        SERIAL_NUM,
        VALIDITY,
        VALID_FROM,
        VALID_UNTIL,
        SIGN_ALG,
        ISSUER_SUBJECT_DN,
        ISSUER_DN,
        ISSUER_SERIAL_NUM,
        CRL,
        ISSUER,
        ISSUER_CRL_REQ,
        ISSUERSISSUER,
        NEXTUPDATE,
        REVOKE,
        VERIFY,
        STATUS,
        HASH,
        SYMLINK,
        COPY,
        UPLOAD,
        LDAP,
        USER,
        LDAPPWD,
        LIST,
        DELETE,
        SECRETSTORE,
        CREATE_ENTRY,
        ALIAS,
        SECRET,
        DELETE_ENTRY,
        MODIFY_ENTRY,
        VIEW_ENTRY,
        LIST_ENTRIES,
        LIST_ENTRIES_UNSORTED,
        CREATE_CREDENTIAL,
        CONNECT_STRING,
        USERNAME,
        PASSWORD,
        DELETE_CREDENTIAL,
        MODIFY_CREDENTIAL,
        LIST_CREDENTIALS,
        CREATE_USER_CREDENTIAL,
        MAP,
        KEY,
        DELETE_USER_CREDENTIAL,
        MODIFY_USER_CREDENTIAL,
        AUTO_LOGIN_LOCAL,
        AUTO_LOGIN_ONLY,
        WITH_TRUST_FLAGS,
        COMPAT_V12,
        DETAILS,
        CONVERT,
        CHANGE_PWD,
        OLDPWD,
        NEWPWD,
        ENABLE_TRUST_FLAGS,
        UNTRUST_ALL,
        ADD,
        DN,
        ASYM_ALG,
        KEYSIZE,
        ECCURVE,
        SELF_SIGNED,
        ADDEXT_SKI,
        ADDEXT_KU,
        ADDEXT_BASIC_CONS,
        PATHLEN,
        ADDEXT_SAN,
        TRUSTED_CERT,
        USER_CERT,
        TRUST_FLAGS,
        ASSIGN_TRUST_FLAGS,
        REMOVE,
        TRUSTED_CERT_ALL,
        CERT_REQ,
        REPLACE,
        EXPORT,
        EXPORT_TRUST_CHAIN,
        CERTCHAIN,
        EXPORT_PRIVATE_KEY,
        PVTKEYFILE,
        PVTKEYPWD,
        SALT,
        IMPORT_PRIVATE_KEY,
        CACERT,
        USERPWD,
        DOWNLOAD,
        JKS_TO_PKCS12,
        KEYSTORE,
        JKSPWD,
        ALIASES,
        PKCS12_TO_JKS,
        JKS_KEY_STORE_LOC,
        JKS_KEY_STORE_PWD,
        JKS_TRUST_STORE_LOC,
        JKS_TRUST_STORE_PWD,
        P11_ADD,
        P11_LIB,
        P11_TOKEN_LABEL,
        P11_TOKENPW,
        P11_CERTLABEL,
        P11_VERIFY,
        IMPORT_PKCS12,
        PKCS12FILE,
        WALLET_CRL,
        SUMMARY_CRL_HASH,
        WALLET_NOT_REQ,
        CREATE_WLT,
        DISPLAY_WLT,
        COMPLETE_WLT_DISPLAY,
        SUMMARY_WLT_DISPLAY,
        ISSUER_WLT_ATF,
        ALIAS_WLT,
        AUTO_LOGIN_ONLY_GEN,
        AUTO_LOGIN_ONLY_WLT_CONVERT,
        COMPAT_V12_WLT_CONVERT,
        ALIAS_WLT_PVTKEY,
        PVTKEYFILE_IMPORT,
        PKCS12PWD;

    }

    public static class ORAPKIOptions {
        public static final Option<String> WALLET_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.WALLET).dataType(String.class)).transformer(new FileExists())).completer(new FileCompleter())).required()).build();
        public static final Option<String> WALLET_CRL_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.WALLET_CRL).name("WALLET").dataType(String.class)).transformer(new FileExists())).completer(new FileCompleter())).required()).build();
        public static final Option<String> WALLET_NOT_REQ_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.WALLET_NOT_REQ).name("WALLET").dataType(String.class)).transformer(new FileExists())).completer(new FileCompleter())).build();
        public static final Option<String> SUMMARY_O = Factory.option(ORAPKISymbols.SUMMARY).flag().build();
        public static final Option<String> SUMMARY_CRL_HASH_O = Factory.option(ORAPKISymbols.SUMMARY_CRL_HASH).name("SUMMARY").flag().build();
        public static final Option<String> COMPLETE_O = Factory.option(ORAPKISymbols.COMPLETE).flag().build();
        public static final Option<String> COMPLETE_WLT_DISPLAY_O = Factory.option(ORAPKISymbols.COMPLETE_WLT_DISPLAY).name("COMPLETE").flag().build();
        public static final Option<String> SUMMARY_WLT_DISPLAY_O = Factory.option(ORAPKISymbols.SUMMARY_WLT_DISPLAY).name("SUMMARY").flag().build();
        public static final Option<String> PWD_O = ((OptionBuilder)Factory.option(ORAPKISymbols.PWD).dataType(String.class)).build();
        public static final Option<String> PWD_REQ_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.PWD).dataType(String.class)).required()).build();
        public static final Option<String> CERT_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.CERT).dataType(String.class)).transformer(new FileExists())).completer(new FileCompleter())).required()).build();
        public static final Option<String> REQUEST_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.REQUEST).dataType(String.class)).transformer(new FileExists())).completer(new FileCompleter())).required()).build();
        public static final Option<String> SERIAL_FILE_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.SERIAL_FILE).dataType(String.class)).transformer(new FileExists())).completer(new FileCompleter())).build();
        public static final Option<String> SERIAL_NUM_O = ((OptionBuilder)Factory.option(ORAPKISymbols.SERIAL_NUM).dataType(String.class)).build();
        public static final Option<String> VALIDITY_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.VALIDITY).dataType(Integer.class)).required()).build();
        public static final Option<String> VALIDITY_NOT_REQ_O = ((OptionBuilder)Factory.option(ORAPKISymbols.VALIDITY).dataType(Integer.class)).build();
        public static final Option<String> VALID_FROM_NOT_REQ_O = ((OptionBuilder)Factory.option(ORAPKISymbols.VALID_FROM).dataType(String.class)).build();
        public static final Option<String> VALID_FROM_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.VALID_FROM).dataType(String.class)).required()).build();
        public static final Option<String> VALID_UNTIL_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.VALID_UNTIL).dataType(String.class)).required()).build();
        public static final Option<String> VALID_UNTIL_NOT_REQ_O = ((OptionBuilder)Factory.option(ORAPKISymbols.VALID_UNTIL).dataType(String.class)).build();
        public static final Option<String> SIGN_ALG_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.SIGN_ALG).dataType(String.class)).completer(new SignAlgCompleter())).build();
        public static final Option<String> ISSUER_SUBJECT_DN_O = ((OptionBuilder)Factory.option(ORAPKISymbols.ISSUER_SUBJECT_DN).dataType(String.class)).build();
        public static final Option<String> ISSUER_DN_O = ((OptionBuilder)Factory.option(ORAPKISymbols.ISSUER_DN).dataType(String.class)).build();
        public static final Option<String> ISSUER_SERIAL_NUM_O = ((OptionBuilder)Factory.option(ORAPKISymbols.ISSUER_SERIAL_NUM).dataType(String.class)).build();
        public static final Option<String> CRL_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.CRL).dataType(String.class)).transformer(new FileExists())).completer(new FileCompleter())).required()).build();
        public static final Option<String> ISSUER_O = ((OptionBuilder)Factory.option(ORAPKISymbols.ISSUER).dataType(String.class)).build();
        public static final Option<String> ISSUER_WLT_ATF_O = ((OptionBuilder)Factory.option(ORAPKISymbols.ISSUER_WLT_ATF).name("ISSUER").dataType(String.class)).build();
        public static final Option<String> ISSUER_CRL_REQ_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.ISSUER).dataType(String.class)).required()).build();
        public static final Option<String> ISSUERSISSUER_O = ((OptionBuilder)Factory.option(ORAPKISymbols.ISSUERSISSUER).dataType(String.class)).build();
        public static final Option<String> NEXTUPDATE_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.NEXTUPDATE).dataType(Integer.class)).required()).build();
        public static final Option<String> SYMLINK_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.SYMLINK).dataType(String.class)).completer(new FileCompleter())).build();
        public static final Option<String> COPY_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.COPY).dataType(String.class)).completer(new FileCompleter())).build();
        public static final Option<String> LDAP_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.LDAP).dataType(String.class)).required()).build();
        public static final Option<String> USER_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.USER).dataType(String.class)).required()).build();
        public static final Option<String> LDAPPWD_O = ((OptionBuilder)Factory.option(ORAPKISymbols.LDAPPWD).dataType(String.class)).build();
        public static final Option<String> ALIAS_O = ((OptionBuilder)Factory.option(ORAPKISymbols.ALIAS).dataType(String.class)).build();
        public static final Option<String> ALIAS_REQ_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.ALIAS).dataType(String.class)).required()).build();
        public static final Option<String> ALIAS_WLT_PVTKEY_O = ((OptionBuilder)Factory.option(ORAPKISymbols.ALIAS_WLT_PVTKEY).name("ALIAS").dataType(String.class)).build();
        public static final Option<String> ALIAS_WLT_O = ((OptionBuilder)Factory.option(ORAPKISymbols.ALIAS_WLT).name("ALIAS").dataType(String.class)).build();
        public static final Option<String> SECRET_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.SECRET).dataType(String.class)).required()).build();
        public static final Option<String> CONNECT_STRING_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.CONNECT_STRING).dataType(String.class)).required()).build();
        public static final Option<String> USERNAME_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.USERNAME).dataType(String.class)).required()).build();
        public static final Option<String> PASSWORD_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.PASSWORD).dataType(String.class)).required()).build();
        public static final Option<String> MAP_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.MAP).dataType(String.class)).required()).build();
        public static final Option<String> KEY_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.KEY).dataType(String.class)).required()).build();
        public static final Option<String> AUTO_LOGIN_O = Factory.option(ORAPKISymbols.AUTO_LOGIN).flag().build();
        public static final Option<String> AUTO_LOGIN_LOCAL_O = Factory.option(ORAPKISymbols.AUTO_LOGIN_LOCAL).flag().build();
        public static final Option<String> AUTO_LOGIN_ONLY_O = Factory.option(ORAPKISymbols.AUTO_LOGIN_ONLY).flag().build();
        public static final Option<String> AUTO_LOGIN_ONLY_GEN_O = Factory.option(ORAPKISymbols.AUTO_LOGIN_ONLY_GEN).name("AUTO_LOGIN_ONLY").flag().build();
        public static final Option<String> AUTO_LOGIN_ONLY_WLT_CONVERT_O = Factory.option(ORAPKISymbols.AUTO_LOGIN_ONLY_WLT_CONVERT).name("AUTO_LOGIN_ONLY").flag().build();
        public static final Option<String> WITH_TRUST_FLAGS_O = Factory.option(ORAPKISymbols.WITH_TRUST_FLAGS).flag().build();
        public static final Option<String> COMPAT_V12_O = Factory.option(ORAPKISymbols.COMPAT_V12).flag().build();
        public static final Option<String> COMPAT_V12_WLT_CONVERT_O = Factory.option(ORAPKISymbols.COMPAT_V12_WLT_CONVERT).name("COMPAT_V12").flag().build();
        public static final Option<String> DETAILS_O = Factory.option(ORAPKISymbols.DETAILS).flag().build();
        public static final Option<String> OLDPWD_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.OLDPWD).dataType(String.class)).required()).build();
        public static final Option<String> NEWPWD_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.NEWPWD).dataType(String.class)).required()).build();
        public static final Option<String> UNTRUST_ALL_O = Factory.option(ORAPKISymbols.UNTRUST_ALL).flag().build();
        public static final Option<String> DN_O = ((OptionBuilder)Factory.option(ORAPKISymbols.DN).dataType(String.class)).build();
        public static final Option<String> ASYM_ALG_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.ASYM_ALG).dataType(String.class)).completer(new AsymAlgCompleter())).build();
        public static final Option<String> KEYSIZE_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.KEYSIZE).dataType(Integer.class)).completer(new KeySizeCompleter())).build();
        public static final Option<String> ECCURVE_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.ECCURVE).dataType(String.class)).completer(new EccurveCompleter())).build();
        public static final Option<String> SELF_SIGNED_O = Factory.option(ORAPKISymbols.SELF_SIGNED).flag().build();
        public static final Option<String> ADDEXT_SKI_O = Factory.option(ORAPKISymbols.ADDEXT_SKI).flag().build();
        public static final Option<String> ADDEXT_KU_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.ADDEXT_KU).dataType(String.class)).completer(new AddExtensionKeyUsageCompleter())).build();
        public static final Option<String> ADDEXT_BASIC_CONS_O = ((OptionBuilder)Factory.option(ORAPKISymbols.ADDEXT_BASIC_CONS).dataType(String.class)).build();
        public static final Option<String> PATHLEN_O = ((OptionBuilder)Factory.option(ORAPKISymbols.PATHLEN).dataType(Integer.class)).build();
        public static final Option<String> ADDEXT_SAN_O = ((OptionBuilder)Factory.option(ORAPKISymbols.ADDEXT_SAN).dataType(String.class)).build();
        public static final Option<String> TRUSTED_CERT_O = Factory.option(ORAPKISymbols.TRUSTED_CERT).flag().build();
        public static final Option<String> USER_CERT_O = Factory.option(ORAPKISymbols.USER_CERT).flag().build();
        public static final Option<String> TRUST_FLAGS_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.TRUST_FLAGS).dataType(String.class)).completer(new AddExtensionKeyUsageCompleter())).build();
        public static final Option<String> TRUSTED_CERT_ALL_O = Factory.option(ORAPKISymbols.TRUSTED_CERT_ALL).flag().build();
        public static final Option<String> CERT_REQ_O = Factory.option(ORAPKISymbols.CERT_REQ).flag().build();
        public static final Option<String> CERTCHAIN_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.CERTCHAIN).dataType(String.class)).transformer(new FileExists())).completer(new FileCompleter())).required()).build();
        public static final Option<String> PVTKEYFILE_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.PVTKEYFILE).dataType(String.class)).transformer(new FileExists())).completer(new FileCompleter())).required()).build();
        public static final Option<String> PVTKEYFILE_IMPORT_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.PVTKEYFILE_IMPORT).name("PVTKEYFILE").dataType(String.class)).transformer(new FileExists())).completer(new FileCompleter())).required()).build();
        public static final Option<String> PVTKEYPWD_O = ((OptionBuilder)Factory.option(ORAPKISymbols.PVTKEYPWD).dataType(String.class)).build();
        public static final Option<String> SALT_O = ((OptionBuilder)Factory.option(ORAPKISymbols.SALT).dataType(String.class)).build();
        public static final Option<String> CACERT_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.CACERT).dataType(String.class)).transformer(new FileExists())).completer(new FileCompleter())).required()).build();
        public static final Option<String> USERPWD_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.USERPWD).dataType(String.class)).required()).build();
        public static final Option<String> KEYSTORE_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.KEYSTORE).dataType(String.class)).required()).build();
        public static final Option<String> JKSPWD_O = ((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.JKSPWD).dataType(String.class)).required()).build();
        public static final Option<String> ALIASES_O = ((OptionBuilder)Factory.option(ORAPKISymbols.ALIASES).dataType(String.class)).build();
        public static final Option<String> JKS_KEY_STORE_LOC_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.JKS_KEY_STORE_LOC).dataType(String.class)).transformer(new FileExists())).completer(new FileCompleter())).build();
        public static final Option<String> JKS_KEY_STORE_PWD_O = ((OptionBuilder)Factory.option(ORAPKISymbols.JKS_KEY_STORE_PWD).dataType(String.class)).build();
        public static final Option<String> JKS_TRUST_STORE_LOC_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.JKS_TRUST_STORE_LOC).dataType(String.class)).transformer(new FileExists())).completer(new FileCompleter())).build();
        public static final Option<String> JKS_TRUST_STORE_PWD_O = ((OptionBuilder)Factory.option(ORAPKISymbols.JKS_TRUST_STORE_PWD).dataType(String.class)).build();
        public static final Option<String> P11_LIB_O = ((OptionBuilder)Factory.option(ORAPKISymbols.P11_LIB).dataType(String.class)).build();
        public static final Option<String> P11_TOKEN_LABEL_O = ((OptionBuilder)Factory.option(ORAPKISymbols.P11_TOKEN_LABEL).dataType(String.class)).build();
        public static final Option<String> P11_TOKENPW_O = ((OptionBuilder)Factory.option(ORAPKISymbols.P11_TOKENPW).dataType(String.class)).build();
        public static final Option<String> P11_CERTLABEL_O = ((OptionBuilder)Factory.option(ORAPKISymbols.P11_CERTLABEL).dataType(String.class)).build();
        public static final Option<String> PKCS12FILE_O = ((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option(ORAPKISymbols.PKCS12FILE).dataType(String.class)).transformer(new FileExists())).completer(new FileCompleter())).build();
        public static final Option<String> PKCS12PWD_O = ((OptionBuilder)Factory.option(ORAPKISymbols.PKCS12PWD).dataType(String.class)).build();
    }

    public static class TrustFlagsCompleter
    implements SemanticCompleter {
        @Override
        public List<CompletionItem> complete(String prefix, ScriptRunnerContext ctx, Map<String, Object> transformedOptionsMap) {
            LinkedList<CompletionItem> comp = new LinkedList<CompletionItem>();
            comp.add(new CompletionItem("SERVER_AUTH", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("CLIENT_AUTH", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("VALID_PEER", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("NULL", CompletionItem.Type.STRING));
            return comp;
        }
    }

    public static class AddExtensionKeyUsageCompleter
    implements SemanticCompleter {
        @Override
        public List<CompletionItem> complete(String prefix, ScriptRunnerContext ctx, Map<String, Object> transformedOptionsMap) {
            LinkedList<CompletionItem> comp = new LinkedList<CompletionItem>();
            comp.add(new CompletionItem("digitalSignature", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("nonRepudiation", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("keyEncipherment", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("dataEncipherment", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("keyAgreement", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("keyCertSign", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("cRLSign", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("encipherOnly", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("decipherOnly", CompletionItem.Type.STRING));
            return comp;
        }
    }

    public static class EccurveCompleter
    implements SemanticCompleter {
        @Override
        public List<CompletionItem> complete(String prefix, ScriptRunnerContext ctx, Map<String, Object> transformedOptionsMap) {
            LinkedList<CompletionItem> comp = new LinkedList<CompletionItem>();
            comp.add(new CompletionItem("p192", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("p224", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("p256", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("p384", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("p521", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("k163", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("k233", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("k283", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("k409", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("k571", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("b163", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("b233", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("b283", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("b409", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("b571", CompletionItem.Type.STRING));
            return comp;
        }
    }

    public static class KeySizeCompleter
    implements SemanticCompleter {
        @Override
        public List<CompletionItem> complete(String prefix, ScriptRunnerContext ctx, Map<String, Object> transformedOptionsMap) {
            LinkedList<CompletionItem> comp = new LinkedList<CompletionItem>();
            comp.add(new CompletionItem("512", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("1024", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("2048", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("4096", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("8192", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("16384", CompletionItem.Type.STRING));
            return comp;
        }
    }

    public static class AsymAlgCompleter
    implements SemanticCompleter {
        @Override
        public List<CompletionItem> complete(String prefix, ScriptRunnerContext ctx, Map<String, Object> transformedOptionsMap) {
            LinkedList<CompletionItem> comp = new LinkedList<CompletionItem>();
            comp.add(new CompletionItem("RSA", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("ECC", CompletionItem.Type.STRING));
            return comp;
        }
    }

    public static class SignAlgCompleter
    implements SemanticCompleter {
        @Override
        public List<CompletionItem> complete(String prefix, ScriptRunnerContext ctx, Map<String, Object> transformedOptionsMap) {
            LinkedList<CompletionItem> comp = new LinkedList<CompletionItem>();
            comp.add(new CompletionItem("md5", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("sha1", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("sha256", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("sha384", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("sha512", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("ecdsasha1", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("ecdsasha256", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("ecdsasha384", CompletionItem.Type.STRING));
            comp.add(new CompletionItem("ecdsasha512", CompletionItem.Type.STRING));
            return comp;
        }
    }
}

