/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.imp;

import java.io.IOException;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.core.connections.api.Connections;
import oracle.dbtools.core.connections.storage.StoreException;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreResources;
import oracle.dbtools.plusplus.connections.db.imp.ConnectionsConverter;
import oracle.dbtools.plusplus.connections.db.imp.ConnectionsConverterFactory;
import oracle.dbtools.plusplus.connections.db.imp.ImportedConnectionResult;
import oracle.dbtools.plusplus.util.CommandContext;

public final class DatabaseProviderImporter {
    private final CommandContext cmdCtx;

    public static DatabaseProviderImporter createImporter(CommandContext cmdCtx) {
        return new DatabaseProviderImporter(cmdCtx);
    }

    private DatabaseProviderImporter(CommandContext cmdCtx) {
        this.cmdCtx = cmdCtx;
    }

    public ImportedConnectionResult importConnection(DatabaseProvider connectionDefinition, String name) {
        return this.importConnection(connectionDefinition, name, null);
    }

    public ImportedConnectionResult importConnection(DatabaseProvider connectionDefinition, String name, Connections.Identifier identifier) {
        ImportedConnectionResult result;
        ConnectionsConverter transmogrifier;
        String oldName = DatabaseProviderImporter.getConnectionName(connectionDefinition);
        if (ModelUtil.areDifferent(oldName, name)) {
            connectionDefinition = DatabaseProvider.builder(name, connectionDefinition).build();
        }
        if ((transmogrifier = ConnectionsConverterFactory.getConverter(connectionDefinition, this.cmdCtx.getMessageLogger(), identifier)) == null) {
            String subtype = connectionDefinition.getProperty("subtype");
            if ("oraJDBC".equals(subtype)) {
                String oracleType = connectionDefinition.getProperty("OracleConnectionType");
                result = ImportedConnectionResult.failure(connectionDefinition.getName(), ConnectionStoreResources.format("FAILURE_UNSUPPORTED_ORACLE_TYPE", oracleType));
            } else {
                result = ImportedConnectionResult.failure(connectionDefinition.getName(), ConnectionStoreResources.format("FAILURE_UNSUPPORTED_TYPE", subtype));
            }
        } else {
            try {
                result = transmogrifier.convert();
            }
            catch (IOException | StoreException e) {
                result = ImportedConnectionResult.failure(connectionDefinition.getName(), e.getLocalizedMessage());
            }
        }
        return result;
    }

    public static String getConnectionName(DatabaseProvider prov) {
        return prov.getName();
    }
}

