/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.utility;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import oracle.dbtools.util.Logger;

public class MD5 {
    private String value;

    public MD5() {
    }

    public MD5(String aValue) {
        this.value = aValue;
    }

    public static final MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            Logger.severe(MD5.class, (Throwable)e);
            return null;
        }
    }

    public String calculate(byte[] buf) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(buf);
            byte[] mdbytes = md.digest();
            this.value = MD5.convertByteArrayToHexString(mdbytes);
            return this.value;
        }
        catch (NoSuchAlgorithmException e) {
            Logger.severe(this.getClass(), (Throwable)e);
            return null;
        }
    }

    public String calculate(String path) {
        this.value = this.getHash(path, "MD5");
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    public String getHash(String fileStr, String hashAlgo) {
        byte[] mdbytes = this.getHashBytes(fileStr, hashAlgo);
        return null == mdbytes ? null : MD5.convertByteArrayToHexString(mdbytes);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] getHashBytes(String fileStr, String hashAlgo) {
        File file = new File(fileStr);
        MessageDigest md = null;
        ByteBuffer bbf = null;
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] byArray;
            block15: {
                FileChannel fc = fis.getChannel();
                try {
                    md = MessageDigest.getInstance(hashAlgo);
                    bbf = ByteBuffer.allocateDirect(0x100000);
                    while (fc.read(bbf) != -1) {
                        bbf.flip();
                        md.update(bbf);
                        bbf.clear();
                    }
                    byArray = md.digest();
                    if (fc == null) break block15;
                }
                catch (Throwable throwable) {
                    if (fc != null) {
                        try {
                            fc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                fc.close();
            }
            return byArray;
        }
        catch (NoSuchAlgorithmException e) {
            Logger.severe(this.getClass(), (Throwable)e);
        }
        catch (IOException e) {
            Logger.severe(this.getClass(), (Throwable)e);
        }
        return null;
    }

    public static String convertByteArrayToHexString(byte[] arrayBytes) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayBytes.length; ++i) {
            stringBuffer.append(Integer.toString((arrayBytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return stringBuffer.toString();
    }

    public String calculate(ByteBuffer mbb) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(mbb);
            byte[] mdbytes = md.digest();
            this.value = MD5.convertByteArrayToHexString(mdbytes);
            return this.value;
        }
        catch (NoSuchAlgorithmException e) {
            Logger.severe(this.getClass(), (Throwable)e);
            return null;
        }
    }
}

