/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.request.processor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.cloudstorage.api.put.ReadAwareInputStream;
import oracle.cloudstorage.api.request.processor.IContent;
import oracle.cloudstorage.concurrent.Future;
import oracle.cloudstorage.io.IO;
import oracle.cloudstorage.io.Md5InputStream;

public class Content
implements IContent {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final int bufferSize;
    private Future<String> futureMd5 = new Future();
    private InputStream inputStream = null;
    private ReadAwareInputStream readAwareInputStream = null;
    private Streamer streamer = null;

    public Content() {
        this(null, 1);
    }

    public Content(InputStream inputStream, int bufferSize) {
        this.inputStream = inputStream == null ? new ByteArrayInputStream(EMPTY_BYTES) : inputStream;
        this.bufferSize = bufferSize;
    }

    @Override
    public Future<String> getFutureMd5() {
        return this.futureMd5;
    }

    @Override
    public synchronized InputStream getInputStream() {
        return this.readAwareInputStream == null ? this.inputStream : this.readAwareInputStream;
    }

    @Override
    public void wrapInputStream(InputStream wrappedInputStream) {
        if (this.readAwareInputStream != null) {
            throw new IllegalStateException();
        }
        this.inputStream = wrappedInputStream;
    }

    @Override
    public synchronized IContent.Streamer prepareForRead() {
        if (this.readAwareInputStream != null) {
            return this.streamer;
        }
        Md5InputStream md5InputStream = new Md5InputStream(this.inputStream, this.futureMd5);
        this.readAwareInputStream = new ReadAwareInputStream(md5InputStream);
        this.streamer = new Streamer();
        return this.streamer;
    }

    @Override
    public synchronized long getNumberOfBytesRead() {
        return this.readAwareInputStream == null ? 0L : this.readAwareInputStream.getNumberOfBytesRead();
    }

    @Override
    public synchronized boolean hasBeenRead() {
        return this.readAwareInputStream != null && this.readAwareInputStream.hasBeenRead();
    }

    @Override
    public boolean reset() {
        try {
            this.getInputStream().reset();
            return true;
        }
        catch (IOException e) {
            return false;
        }
        catch (RuntimeException e) {
            for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof IOException)) continue;
                return false;
            }
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    private class Streamer
    implements IContent.Streamer {
        private Streamer() {
        }

        @Override
        public void streamTo(OutputStream outputStream) {
            ((IO.ReadInputStream)IO.read(Content.this.readAwareInputStream).buffer(Content.this.bufferSize)).into(outputStream);
        }
    }
}

