/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.fasterxml.jackson.jr.stree.JacksonJrsTreeCodec;
import com.fasterxml.jackson.jr.stree.JrsNumber;
import com.fasterxml.jackson.jr.stree.JrsObject;
import com.fasterxml.jackson.jr.stree.JrsString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractMap;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import oracle.dbtools.http.Session;
import oracle.dbtools.http.SessionException;
import oracle.dbtools.jdbc.CLOB;
import oracle.dbtools.jdbc.CallableStatement;
import oracle.dbtools.jdbc.Connection;
import oracle.dbtools.jdbc.PreparedStatement;
import oracle.dbtools.jdbc.ResultSetMetadata;
import oracle.dbtools.jdbc.RowId;
import oracle.dbtools.jdbc.Statement;
import oracle.dbtools.jdbc.util.DateTimestampsUtil;
import oracle.dbtools.jdbc.util.ExceptionUtil;
import oracle.dbtools.jdbc.util.LogUtil;
import oracle.dbtools.jdbc.util.RestJdbcNotImplementedException;
import oracle.dbtools.jdbc.util.RestJdbcUnsupportedException;
import oracle.dbtools.jdbc.util.RestjdbcResources;
import oracle.dbtools.jdbc.util.SQLStateMapping;
import oracle.dbtools.oci.OCIRESTClient;
import oracle.dbtools.oci.OCIRequest;
import oracle.sql.TIMESTAMPTZ;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class ResultSet
implements java.sql.ResultSet {
    Logger LOGGER = Logger.getLogger(ResultSet.class.getName());
    private static final String TOKEN_START_STR = "items";
    private static final String TOKEN_START_METADATA = "metadata";
    private final String TOKEN_ERR = "errorCode";
    private static final String TOKEN_RESPONSE = "response";
    private static final int QUOTES = 34;
    private static final int BACKSLASH = 92;
    private static final int NEWLINE = 110;
    private static final int SPACE = 32;
    private static final int START_OBJECT = 123;
    private static final int END_OBJECT = 125;
    private static final int START_ARRAY = 91;
    private static final int END_ARRAY = 93;
    private boolean debug = false;
    private boolean isResultsStarted = false;
    private boolean isResultsEnded = false;
    private int c;
    protected LinkedHashMap<String, Integer> colNames = new LinkedHashMap();
    protected boolean colNamesExtracted = false;
    private Map<Integer, TreeNode> rowData = new HashMap<Integer, TreeNode>();
    private TreeNode rsMetadataTree = null;
    private InputStream stream = null;
    private boolean metadata = false;
    private boolean emptyResultSet = false;
    private Statement stmt = null;
    private PreparedStatement pstmt = null;
    private CallableStatement cstmt = null;
    private boolean isResultSetClosed = false;
    private long maxRows = 0L;
    protected boolean closed = false;
    private int offset = 0;
    private String sql = null;
    protected boolean wasNull = false;
    protected Connection conn = null;
    protected Map<Object, LinkedList<Object>> data = new HashMap<Object, LinkedList<Object>>();
    protected Map<Object, String> types = new HashMap<Object, String>();
    private Map<Object, Integer> outTypes = new HashMap<Object, Integer>();
    private String timeZoneID = null;
    private boolean next = false;
    private int rowCount = 0;
    private boolean metadataCreated = false;
    private int fetchDirection = 1000;
    public int fetchSize = 0;

    public ResultSet(CloseableHttpResponse response, Statement stmt, Connection conn) throws SQLException {
        HttpEntity entity = response.getEntity();
        this.conn = conn;
        this.sql = stmt.getSqlString();
        this.fetchSize = stmt.getFetchSize();
        this.stmt = stmt;
        this.pstmt = null;
        this.cstmt = null;
        try {
            this.maxRows = stmt.getMaxRows();
            this.stream = entity.getContent();
            if (!this.metadataCreated && this.isResultSetSection()) {
                this.startMetaData();
                this.createMetadataTree();
                this.metadataCreated = true;
            }
        }
        catch (IOException | IllegalStateException e) {
            this.LOGGER.log(Level.SEVERE, e.getCause().toString());
        }
    }

    public ResultSet(CloseableHttpResponse response, PreparedStatement stmt, Connection conn, String sql) throws SQLException {
        HttpEntity entity = response.getEntity();
        this.sql = sql;
        this.conn = conn;
        this.pstmt = stmt;
        this.stmt = null;
        this.cstmt = null;
        this.fetchSize = stmt.getFetchSize();
        this.types = stmt.getTypes();
        this.data = stmt.getData();
        try {
            this.maxRows = stmt.getMaxRows();
            this.stream = entity.getContent();
            if (!this.metadataCreated && this.isResultSetSection()) {
                this.startMetaData();
                this.createMetadataTree();
                this.metadataCreated = true;
            }
        }
        catch (IOException | IllegalStateException e) {
            this.LOGGER.log(Level.SEVERE, e.getCause().toString());
        }
    }

    public ResultSet(CloseableHttpResponse response, CallableStatement stmt, Connection conn) throws SQLException {
        HttpEntity entity = response.getEntity();
        this.conn = conn;
        this.cstmt = stmt;
        this.pstmt = null;
        this.stmt = null;
        this.fetchSize = stmt.getFetchSize();
        this.types = stmt.getTypes();
        this.data = stmt.getData();
        this.outTypes = stmt.getOutTypes();
        try {
            this.maxRows = stmt.getMaxRows();
            this.stream = entity.getContent();
            if (!this.metadataCreated && this.isResultSetSection()) {
                this.startMetaData();
                this.createMetadataTree();
                this.metadataCreated = true;
            }
        }
        catch (IOException | IllegalStateException e) {
            this.LOGGER.log(Level.SEVERE, e.getCause().toString());
        }
    }

    public ResultSet(InputStream is, CallableStatement stmt) throws SQLException {
        this.cstmt = stmt;
        this.pstmt = null;
        this.stmt = null;
        this.fetchSize = stmt.getFetchSize();
        this.types = stmt.getTypes();
        this.data = stmt.getData();
        this.outTypes = stmt.getOutTypes();
        try {
            this.maxRows = stmt.getMaxRows();
            this.stream = is;
            if (!this.metadataCreated && this.isResultSetSection()) {
                this.startMetaData();
                this.createMetadataTree();
                this.metadataCreated = true;
            }
        }
        catch (IllegalStateException e) {
            this.LOGGER.log(Level.SEVERE, e.getCause().toString());
        }
    }

    public ResultSet(TreeNode metadata, String items) throws SQLException {
        this.rsMetadataTree = metadata;
    }

    protected void createMetadataTree() throws SQLException {
        if (this.emptyResultSet) {
            throw new SQLException(RestjdbcResources.getString("RESTJDBC_007"));
        }
        this.LOGGER.info("Extracting ResultSet metadata");
        boolean metadataEnded = false;
        StringBuilder sb = new StringBuilder();
        int innerJsonObj = 0;
        int innerJsonArray = 0;
        sb.append('{');
        sb.append("\"");
        sb.append(TOKEN_START_METADATA);
        sb.append("\"");
        while (!metadataEnded) {
            try {
                this.c = this.stream.read();
                if (this.c == 123) {
                    ++innerJsonObj;
                } else if (this.c == 91) {
                    ++innerJsonArray;
                } else if (this.c == 125) {
                    --innerJsonObj;
                } else if (this.c == 93) {
                    --innerJsonArray;
                }
                if (innerJsonArray == 0 && innerJsonObj == 0 && this.c == 93) {
                    metadataEnded = true;
                    this.stream.read();
                }
                sb.append((char)this.c);
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, e.getMessage(), e);
            }
        }
        sb.append('}');
        JSON json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
        Object node = null;
        try {
            this.rsMetadataTree = json.treeFrom((Object)sb.toString());
            sb = null;
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, e.getMessage(), e);
        }
    }

    private String getTimeZoneID() {
        StringBuilder sb = new StringBuilder();
        String tzToken = "defaultTimeZone";
        String timeZoneID = null;
        boolean getEnv = false;
        int quotes = 0;
        while (!getEnv && this.c > -1) {
            try {
                this.c = this.stream.read();
                if (this.c == 34) {
                    ++quotes;
                } else if (quotes == 1) {
                    sb.append((char)this.c);
                }
                if (quotes != 2) continue;
                quotes = 0;
                if (sb.toString().equals(tzToken)) {
                    getEnv = true;
                    int q = 0;
                    sb.setLength(0);
                    while (q != 2) {
                        this.c = this.stream.read();
                        if (this.c == 34) {
                            ++q;
                            continue;
                        }
                        if (q != 1) continue;
                        sb.append((char)this.c);
                    }
                    timeZoneID = sb.toString();
                    continue;
                }
                sb.setLength(0);
            }
            catch (IOException e) {
                this.LOGGER.severe(e.getMessage());
            }
        }
        return timeZoneID;
    }

    private boolean isResultSetSection() throws SQLException {
        this.LOGGER.finer("Checking for a ResultSet section in the response");
        this.timeZoneID = this.getTimeZoneID();
        boolean result = false;
        int quotes = 0;
        StringBuilder sb = new StringBuilder();
        boolean rsSection = false;
        String resultSetToken = "resultSet";
        StringBuilder error = new StringBuilder();
        error.append('{');
        boolean isError = false;
        try {
            while (!rsSection && this.c > -1) {
                this.c = this.stream.read();
                if (isError) {
                    error.append((char)this.c);
                } else if (this.c == 34) {
                    ++quotes;
                } else if (quotes == 1) {
                    sb.append((char)this.c);
                }
                if (isError || quotes != 2) continue;
                quotes = 0;
                if (sb.toString().equals(resultSetToken)) {
                    rsSection = true;
                    this.metadata = true;
                    result = true;
                    continue;
                }
                if (sb.toString().equals(this.TOKEN_ERR)) {
                    this.metadata = false;
                    error.append("\"");
                    error.append(this.TOKEN_ERR);
                    error.append("\"");
                    isError = true;
                    continue;
                }
                sb.setLength(0);
            }
            if (isError) {
                error.delete(error.length() - 3, error.length());
                JSON json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
                TreeNode errorNode = json.treeFrom((Object)error.toString());
                this.handleErrors(errorNode);
            }
            if (!result) {
                this.emptyResultSet = true;
                this.metadata = false;
            }
        }
        catch (IOException e) {
            this.LOGGER.log(Level.WARNING, "isResultSetSection(): " + e.getMessage());
        }
        return result;
    }

    protected void startMetaData() throws SQLException {
        boolean metadata_started = false;
        this.LOGGER.finer("Extracting the metadata for the ResultSet");
        int quotes = 0;
        StringBuilder sb = new StringBuilder();
        while (!metadata_started && this.c > -1) {
            try {
                this.c = this.stream.read();
                if (this.c == 34) {
                    ++quotes;
                } else if (quotes == 1) {
                    sb.append((char)this.c);
                }
                if (quotes != 2) continue;
                quotes = 0;
                if (sb.toString().equals(TOKEN_START_METADATA)) {
                    metadata_started = true;
                    this.metadata = true;
                    break;
                }
                if (sb.toString().equals(TOKEN_RESPONSE)) {
                    this.processResponse();
                    return;
                }
                if (sb.toString().contains(this.TOKEN_ERR)) {
                    this.processError();
                    return;
                }
                sb.setLength(0);
            }
            catch (SQLException se) {
                throw se;
            }
            catch (Exception e) {
                if (e.getMessage() != null) {
                    this.LOGGER.log(Level.SEVERE, "startMetaData()" + e.getMessage());
                    continue;
                }
                this.LOGGER.log(Level.SEVERE, "startMetaData(): Error in reading ResultSetMetadata");
            }
        }
        sb.setLength(0);
    }

    private void processError() throws SQLException, IOException {
        StringBuilder sb = new StringBuilder();
        this.stream.read();
        boolean endErr = false;
        int count = 0;
        while (!endErr) {
            try {
                int c = this.stream.read();
                if (c == 34) {
                    ++count;
                    continue;
                }
                if (count < 2) {
                    if (c == 92 && this.stream.read() == 110) {
                        sb.append(System.lineSeparator());
                        continue;
                    }
                    sb.append((char)c);
                    continue;
                }
                String exception = sb.toString();
                throw new SQLException(exception);
            }
            catch (IOException e) {
                this.LOGGER.log(Level.WARNING, e.getCause().toString());
            }
        }
    }

    private void processResponse() throws SQLException {
        boolean endErr = false;
        boolean firstwordRead = false;
        int array = 0;
        boolean entered = false;
        String s = null;
        StringBuilder sb = new StringBuilder();
        boolean error = false;
        try {
            while (!endErr) {
                int c = this.stream.read();
                if (c == 91) {
                    ++array;
                    c = this.stream.read();
                    c = this.stream.read();
                    entered = true;
                } else if (c == 93) {
                    --array;
                } else if (array >= 1) {
                    if (c == 92 && (c = this.stream.read()) == 110) {
                        sb.append(System.lineSeparator());
                    } else if (!firstwordRead) {
                        byte[] b = new byte[5];
                        this.stream.read(b);
                        s = new String(b);
                        sb.append(s);
                        firstwordRead = true;
                    } else {
                        if (s.equalsIgnoreCase("Error")) {
                            error = true;
                        }
                        sb.append((char)c);
                    }
                }
                if (array != 0 || !entered) continue;
                endErr = true;
                if (!error) {
                    this.LOGGER.info(sb.toString().substring(0, sb.toString().length() - 1));
                    continue;
                }
                throw new SQLException(sb.toString().substring(0, sb.toString().length() - 1));
            }
        }
        catch (IOException e) {
            this.LOGGER.log(Level.WARNING, "processResponse()" + e.getCause().toString());
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.ensureOpen("next");
        this.next = true;
        if (!this.metadataCreated) {
            return false;
        }
        if (!this.isResultsStarted) {
            this.startResults();
            this.isResultsStarted = true;
        }
        if (this.emptyResultSet) {
            this.LOGGER.log(Level.INFO, RestjdbcResources.getString("RESTJDBC_014"));
            return false;
        }
        if (this.isResultsStarted && !this.isResultsEnded) {
            ++this.rowCount;
            if (this.maxRows == 0L || this.maxRows > 0L && (long)this.rowCount <= this.maxRows) {
                String row = this.walkRow();
                JSON json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
                Object root = null;
                Iterator iterator = null;
                try {
                    JrsObject node = (JrsObject)json.treeFrom((Object)row);
                    iterator = node.fields();
                }
                catch (JSONObjectException e) {
                    int errorCode = 17089;
                    throw new SQLException(e.getMessage(), SQLStateMapping.getSQLState(errorCode), errorCode);
                }
                catch (IOException e) {
                    int errorCode = 17089;
                    throw new SQLException(e.getMessage(), SQLStateMapping.getSQLState(errorCode), errorCode);
                }
                int count = 0;
                row = null;
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    TreeNode rowData_node = (TreeNode)entry.getValue();
                    JSON json1 = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
                    this.rowData.put(++count, rowData_node);
                    this.colNames.put((String)entry.getKey(), count);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected CloseableHttpResponse getBasicAuthResponse(Writer postWriter, URI root) throws SessionException {
        StringEntity strEntity = new StringEntity(postWriter.toString());
        Session session = this.conn.getSession();
        HttpPost post = session.createPost(root);
        post.addHeader("Content-Type", (Object)"application/json");
        post.setEntity((HttpEntity)strEntity);
        return session.executeRequest((HttpUriRequest)post);
    }

    protected CloseableHttpResponse getOCIAuthResponse(Writer postWriter, URI root) throws SessionException, GeneralSecurityException, IOException {
        OCIRESTClient client = this.conn.getOCIRESTClient();
        OCIRequest request = new OCIRequest.Builder().host(root.getHost()).method("post").body(postWriter.toString()).target(root.getPath()).contentType("application/json").build();
        return client.getResponse(request);
    }

    private CloseableHttpResponse executeInternal() throws SQLException {
        CloseableHttpResponse response = null;
        StringBuilder uri = new StringBuilder();
        uri.append(this.conn.getUri());
        uri.append("_/sql");
        URI root = URI.create(uri.toString());
        this.offset += this.fetchSize;
        try {
            Writer writer = null;
            if (this.stmt != null) {
                AbstractMap.SimpleEntry<JsonGenerator, Writer> simpleEntry = this.stmt.generatePost(this.sql, this.offset);
                JsonGenerator g = simpleEntry.getKey();
                g.close();
                writer = simpleEntry.getValue();
            } else if (this.pstmt != null) {
                AbstractMap.SimpleEntry<JsonGenerator, Writer> simpleEntry = this.pstmt.generatePost(this.sql, this.offset);
                JsonGenerator g = this.pstmt.batchIndex == 0 ? this.pstmt.processSets(simpleEntry.getKey()) : this.pstmt.processBatchSets(simpleEntry.getKey());
                g.close();
                writer = simpleEntry.getValue();
            } else if (this.cstmt != null) {
                // empty if block
            }
            response = Connection.basic_auth ? this.getBasicAuthResponse(writer, root) : this.getOCIAuthResponse(writer, root);
        }
        catch (IOException | IllegalStateException | GeneralSecurityException | SessionException e) {
            this.LOGGER.log(Level.SEVERE, e.getMessage());
        }
        catch (SQLException e) {
            throw e;
        }
        return response;
    }

    private void startNewFetch() {
        CloseableHttpResponse response = null;
        try {
            int bytesRead;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = this.stream.read(buffer)) != -1) {
                result.write(buffer, 0, bytesRead);
            }
            String end = result.toString(StandardCharsets.UTF_8);
            if (end.contains("false")) {
                this.isResultsEnded = true;
            } else if (end.contains("true") && ((long)this.rowCount <= this.maxRows || this.maxRows == 0L)) {
                this.stream.close();
                response = this.executeInternal();
                HttpEntity entity = response.getEntity();
                this.stream = entity.getContent();
                this.isResultsEnded = false;
                this.isResultsStarted = false;
                this.metadataCreated = false;
                if (!this.metadataCreated && this.isResultSetSection()) {
                    this.startMetaData();
                    this.createMetadataTree();
                    this.metadataCreated = true;
                }
            }
        }
        catch (Exception e) {
            this.LOGGER.severe(e.getMessage());
        }
    }

    protected String walkRow() {
        boolean hasRowEnded = false;
        StringBuilder row = new StringBuilder();
        int innerJsonObj = 0;
        int innerJsonArray = 0;
        while (!hasRowEnded && !this.isResultsEnded) {
            try {
                if (this.c == -1) {
                    return row.toString();
                }
                if (this.c == 123) {
                    ++innerJsonObj;
                } else if (this.c == 91) {
                    ++innerJsonArray;
                } else if (this.c == 125) {
                    --innerJsonObj;
                } else if (this.c == 93) {
                    --innerJsonArray;
                }
                if (innerJsonArray == 0 && innerJsonObj == 0 && this.c == 125) {
                    hasRowEnded = true;
                    int s = this.stream.read();
                    row.append((char)this.c);
                    if (s == 93) {
                        this.startNewFetch();
                    }
                } else {
                    row.append((char)this.c);
                }
                this.c = this.stream.read();
            }
            catch (IOException e) {
                this.LOGGER.log(Level.INFO, e.getCause().toString());
            }
        }
        return row.toString();
    }

    public void startResults() throws SQLException {
        int quotes = 0;
        StringBuilder sb = new StringBuilder();
        while (!this.isResultsStarted && this.c > -1) {
            try {
                if (this.c == 34) {
                    ++quotes;
                } else if (quotes == 1) {
                    sb.append((char)this.c);
                } else if (quotes == 2) {
                    quotes = 0;
                    if (sb.toString().equals(TOKEN_START_STR)) {
                        while (this.c != 91 && this.c > -1) {
                            this.c = this.stream.read();
                        }
                        this.c = this.stream.read();
                        if (this.c == 93) {
                            this.emptyResultSet = true;
                        } else {
                            while (this.c != 123) {
                                this.c = this.stream.read();
                            }
                        }
                        this.isResultsStarted = true;
                        return;
                    }
                    sb.setLength(0);
                }
                this.c = this.stream.read();
            }
            catch (Exception e) {
                if (e.getMessage() != null) {
                    this.LOGGER.log(Level.SEVERE, e.getMessage());
                    continue;
                }
                this.LOGGER.log(Level.SEVERE, "Exception: Error reading ResultSet");
            }
        }
    }

    private int extractColIndex(LinkedHashMap<String, Integer> map, String columnLabel, String methodName) throws SQLException {
        this.ensureOpen(methodName);
        if (!this.colNamesExtracted) {
            for (int i = 1; i <= this.getMetaData().getColumnCount(); ++i) {
                this.colNames.put(this.getMetaData().getColumnName(i), i);
            }
            this.colNamesExtracted = true;
        }
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(columnLabel)) continue;
            return entry.getValue();
        }
        int errorCode = 17006;
        throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
    }

    private void nextCalled() throws SQLException {
        if (!this.next) {
            int errorCode = 17014;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    private void ensureOpen(String methodName) throws SQLException {
        if (this.closed) {
            this.closedrsException(methodName);
        }
        if (this.conn.isClosed()) {
            ExceptionUtil.throwSQLException(17008);
        }
    }

    private Object getObjectHelper(int columnIndex) throws SQLException {
        block14: {
            try {
                ResultSetMetaData rsmd = this.getMetaData();
                int columnType = rsmd.getColumnType(columnIndex);
                if (this.rowData.get(columnIndex).isMissingNode()) {
                    return null;
                }
                if (columnType == 2) {
                    return this.getBigDecimal(columnIndex);
                }
                if (columnType == 101) {
                    return this.getDouble(columnIndex);
                }
                if (columnType == 100) {
                    return Float.valueOf(this.getFloat(columnIndex));
                }
                if (columnType == -1 || columnType == 1 || columnType == 12) {
                    return this.getString(columnIndex);
                }
                if (columnType == 91) {
                    Timestamp date_value = this.getTimestamp(columnIndex);
                    return date_value;
                }
                if (columnType == 93) {
                    Timestamp timestamp_value = this.getTimestamp(columnIndex);
                    return timestamp_value;
                }
                if (columnType == 92) {
                    Time time_value = this.getTime(columnIndex);
                    return time_value;
                }
                if (columnType == -101) {
                    return this.getTIMESTAMPTZ(columnIndex);
                }
                if (columnType == 2005) {
                    return this.getClob(columnIndex);
                }
            }
            catch (NullPointerException ne) {
                if (ne.getMessage() != null) {
                    this.LOGGER.log(Level.SEVERE, ne.getMessage());
                }
                int errorCode = 17003;
                throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
            }
            catch (SQLException e) {
                if (e.getMessage() == null) break block14;
                throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
            }
        }
        int errorCode = 17015;
        throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
    }

    private String getRowStr(int columnInd) throws SQLException {
        int errorCode;
        if (columnInd <= 0) {
            errorCode = 17003;
            ExceptionUtil.throwSQLException(errorCode);
        }
        if (this.emptyResultSet && columnInd > 0 && columnInd <= this.getMetaData().getColumnCount()) {
            errorCode = 17289;
            ExceptionUtil.throwSQLException(errorCode);
        }
        String row = null;
        try {
            if (this.rowData.get(columnInd).isMissingNode()) {
                this.wasNull = true;
                return null;
            }
            try {
                row = this.parseToString(this.rowData.get(columnInd));
                row = new String(row.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        catch (NullPointerException ne) {
            if (ne.getMessage() != null) {
                this.LOGGER.log(Level.SEVERE, ne.getMessage());
            }
            int errorCode2 = 17003;
            ExceptionUtil.throwSQLException(errorCode2);
        }
        if (row.equals("null")) {
            return null;
        }
        return row;
    }

    private String parseToString(TreeNode treeNode) throws IOException {
        JSON json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
        if (treeNode instanceof JrsString) {
            try (JsonParser jsonParser = treeNode.traverse(json.asCodec());){
                String string = (String)jsonParser.readValueAs(String.class);
                return string;
            }
        }
        return json.asString((Object)treeNode);
    }

    public TIMESTAMPTZ getTIMESTAMPTZ(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.ensureOpen("getObject(int columnIndex)");
        this.nextCalled();
        return this.getObjectHelper(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        this.ensureOpen("getObject(String columnLabel)");
        this.nextCalled();
        int columnIndex = this.extractColIndex(this.colNames, columnLabel, "getObject(String columnLabel)");
        return this.getObject(columnIndex);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.ensureOpen("getString(int columnIndex)");
        this.nextCalled();
        ResultSetMetaData rsmd = this.getMetaData();
        int columnType = rsmd.getColumnType(columnIndex);
        if (columnType == 91 || columnType == 93) {
            return this.getTimestamp(columnIndex).toString();
        }
        return this.getRowStr(columnIndex);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.ensureOpen("getShort(int columnIndex)");
        this.nextCalled();
        try {
            if (this.getRowStr(columnIndex) == null) {
                return 0;
            }
            double d = Double.parseDouble(this.getRowStr(columnIndex));
            if ((d < -32768.0 || d > 32767.0) && this.getMetaData().getColumnTypeName(columnIndex).equals("NUMBER")) {
                int errorCode = 17026;
                throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
            }
            return new Double(d).shortValue();
        }
        catch (NumberFormatException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getShort"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.ensureOpen("getInt(int columnIndex)");
        this.nextCalled();
        try {
            if (this.getRowStr(columnIndex) == null) {
                return 0;
            }
            return new Double(Double.parseDouble(this.getRowStr(columnIndex))).intValue();
        }
        catch (NumberFormatException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getInt"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.ensureOpen("getLong(int columnIndex)");
        this.nextCalled();
        try {
            if (this.getRowStr(columnIndex) == null) {
                return 0L;
            }
            BigDecimal bigD = new BigDecimal(this.getRowStr(columnIndex));
            if ((bigD.compareTo(new BigDecimal(Long.MAX_VALUE)) <= 0 || bigD.compareTo(new BigDecimal(Long.MIN_VALUE)) >= 0) && this.getMetaData().getColumnTypeName(columnIndex).equals("LONG")) {
                return bigD.longValue();
            }
            return new Double(Double.parseDouble(this.getRowStr(columnIndex))).longValue();
        }
        catch (NumberFormatException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getLong"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.ensureOpen("getFloat(int columnIndex)");
        this.nextCalled();
        try {
            if (this.getRowStr(columnIndex) == null) {
                return 0.0f;
            }
            return Float.parseFloat(this.getRowStr(columnIndex));
        }
        catch (NumberFormatException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getFloat"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.ensureOpen("getDouble(int columnIndex)");
        this.nextCalled();
        try {
            if (this.getRowStr(columnIndex) == null) {
                return 0.0;
            }
            return Double.parseDouble(this.getRowStr(columnIndex));
        }
        catch (NumberFormatException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getDouble"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.ensureOpen("getBytes(int columnIndex)");
        this.nextCalled();
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getBytes(int columnIndex)", this.getClass().getSimpleName()));
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        this.ensureOpen("getBytes(String columnLabel)");
        this.nextCalled();
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getBytes(String columnLabel)", this.getClass().getSimpleName()));
    }

    private int checkFormat(String tsStr, String methodName, String[] patterns) throws SQLException {
        int index = -1;
        for (int i = 0; i < patterns.length; ++i) {
            if (!Pattern.matches(patterns[i], tsStr)) continue;
            index = i;
        }
        if (index < 0) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, methodName), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        return index;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.ensureOpen("getDate(int columnIndex)");
        this.nextCalled();
        String rowStr = this.getRowStr(columnIndex);
        try {
            if (rowStr == null) {
                return null;
            }
            String[] patterns = new String[]{"^\\d{4}-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9](.\\d{1,9})?Z", "^\\d{4}-[0-1][0-9]-[0-3][0-9]"};
            int index = this.checkFormat(rowStr, "getDate", patterns);
            DateTimestampsUtil dtsUtil = new DateTimestampsUtil();
            if (index == 1) {
                return dtsUtil.getDate(rowStr);
            }
            return dtsUtil.getDate(rowStr, this.timeZoneID);
        }
        catch (IllegalArgumentException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getDate"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.ensureOpen("getTime(int columnIndex)");
        this.nextCalled();
        String rowStr = this.getRowStr(columnIndex);
        try {
            if (rowStr == null) {
                return null;
            }
            String[] patterns = new String[]{"^\\d{4}-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9](.\\d{1,9})?Z", "[0-2][0-9]:[0-6][0-9]:[0-6][0-9](.\\d{3})?"};
            int index = this.checkFormat(rowStr, "getTime", patterns);
            Calendar cal = Calendar.getInstance(TimeZone.getDefault());
            DateTimestampsUtil dtsUtil = new DateTimestampsUtil();
            if (index == 1) {
                return dtsUtil.getTime(rowStr);
            }
            return dtsUtil.getTime(rowStr, this.timeZoneID, cal);
        }
        catch (IllegalArgumentException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getTime"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        catch (SQLException e) {
            throw e;
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.ensureOpen("getTimestamp(int columnIndex)");
        this.nextCalled();
        String rowStr = this.getRowStr(columnIndex);
        try {
            if (rowStr == null) {
                return null;
            }
            String[] patterns = new String[]{"^\\d{4}-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9](.\\d{1,9})?Z"};
            this.checkFormat(rowStr, "getTimestamp", patterns);
            DateTimestampsUtil ts = new DateTimestampsUtil();
            return ts.getTimestamp(rowStr, this.timeZoneID);
        }
        catch (IllegalArgumentException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getTimestamp"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getAsciiStream(int columnIndex)", this.getClass().getSimpleName()));
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getUnicodeStream(int columnIndex)", this.getClass().getSimpleName()));
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getBinaryStream(int columnIndex)", this.getClass().getSimpleName()));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getBlob(int columnIndex)", this.getClass().getSimpleName()));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.ensureOpen("getClob(int columnIndex)");
        this.nextCalled();
        if (this.getRowStr(columnIndex) == null) {
            return null;
        }
        return new CLOB(this.getRowStr(columnIndex));
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        this.ensureOpen("getClob(String columnLabel)");
        this.nextCalled();
        int columnIndex = this.extractColIndex(this.colNames, columnLabel, "getClob(String columnLabel)");
        if (this.getRowStr(columnIndex) == null) {
            return null;
        }
        return new CLOB(this.getRowStr(columnIndex));
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getArray(int columnIndex)", this.getClass().getSimpleName()));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return new StringReader(this.getRowStr(columnIndex));
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        int colIndex = this.extractColIndex(this.colNames, columnLabel, "getCharacterStream(String columnLabel)");
        return new StringReader(this.getRowStr(colIndex));
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getBlob(String columnLabel)", this.getClass().getSimpleName()));
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getArray(String columnLabel)", this.getClass().getSimpleName()));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        int colIndex = this.extractColIndex(this.colNames, columnLabel, "getAsciiStream(String columnLabel)");
        return new ByteArrayInputStream(this.getRowStr(colIndex).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getUnicodeStream(String columnLabel)", this.getClass().getSimpleName()));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "getBinaryStream(String columnLabel)", this.getClass().getSimpleName()));
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        this.nextCalled();
        int columnIndex = this.extractColIndex(this.colNames, columnLabel, "getString(String columnLabel)");
        return this.getRowStr(columnIndex);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        this.nextCalled();
        int columnIndex = this.extractColIndex(this.colNames, columnLabel, "getShort(String columnLabel)");
        return this.getShort(columnIndex);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        this.nextCalled();
        int columnIndex = this.extractColIndex(this.colNames, columnLabel, "getInt(String columnLabel)");
        return this.getInt(columnIndex);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        this.nextCalled();
        int columnIndex = this.extractColIndex(this.colNames, columnLabel, "getLong(String columnLabel)");
        return this.getLong(columnIndex);
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        this.nextCalled();
        int columnIndex = this.extractColIndex(this.colNames, columnLabel, "getFloat(String columnLabel)");
        return this.getFloat(columnIndex);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        this.nextCalled();
        int columnIndex = this.extractColIndex(this.colNames, columnLabel, "getDouble(String columnLabel)");
        return this.getDouble(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.ensureOpen("getBigDecimal(int columnIndex)");
        this.nextCalled();
        String rowStr = this.getRowStr(columnIndex);
        try {
            if (rowStr == null || rowStr.equals("null")) {
                return null;
            }
            return new BigDecimal(rowStr);
        }
        catch (NumberFormatException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getBigDecimal"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.SEVERE, e.getCause().toString());
            throw new SQLException(RestjdbcResources.get("RESTJDBC_010"));
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        this.nextCalled();
        int columnIndex = this.extractColIndex(this.colNames, columnLabel, "getBigDecimal(String columnLabel)");
        return this.getBigDecimal(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.ensureOpen("getBoolean(int columnIndex)");
        this.nextCalled();
        try {
            TreeNode node = this.rowData.get(columnIndex);
            JSON json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
            String bool = json.asString((Object)node);
            if (bool.equalsIgnoreCase("true")) {
                return true;
            }
            if (bool.equalsIgnoreCase("null")) {
                return false;
            }
            JrsString s = (JrsString)this.rsMetadataTree.get(TOKEN_START_METADATA).get(columnIndex - 1).get("columnTypeName");
            String type = s.getValue();
            if (type.contains("NUMBER")) {
                if (Long.parseLong(bool) > 0L) {
                    return true;
                }
                if (Long.parseLong(bool) == 0L) {
                    return false;
                }
                return false;
            }
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getBoolean"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.SEVERE, e.getCause().toString());
            throw new SQLException(RestjdbcResources.get("RESTJDBC_010"));
        }
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        this.nextCalled();
        int columnIndex = this.extractColIndex(this.colNames, columnLabel, "getBoolean(String columnLabel)");
        return this.getBoolean(columnIndex);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        this.nextCalled();
        int columnIndex = this.extractColIndex(this.colNames, columnLabel, "getDate(String columnLabel)");
        return this.getDate(columnIndex);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        this.nextCalled();
        int columnIndex = this.extractColIndex(this.colNames, columnLabel, "getTime(String columnLabel)");
        return this.getTime(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        this.nextCalled();
        int columnIndex = this.extractColIndex(this.colNames, columnLabel, "getTimestamp(String columnLabel)");
        return this.getTimestamp(columnIndex);
    }

    @Override
    public void close() throws SQLException {
        try {
            if (!this.closed) {
                this.closed = true;
                this.isResultSetClosed = true;
                this.stream.close();
                this.rsMetadataTree = null;
                this.colNames = null;
                this.rowData = null;
                if (this.stmt != null) {
                    --this.stmt.rsCount;
                } else if (this.pstmt != null) {
                    --this.pstmt.rsCount;
                }
            }
        }
        catch (IOException e) {
            this.LOGGER.log(Level.SEVERE, e.getCause().toString());
        }
    }

    protected void handleErrors(TreeNode node) throws SQLException {
        if (node.get("errorCode") != null) {
            JrsNumber n = (JrsNumber)node.get("errorCode");
            int errorCode = n.getValue().intValue();
            JrsString messageElem = (JrsString)node.get("errorMessage");
            String message = messageElem.getValue() + "\n";
            throw new SQLException(message, SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        if (node.get("error") != null) {
            JrsString s = (JrsString)node.get("error");
            throw new SQLException(s.getValue());
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.closed) {
            this.closedrsException("getMetaData");
        }
        if (!this.metadata) {
            int errorCode = 17283;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        return new ResultSetMetadata(this.rsMetadataTree);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.throwUnsupportedException("isBeforeFirst()");
        return false;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.throwUnsupportedException("isAfterLast()");
        return false;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.throwUnsupportedException("isFirst()");
        return false;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.throwUnsupportedException("isLast");
        return false;
    }

    @Override
    public java.sql.Statement getStatement() throws SQLException {
        this.ensureOpen("getStatement");
        try {
            if (this.isResultSetClosed) {
                throw new SQLException(RestjdbcResources.getString("RESTJDBC_006"));
            }
            if (this.stmt != null && this.pstmt == null && this.cstmt == null) {
                return this.stmt;
            }
            if (this.stmt == null && this.pstmt != null && this.cstmt == null) {
                return this.pstmt;
            }
            if (this.stmt == null && this.pstmt == null && this.cstmt != null) {
                return this.cstmt;
            }
        }
        catch (Exception e) {
            this.LOGGER.log(Level.SEVERE, e.getCause().toString());
        }
        throw new SQLException(RestjdbcResources.get("ORA_17001"));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.throwUnsupportedException("unwrap(Class<T> iface)");
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.throwUnsupportedException("isWrapperFor(Class<?> iface)");
        return false;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getByte(int columnIndex)", this.getClass().getSimpleName()));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getBigDecimal(int columnIndex, int scale)", this.getClass().getSimpleName()));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getByte(String columnLabel)", this.getClass().getSimpleName()));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getBigDecimal(String columnLabel, int scale)", this.getClass().getSimpleName()));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        LogUtil.logOrException(this.getStatement().getConnection(), null, "ResultSet.getWarnings() not supported", null);
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "clearWarnings()", this.getClass().getSimpleName()));
    }

    @Override
    public String getCursorName() throws SQLException {
        this.throwUnsupportedException("getCursorName()");
        return null;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.extractColIndex(this.colNames, columnLabel, "findColumn(String columnLabel)");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "beforeFirst()", this.getClass().getSimpleName()));
    }

    @Override
    public void afterLast() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "afterLast()", this.getClass().getSimpleName()));
    }

    @Override
    public boolean first() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "first()", this.getClass().getSimpleName()));
    }

    @Override
    public boolean last() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "last()", this.getClass().getSimpleName()));
    }

    @Override
    public int getRow() throws SQLException {
        return this.rowCount;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        ExceptionUtil.throwSQLException(17075, "absolute");
        return false;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "last()", this.getClass().getSimpleName()));
    }

    @Override
    public boolean previous() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "previous()", this.getClass().getSimpleName()));
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (this.closed) {
            this.closedrsException("setFetchDirection(int direction)");
        }
        if (direction != 1000) {
            ExceptionUtil.throwSQLException(17308);
        } else {
            this.fetchDirection = direction;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (this.closed) {
            this.closedrsException("getFetchDirection()");
        }
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (this.closed) {
            this.closedrsException("setFetchSize(int rows)");
        }
        if (rows < 0) {
            int errorCode = 17433;
            throw new SQLException(ExceptionUtil.getErrorMessage(17433));
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.closed) {
            this.closedrsException("getFetchSize()");
            return -1;
        }
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        this.ensureOpen("getType()");
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getConcurrency()", this.getClass().getSimpleName()));
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "rowUpdated()", this.getClass().getSimpleName()));
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "rowInserted()", this.getClass().getSimpleName()));
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "rowDeleted()", this.getClass().getSimpleName()));
    }

    @Override
    public void insertRow() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "insertRow()", this.getClass().getSimpleName()));
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "deleteRow()", this.getClass().getSimpleName()));
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "refreshRow()", this.getClass().getSimpleName()));
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "cancelRowUpdates()", this.getClass().getSimpleName()));
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "moveToInsertRow()", this.getClass().getSimpleName()));
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "moveToCurrentRow()", this.getClass().getSimpleName()));
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        this.ensureOpen("getObject(int columnIndex, Map<String, Class<?>> map)");
        Object obj = this.getObjectHelper(columnIndex);
        return obj;
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getRef(int columnIndex)", this.getClass().getSimpleName()));
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getRef(String columnLabel)", this.getClass().getSimpleName()));
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        this.ensureOpen("getObject(String columnLabel, Map<String, Class<?>> map)");
        int columnIndex = this.extractColIndex(this.colNames, columnLabel, "getObject(String columnLabel)");
        Object obj = this.getObjectHelper(columnIndex);
        return obj;
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        String rowStr = this.getRowStr(columnIndex);
        try {
            if (rowStr == null) {
                return null;
            }
            DateTimestampsUtil ts = new DateTimestampsUtil();
            return ts.getDate(rowStr, this.timeZoneID, cal);
        }
        catch (IllegalArgumentException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getDate"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        int columnIndex = this.extractColIndex(this.colNames, columnLabel, "getDate(String columnLabel, Calendar cal)");
        return this.getDate(columnIndex, cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        String rowStr = this.getRowStr(columnIndex);
        try {
            if (rowStr == null) {
                return null;
            }
            DateTimestampsUtil ts = new DateTimestampsUtil();
            return ts.getTime(rowStr, this.timeZoneID, cal);
        }
        catch (IllegalArgumentException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getTime"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        int columnIndex = this.extractColIndex(this.colNames, columnLabel, "getTime(String columnLabel, Calendar cal)");
        return this.getTime(columnIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        String rowStr = this.getRowStr(columnIndex);
        try {
            if (rowStr == null) {
                return null;
            }
            DateTimestampsUtil ts = new DateTimestampsUtil();
            return ts.getTimestamp(rowStr, this.timeZoneID, cal);
        }
        catch (IllegalArgumentException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getTimestamp"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        int columnIndex = this.extractColIndex(this.colNames, columnLabel, "getTimestamp(String columnLabel, Calendar cal)");
        return this.getTimestamp(columnIndex, cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        try {
            if (this.closed) {
                this.closedrsException("getURL(int columnIndex)");
            }
            return new URL(this.getRowStr(columnIndex));
        }
        catch (MalformedURLException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getURL"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        int columnIndex = this.extractColIndex(this.colNames, columnLabel, "getURL(String columnLabel)");
        return this.getURL(columnIndex);
    }

    @Override
    public java.sql.RowId getRowId(int columnIndex) throws SQLException {
        this.ensureOpen("getRowId(int columnIndex)");
        try {
            JrsString s = (JrsString)this.rsMetadataTree.get(TOKEN_START_METADATA).get(0).get("columnTypeName");
            String columnTypeName = s.getValue();
            String rowID = this.getRowStr(columnIndex);
            if (!columnTypeName.equals("CHAR") || !columnTypeName.equals("VARCHAR2")) {
                int errorCode = 17004;
                throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getRowId"), SQLStateMapping.getSQLState(errorCode), errorCode);
            }
            return new RowId(rowID);
        }
        catch (IllegalArgumentException e) {
            int errorCode = 17004;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, "getRowId"), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public java.sql.RowId getRowId(String columnLabel) throws SQLException {
        int columnIndex = this.extractColIndex(this.colNames, columnLabel, "getRowId(String columnLabel)");
        return this.getRowId(columnIndex);
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getHoldability()", this.getClass().getSimpleName()));
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getNClob(int columnIndex)", this.getClass().getSimpleName()));
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getNClob(String columnLabel)", this.getClass().getSimpleName()));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getSQLXML(int columnIndex)", this.getClass().getSimpleName()));
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getSQLXML(String columnLabel)", this.getClass().getSimpleName()));
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getNString(int columnIndex)", this.getClass().getSimpleName()));
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getNString(String columnLabel)", this.getClass().getSimpleName()));
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getNCharacterStream(int columnIndex)", this.getClass().getSimpleName()));
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getNCharacterStream(String columnLabel)", this.getClass().getSimpleName()));
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getObject(int columnIndex, Class<T> type)", this.getClass().getSimpleName()));
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getObject(String columnLabel, Class<T> type)", this.getClass().getSimpleName()));
    }

    protected void closedrsException(String methodName) throws SQLException {
        int errorCode = 17010;
        throw new SQLException(ExceptionUtil.getErrorMessage(errorCode, methodName), SQLStateMapping.getSQLState(errorCode), errorCode);
    }

    @Override
    public void updateRow() throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateRow()", this.getClass().getSimpleName()));
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateNull(int columnIndex)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateBoolean(int columnIndex, boolean x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateByte(int columnIndex, byte x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateShort(int columnIndex, short x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateInt(int columnIndex, int x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateLong(int columnIndex, long x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateFloat(int columnIndex, float x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateDouble(int columnIndex, double x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateBigDecimal(int columnIndex, BigDecimal x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateString(int columnIndex, String x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateBytes(int columnIndex, byte[] x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateDate(int columnIndex, Date x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateTime(int columnIndex, Time x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateTimestamp(int columnIndex, Timestamp x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateAsciiStream(int columnIndex, InputStream x, int length)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateBinaryStream(int columnIndex, InputStream x, int length)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateCharacterStream(int columnIndex, Reader x, int length)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateObject(int columnIndex, Object x, int scaleOrLength)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateObject(int columnIndex, Object x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateNull(String columnLabel)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateBoolean(String columnLabel, boolean x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateByte(String columnLabel, byte x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateShort(String columnLabel, short x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateInt(String columnLabel, int x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateLong(String columnLabel, long x", this.getClass().getSimpleName()));
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateFloat(String columnLabel, float x", this.getClass().getSimpleName()));
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateDouble(String columnLabel, double x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateBigDecimal(String columnLabel, BigDecimal x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateString(String columnLabel, String x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateBytes(String columnLabel, byte[] x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateDate(String columnLabel, Date x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateTime(String columnLabel, Time x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateTimestamp(String columnLabel, Timestamp x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateAsciiStream(String columnLabel, InputStream x, int length)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateBinaryStream(String columnLabel, InputStream x, int length)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateCharacterStream(String columnLabel, Reader reader, int length)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateObject(String columnLabel, Object x, int scaleOrLength)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateObject(String columnLabel, Object x", this.getClass().getSimpleName()));
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateNCharacterStream(int columnIndex, Reader x, long length)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateNCharacterStream(String columnLabel, Reader reader, long length)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateAsciiStream(int columnIndex, InputStream x, long length)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateBinaryStream(int columnIndex, InputStream x, long length)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateCharacterStream(int columnIndex, Reader x, long length)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateAsciiStream(String columnLabel, InputStream x, long length)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateBinaryStream(String columnLabel, InputStream x, long length)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateCharacterStream(String columnLabel, Reader reader, long length) ", this.getClass().getSimpleName()));
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateBlob(int columnIndex, InputStream inputStream, long length)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateBlob(String columnLabel, InputStream inputStream, long length) ", this.getClass().getSimpleName()));
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateClob(int columnIndex, Reader reader, long length)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateClob(String columnLabel, Reader reader, long length)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateNClob(int columnIndex, Reader reader, long length)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateNClob(String columnLabel, Reader reader, long length)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateNCharacterStream(int columnIndex, Reader x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateNCharacterStream(String columnLabel, Reader reader)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateAsciiStream(int columnIndex, InputStream x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateBinaryStream(int columnIndex, InputStream x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateCharacterStream(int columnIndex, Reader x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateAsciiStream(String columnLabel, InputStream x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateBinaryStream(String columnLabel, InputStream x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateCharacterStream(String columnLabel, Reader reader)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateBlob(int columnIndex, InputStream inputStream)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateBlob(String columnLabel, InputStream inputStream)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateClob(int columnIndex, Reader reader)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateClob(String columnLabel, Reader reader)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateNClob(int columnIndex, Reader reader)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateNClob(String columnLabel, Reader reader)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateSQLXML(int columnIndex, SQLXML xmlObject)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "", this.getClass().getSimpleName()));
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateNString(int columnIndex, String nString)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateNString(String columnLabel, String nString)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateNClob(int columnIndex, NClob nClob)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateNClob(String columnLabel, NClob nClob)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateRowId(int columnIndex, java.sql.RowId x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateRowId(int columnIndex, RowId x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateRowId(String columnLabel, java.sql.RowId x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateRowId(String columnLabel, RowId x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateRef(int columnIndex, Ref x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateRef(String columnLabel, Ref x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateBlob(int columnIndex, Blob x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateBlob(String columnLabel, Blob x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateClob(int columnIndex, Clob x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateClob(String columnLabel, Clob x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateArray(int columnIndex, Array x)", this.getClass().getSimpleName()));
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "updateArray(String columnLabel, Array x)", this.getClass().getSimpleName()));
    }

    protected String exceptionLogMessage(boolean unsupport, String methodName) {
        if (unsupport) {
            return RestjdbcResources.format("RESTJDBC_UNSUPPORTED", methodName, this.getClass().getSimpleName());
        }
        return RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", methodName, this.getClass().getSimpleName());
    }

    private void throwUnsupportedException(String methodName) throws SQLException {
        ExceptionUtil.logExceptionUnsupported(this.conn, methodName, "ResultSet");
    }
}

