/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci;

import com.oracle.bmc.secrets.SecretsClient;
import com.oracle.bmc.secrets.model.Base64SecretBundleContentDetails;
import com.oracle.bmc.secrets.model.SecretBundle;
import com.oracle.bmc.secrets.requests.GetSecretBundleRequest;
import com.oracle.bmc.secrets.responses.GetSecretBundleResponse;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Base64;
import oracle.dbtools.core.oci.AuthenticationProvider;
import oracle.dbtools.core.oci.OCIClient;
import oracle.dbtools.core.secrets.Secrets;
import oracle.dbtools.core.secrets.TextSecret;

public final class OCISecretsClient
extends OCIClient {
    private final SecretsClient secretsClient = (SecretsClient)this.createClient(SecretsClient.builder());

    public static Builder builder(AuthenticationProvider profile) {
        return new Builder(profile);
    }

    private OCISecretsClient(Builder builder) {
        super(builder);
    }

    public TextSecret getSecret(String secretId) {
        if (secretId == null) {
            throw new IllegalStateException("secretId cannot be null");
        }
        GetSecretBundleResponse secretResponse = OCISecretsClient.executeRequest(() -> this.secretsClient.getSecretBundle(GetSecretBundleRequest.builder().secretId(secretId).build()));
        SecretBundle secretBundle = secretResponse.getSecretBundle();
        String enc = ((Base64SecretBundleContentDetails)secretBundle.getSecretBundleContent()).getContent();
        byte[] decoded = Base64.getDecoder().decode(enc.getBytes());
        CharBuffer cb = Charset.defaultCharset().decode(ByteBuffer.wrap(decoded));
        TextSecret textSecret = Secrets.instance().of(cb.array(), true);
        cb.clear();
        return textSecret;
    }

    public static final class Builder
    extends OCIClient.Builder<Builder, OCISecretsClient> {
        private Builder(AuthenticationProvider profile) {
            super(profile);
        }

        @Override
        public OCISecretsClient build() {
            return new OCISecretsClient(this);
        }
    }
}

