/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListContainerDatabasePatchesRequest
extends BmcRequest<Void> {
    private String autonomousContainerDatabaseId;
    private String compartmentId;
    private Integer limit;
    private String page;
    private AutonomousPatchType autonomousPatchType;

    public String getAutonomousContainerDatabaseId() {
        return this.autonomousContainerDatabaseId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public AutonomousPatchType getAutonomousPatchType() {
        return this.autonomousPatchType;
    }

    public Builder toBuilder() {
        return new Builder().autonomousContainerDatabaseId(this.autonomousContainerDatabaseId).compartmentId(this.compartmentId).limit(this.limit).page(this.page).autonomousPatchType(this.autonomousPatchType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",autonomousContainerDatabaseId=").append(String.valueOf(this.autonomousContainerDatabaseId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",autonomousPatchType=").append(String.valueOf((Object)this.autonomousPatchType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListContainerDatabasePatchesRequest)) {
            return false;
        }
        ListContainerDatabasePatchesRequest other = (ListContainerDatabasePatchesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.autonomousContainerDatabaseId, other.autonomousContainerDatabaseId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.autonomousPatchType, (Object)other.autonomousPatchType);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.autonomousContainerDatabaseId == null ? 43 : this.autonomousContainerDatabaseId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.autonomousPatchType == null ? 43 : this.autonomousPatchType.hashCode());
        return result;
    }

    public static enum AutonomousPatchType implements BmcEnum
    {
        Quarterly("QUARTERLY"),
        Timezone("TIMEZONE");

        private final String value;
        private static Map<String, AutonomousPatchType> map;

        private AutonomousPatchType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AutonomousPatchType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AutonomousPatchType: " + key);
        }

        static {
            map = new HashMap<String, AutonomousPatchType>();
            for (AutonomousPatchType v : AutonomousPatchType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static class Builder
    implements BmcRequest.Builder<ListContainerDatabasePatchesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String autonomousContainerDatabaseId = null;
        private String compartmentId = null;
        private Integer limit = null;
        private String page = null;
        private AutonomousPatchType autonomousPatchType = null;

        public Builder autonomousContainerDatabaseId(String autonomousContainerDatabaseId) {
            this.autonomousContainerDatabaseId = autonomousContainerDatabaseId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder autonomousPatchType(AutonomousPatchType autonomousPatchType) {
            this.autonomousPatchType = autonomousPatchType;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListContainerDatabasePatchesRequest o) {
            this.autonomousContainerDatabaseId(o.getAutonomousContainerDatabaseId());
            this.compartmentId(o.getCompartmentId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.autonomousPatchType(o.getAutonomousPatchType());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListContainerDatabasePatchesRequest build() {
            ListContainerDatabasePatchesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListContainerDatabasePatchesRequest buildWithoutInvocationCallback() {
            ListContainerDatabasePatchesRequest request = new ListContainerDatabasePatchesRequest();
            request.autonomousContainerDatabaseId = this.autonomousContainerDatabaseId;
            request.compartmentId = this.compartmentId;
            request.limit = this.limit;
            request.page = this.page;
            request.autonomousPatchType = this.autonomousPatchType;
            return request;
        }
    }
}

