/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.AutonomousDatabaseEncryptionKeyDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="provider")
@JsonFilter(value="explicitlySetFilter")
public final class OkvKeyDetails
extends AutonomousDatabaseEncryptionKeyDetails {
    @JsonProperty(value="okvUri")
    private final String okvUri;
    @JsonProperty(value="okvKmsKey")
    private final String okvKmsKey;
    @JsonProperty(value="directoryName")
    private final String directoryName;
    @JsonProperty(value="certificateDirectoryName")
    private final String certificateDirectoryName;
    @JsonProperty(value="certificateId")
    private final String certificateId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public OkvKeyDetails(String okvUri, String okvKmsKey, String directoryName, String certificateDirectoryName, String certificateId) {
        this.okvUri = okvUri;
        this.okvKmsKey = okvKmsKey;
        this.directoryName = directoryName;
        this.certificateDirectoryName = certificateDirectoryName;
        this.certificateId = certificateId;
    }

    public String getOkvUri() {
        return this.okvUri;
    }

    public String getOkvKmsKey() {
        return this.okvKmsKey;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public String getCertificateDirectoryName() {
        return this.certificateDirectoryName;
    }

    public String getCertificateId() {
        return this.certificateId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OkvKeyDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", okvUri=").append(String.valueOf(this.okvUri));
        sb.append(", okvKmsKey=").append(String.valueOf(this.okvKmsKey));
        sb.append(", directoryName=").append(String.valueOf(this.directoryName));
        sb.append(", certificateDirectoryName=").append(String.valueOf(this.certificateDirectoryName));
        sb.append(", certificateId=").append(String.valueOf(this.certificateId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OkvKeyDetails)) {
            return false;
        }
        OkvKeyDetails other = (OkvKeyDetails)((Object)o);
        return Objects.equals(this.okvUri, other.okvUri) && Objects.equals(this.okvKmsKey, other.okvKmsKey) && Objects.equals(this.directoryName, other.directoryName) && Objects.equals(this.certificateDirectoryName, other.certificateDirectoryName) && Objects.equals(this.certificateId, other.certificateId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.okvUri == null ? 43 : this.okvUri.hashCode());
        result = result * 59 + (this.okvKmsKey == null ? 43 : this.okvKmsKey.hashCode());
        result = result * 59 + (this.directoryName == null ? 43 : this.directoryName.hashCode());
        result = result * 59 + (this.certificateDirectoryName == null ? 43 : this.certificateDirectoryName.hashCode());
        result = result * 59 + (this.certificateId == null ? 43 : this.certificateId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="okvUri")
        private String okvUri;
        @JsonProperty(value="okvKmsKey")
        private String okvKmsKey;
        @JsonProperty(value="directoryName")
        private String directoryName;
        @JsonProperty(value="certificateDirectoryName")
        private String certificateDirectoryName;
        @JsonProperty(value="certificateId")
        private String certificateId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder okvUri(String okvUri) {
            this.okvUri = okvUri;
            this.__explicitlySet__.add("okvUri");
            return this;
        }

        public Builder okvKmsKey(String okvKmsKey) {
            this.okvKmsKey = okvKmsKey;
            this.__explicitlySet__.add("okvKmsKey");
            return this;
        }

        public Builder directoryName(String directoryName) {
            this.directoryName = directoryName;
            this.__explicitlySet__.add("directoryName");
            return this;
        }

        public Builder certificateDirectoryName(String certificateDirectoryName) {
            this.certificateDirectoryName = certificateDirectoryName;
            this.__explicitlySet__.add("certificateDirectoryName");
            return this;
        }

        public Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            this.__explicitlySet__.add("certificateId");
            return this;
        }

        public OkvKeyDetails build() {
            OkvKeyDetails model = new OkvKeyDetails(this.okvUri, this.okvKmsKey, this.directoryName, this.certificateDirectoryName, this.certificateId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OkvKeyDetails model) {
            if (model.wasPropertyExplicitlySet("okvUri")) {
                this.okvUri(model.getOkvUri());
            }
            if (model.wasPropertyExplicitlySet("okvKmsKey")) {
                this.okvKmsKey(model.getOkvKmsKey());
            }
            if (model.wasPropertyExplicitlySet("directoryName")) {
                this.directoryName(model.getDirectoryName());
            }
            if (model.wasPropertyExplicitlySet("certificateDirectoryName")) {
                this.certificateDirectoryName(model.getCertificateDirectoryName());
            }
            if (model.wasPropertyExplicitlySet("certificateId")) {
                this.certificateId(model.getCertificateId());
            }
            return this;
        }
    }
}

