/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.DefinedFileSystemConfiguration;
import com.oracle.bmc.database.model.ExadataInfrastructureContact;
import com.oracle.bmc.database.model.ExascaleConfigDetails;
import com.oracle.bmc.database.model.MaintenanceWindow;
import com.oracle.bmc.database.model.NetworkBondingModeDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExadataInfrastructureSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="timeZone")
    private final String timeZone;
    @JsonProperty(value="cpusEnabled")
    private final Integer cpusEnabled;
    @JsonProperty(value="maxCpuCount")
    private final Integer maxCpuCount;
    @JsonProperty(value="memorySizeInGBs")
    private final Integer memorySizeInGBs;
    @JsonProperty(value="maxMemoryInGBs")
    private final Integer maxMemoryInGBs;
    @JsonProperty(value="dbNodeStorageSizeInGBs")
    private final Integer dbNodeStorageSizeInGBs;
    @JsonProperty(value="maxDbNodeStorageInGBs")
    private final Integer maxDbNodeStorageInGBs;
    @JsonProperty(value="dataStorageSizeInTBs")
    private final Double dataStorageSizeInTBs;
    @JsonProperty(value="maxDataStorageInTBs")
    private final Double maxDataStorageInTBs;
    @JsonProperty(value="rackSerialNumber")
    private final String rackSerialNumber;
    @JsonProperty(value="storageCount")
    private final Integer storageCount;
    @JsonProperty(value="additionalStorageCount")
    private final Integer additionalStorageCount;
    @JsonProperty(value="activatedStorageCount")
    private final Integer activatedStorageCount;
    @JsonProperty(value="computeCount")
    private final Integer computeCount;
    @JsonProperty(value="isMultiRackDeployment")
    private final Boolean isMultiRackDeployment;
    @JsonProperty(value="multiRackConfigurationFile")
    private final byte[] multiRackConfigurationFile;
    @JsonProperty(value="additionalComputeCount")
    private final Integer additionalComputeCount;
    @JsonProperty(value="additionalComputeSystemModel")
    private final AdditionalComputeSystemModel additionalComputeSystemModel;
    @JsonProperty(value="cloudControlPlaneServer1")
    private final String cloudControlPlaneServer1;
    @JsonProperty(value="cloudControlPlaneServer2")
    private final String cloudControlPlaneServer2;
    @JsonProperty(value="netmask")
    private final String netmask;
    @JsonProperty(value="gateway")
    private final String gateway;
    @JsonProperty(value="adminNetworkCIDR")
    private final String adminNetworkCIDR;
    @JsonProperty(value="infiniBandNetworkCIDR")
    private final String infiniBandNetworkCIDR;
    @JsonProperty(value="corporateProxy")
    private final String corporateProxy;
    @JsonProperty(value="dnsServer")
    private final List<String> dnsServer;
    @JsonProperty(value="ntpServer")
    private final List<String> ntpServer;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="csiNumber")
    private final String csiNumber;
    @JsonProperty(value="contacts")
    private final List<ExadataInfrastructureContact> contacts;
    @JsonProperty(value="maintenanceSLOStatus")
    private final MaintenanceSLOStatus maintenanceSLOStatus;
    @JsonProperty(value="maintenanceWindow")
    private final MaintenanceWindow maintenanceWindow;
    @JsonProperty(value="storageServerVersion")
    private final String storageServerVersion;
    @JsonProperty(value="dbServerVersion")
    private final String dbServerVersion;
    @JsonProperty(value="monthlyDbServerVersion")
    private final String monthlyDbServerVersion;
    @JsonProperty(value="lastMaintenanceRunId")
    private final String lastMaintenanceRunId;
    @JsonProperty(value="nextMaintenanceRunId")
    private final String nextMaintenanceRunId;
    @JsonProperty(value="isCpsOfflineReportEnabled")
    private final Boolean isCpsOfflineReportEnabled;
    @JsonProperty(value="networkBondingModeDetails")
    private final NetworkBondingModeDetails networkBondingModeDetails;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="definedFileSystemConfigurations")
    private final List<DefinedFileSystemConfiguration> definedFileSystemConfigurations;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="isSchedulingPolicyAssociated")
    private final Boolean isSchedulingPolicyAssociated;
    @JsonProperty(value="exascaleConfig")
    private final ExascaleConfigDetails exascaleConfig;
    @JsonProperty(value="databaseServerType")
    private final String databaseServerType;
    @JsonProperty(value="storageServerType")
    private final String storageServerType;
    @JsonProperty(value="computeModel")
    private final ComputeModel computeModel;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "lifecycleState", "displayName", "shape", "timeZone", "cpusEnabled", "maxCpuCount", "memorySizeInGBs", "maxMemoryInGBs", "dbNodeStorageSizeInGBs", "maxDbNodeStorageInGBs", "dataStorageSizeInTBs", "maxDataStorageInTBs", "rackSerialNumber", "storageCount", "additionalStorageCount", "activatedStorageCount", "computeCount", "isMultiRackDeployment", "multiRackConfigurationFile", "additionalComputeCount", "additionalComputeSystemModel", "cloudControlPlaneServer1", "cloudControlPlaneServer2", "netmask", "gateway", "adminNetworkCIDR", "infiniBandNetworkCIDR", "corporateProxy", "dnsServer", "ntpServer", "timeCreated", "lifecycleDetails", "csiNumber", "contacts", "maintenanceSLOStatus", "maintenanceWindow", "storageServerVersion", "dbServerVersion", "monthlyDbServerVersion", "lastMaintenanceRunId", "nextMaintenanceRunId", "isCpsOfflineReportEnabled", "networkBondingModeDetails", "availabilityDomain", "definedFileSystemConfigurations", "freeformTags", "definedTags", "isSchedulingPolicyAssociated", "exascaleConfig", "databaseServerType", "storageServerType", "computeModel"})
    public ExadataInfrastructureSummary(String id, String compartmentId, LifecycleState lifecycleState, String displayName, String shape, String timeZone, Integer cpusEnabled, Integer maxCpuCount, Integer memorySizeInGBs, Integer maxMemoryInGBs, Integer dbNodeStorageSizeInGBs, Integer maxDbNodeStorageInGBs, Double dataStorageSizeInTBs, Double maxDataStorageInTBs, String rackSerialNumber, Integer storageCount, Integer additionalStorageCount, Integer activatedStorageCount, Integer computeCount, Boolean isMultiRackDeployment, byte[] multiRackConfigurationFile, Integer additionalComputeCount, AdditionalComputeSystemModel additionalComputeSystemModel, String cloudControlPlaneServer1, String cloudControlPlaneServer2, String netmask, String gateway, String adminNetworkCIDR, String infiniBandNetworkCIDR, String corporateProxy, List<String> dnsServer, List<String> ntpServer, Date timeCreated, String lifecycleDetails, String csiNumber, List<ExadataInfrastructureContact> contacts, MaintenanceSLOStatus maintenanceSLOStatus, MaintenanceWindow maintenanceWindow, String storageServerVersion, String dbServerVersion, String monthlyDbServerVersion, String lastMaintenanceRunId, String nextMaintenanceRunId, Boolean isCpsOfflineReportEnabled, NetworkBondingModeDetails networkBondingModeDetails, String availabilityDomain, List<DefinedFileSystemConfiguration> definedFileSystemConfigurations, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Boolean isSchedulingPolicyAssociated, ExascaleConfigDetails exascaleConfig, String databaseServerType, String storageServerType, ComputeModel computeModel) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.lifecycleState = lifecycleState;
        this.displayName = displayName;
        this.shape = shape;
        this.timeZone = timeZone;
        this.cpusEnabled = cpusEnabled;
        this.maxCpuCount = maxCpuCount;
        this.memorySizeInGBs = memorySizeInGBs;
        this.maxMemoryInGBs = maxMemoryInGBs;
        this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
        this.maxDbNodeStorageInGBs = maxDbNodeStorageInGBs;
        this.dataStorageSizeInTBs = dataStorageSizeInTBs;
        this.maxDataStorageInTBs = maxDataStorageInTBs;
        this.rackSerialNumber = rackSerialNumber;
        this.storageCount = storageCount;
        this.additionalStorageCount = additionalStorageCount;
        this.activatedStorageCount = activatedStorageCount;
        this.computeCount = computeCount;
        this.isMultiRackDeployment = isMultiRackDeployment;
        this.multiRackConfigurationFile = multiRackConfigurationFile;
        this.additionalComputeCount = additionalComputeCount;
        this.additionalComputeSystemModel = additionalComputeSystemModel;
        this.cloudControlPlaneServer1 = cloudControlPlaneServer1;
        this.cloudControlPlaneServer2 = cloudControlPlaneServer2;
        this.netmask = netmask;
        this.gateway = gateway;
        this.adminNetworkCIDR = adminNetworkCIDR;
        this.infiniBandNetworkCIDR = infiniBandNetworkCIDR;
        this.corporateProxy = corporateProxy;
        this.dnsServer = dnsServer;
        this.ntpServer = ntpServer;
        this.timeCreated = timeCreated;
        this.lifecycleDetails = lifecycleDetails;
        this.csiNumber = csiNumber;
        this.contacts = contacts;
        this.maintenanceSLOStatus = maintenanceSLOStatus;
        this.maintenanceWindow = maintenanceWindow;
        this.storageServerVersion = storageServerVersion;
        this.dbServerVersion = dbServerVersion;
        this.monthlyDbServerVersion = monthlyDbServerVersion;
        this.lastMaintenanceRunId = lastMaintenanceRunId;
        this.nextMaintenanceRunId = nextMaintenanceRunId;
        this.isCpsOfflineReportEnabled = isCpsOfflineReportEnabled;
        this.networkBondingModeDetails = networkBondingModeDetails;
        this.availabilityDomain = availabilityDomain;
        this.definedFileSystemConfigurations = definedFileSystemConfigurations;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.isSchedulingPolicyAssociated = isSchedulingPolicyAssociated;
        this.exascaleConfig = exascaleConfig;
        this.databaseServerType = databaseServerType;
        this.storageServerType = storageServerType;
        this.computeModel = computeModel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getShape() {
        return this.shape;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public Integer getCpusEnabled() {
        return this.cpusEnabled;
    }

    public Integer getMaxCpuCount() {
        return this.maxCpuCount;
    }

    public Integer getMemorySizeInGBs() {
        return this.memorySizeInGBs;
    }

    public Integer getMaxMemoryInGBs() {
        return this.maxMemoryInGBs;
    }

    public Integer getDbNodeStorageSizeInGBs() {
        return this.dbNodeStorageSizeInGBs;
    }

    public Integer getMaxDbNodeStorageInGBs() {
        return this.maxDbNodeStorageInGBs;
    }

    public Double getDataStorageSizeInTBs() {
        return this.dataStorageSizeInTBs;
    }

    public Double getMaxDataStorageInTBs() {
        return this.maxDataStorageInTBs;
    }

    public String getRackSerialNumber() {
        return this.rackSerialNumber;
    }

    public Integer getStorageCount() {
        return this.storageCount;
    }

    public Integer getAdditionalStorageCount() {
        return this.additionalStorageCount;
    }

    public Integer getActivatedStorageCount() {
        return this.activatedStorageCount;
    }

    public Integer getComputeCount() {
        return this.computeCount;
    }

    public Boolean getIsMultiRackDeployment() {
        return this.isMultiRackDeployment;
    }

    public byte[] getMultiRackConfigurationFile() {
        return this.multiRackConfigurationFile;
    }

    public Integer getAdditionalComputeCount() {
        return this.additionalComputeCount;
    }

    public AdditionalComputeSystemModel getAdditionalComputeSystemModel() {
        return this.additionalComputeSystemModel;
    }

    public String getCloudControlPlaneServer1() {
        return this.cloudControlPlaneServer1;
    }

    public String getCloudControlPlaneServer2() {
        return this.cloudControlPlaneServer2;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getAdminNetworkCIDR() {
        return this.adminNetworkCIDR;
    }

    public String getInfiniBandNetworkCIDR() {
        return this.infiniBandNetworkCIDR;
    }

    public String getCorporateProxy() {
        return this.corporateProxy;
    }

    public List<String> getDnsServer() {
        return this.dnsServer;
    }

    public List<String> getNtpServer() {
        return this.ntpServer;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String getCsiNumber() {
        return this.csiNumber;
    }

    public List<ExadataInfrastructureContact> getContacts() {
        return this.contacts;
    }

    public MaintenanceSLOStatus getMaintenanceSLOStatus() {
        return this.maintenanceSLOStatus;
    }

    public MaintenanceWindow getMaintenanceWindow() {
        return this.maintenanceWindow;
    }

    public String getStorageServerVersion() {
        return this.storageServerVersion;
    }

    public String getDbServerVersion() {
        return this.dbServerVersion;
    }

    public String getMonthlyDbServerVersion() {
        return this.monthlyDbServerVersion;
    }

    public String getLastMaintenanceRunId() {
        return this.lastMaintenanceRunId;
    }

    public String getNextMaintenanceRunId() {
        return this.nextMaintenanceRunId;
    }

    public Boolean getIsCpsOfflineReportEnabled() {
        return this.isCpsOfflineReportEnabled;
    }

    public NetworkBondingModeDetails getNetworkBondingModeDetails() {
        return this.networkBondingModeDetails;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public List<DefinedFileSystemConfiguration> getDefinedFileSystemConfigurations() {
        return this.definedFileSystemConfigurations;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Boolean getIsSchedulingPolicyAssociated() {
        return this.isSchedulingPolicyAssociated;
    }

    public ExascaleConfigDetails getExascaleConfig() {
        return this.exascaleConfig;
    }

    public String getDatabaseServerType() {
        return this.databaseServerType;
    }

    public String getStorageServerType() {
        return this.storageServerType;
    }

    public ComputeModel getComputeModel() {
        return this.computeModel;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExadataInfrastructureSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(", timeZone=").append(String.valueOf(this.timeZone));
        sb.append(", cpusEnabled=").append(String.valueOf(this.cpusEnabled));
        sb.append(", maxCpuCount=").append(String.valueOf(this.maxCpuCount));
        sb.append(", memorySizeInGBs=").append(String.valueOf(this.memorySizeInGBs));
        sb.append(", maxMemoryInGBs=").append(String.valueOf(this.maxMemoryInGBs));
        sb.append(", dbNodeStorageSizeInGBs=").append(String.valueOf(this.dbNodeStorageSizeInGBs));
        sb.append(", maxDbNodeStorageInGBs=").append(String.valueOf(this.maxDbNodeStorageInGBs));
        sb.append(", dataStorageSizeInTBs=").append(String.valueOf(this.dataStorageSizeInTBs));
        sb.append(", maxDataStorageInTBs=").append(String.valueOf(this.maxDataStorageInTBs));
        sb.append(", rackSerialNumber=").append(String.valueOf(this.rackSerialNumber));
        sb.append(", storageCount=").append(String.valueOf(this.storageCount));
        sb.append(", additionalStorageCount=").append(String.valueOf(this.additionalStorageCount));
        sb.append(", activatedStorageCount=").append(String.valueOf(this.activatedStorageCount));
        sb.append(", computeCount=").append(String.valueOf(this.computeCount));
        sb.append(", isMultiRackDeployment=").append(String.valueOf(this.isMultiRackDeployment));
        sb.append(", multiRackConfigurationFile=").append(includeByteArrayContents ? Arrays.toString(this.multiRackConfigurationFile) : String.valueOf(this.multiRackConfigurationFile) + (this.multiRackConfigurationFile != null ? " (byte[" + this.multiRackConfigurationFile.length + "])" : ""));
        sb.append(", additionalComputeCount=").append(String.valueOf(this.additionalComputeCount));
        sb.append(", additionalComputeSystemModel=").append(String.valueOf((Object)this.additionalComputeSystemModel));
        sb.append(", cloudControlPlaneServer1=").append(String.valueOf(this.cloudControlPlaneServer1));
        sb.append(", cloudControlPlaneServer2=").append(String.valueOf(this.cloudControlPlaneServer2));
        sb.append(", netmask=").append(String.valueOf(this.netmask));
        sb.append(", gateway=").append(String.valueOf(this.gateway));
        sb.append(", adminNetworkCIDR=").append(String.valueOf(this.adminNetworkCIDR));
        sb.append(", infiniBandNetworkCIDR=").append(String.valueOf(this.infiniBandNetworkCIDR));
        sb.append(", corporateProxy=").append(String.valueOf(this.corporateProxy));
        sb.append(", dnsServer=").append(String.valueOf(this.dnsServer));
        sb.append(", ntpServer=").append(String.valueOf(this.ntpServer));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", csiNumber=").append(String.valueOf(this.csiNumber));
        sb.append(", contacts=").append(String.valueOf(this.contacts));
        sb.append(", maintenanceSLOStatus=").append(String.valueOf((Object)this.maintenanceSLOStatus));
        sb.append(", maintenanceWindow=").append(String.valueOf((Object)this.maintenanceWindow));
        sb.append(", storageServerVersion=").append(String.valueOf(this.storageServerVersion));
        sb.append(", dbServerVersion=").append(String.valueOf(this.dbServerVersion));
        sb.append(", monthlyDbServerVersion=").append(String.valueOf(this.monthlyDbServerVersion));
        sb.append(", lastMaintenanceRunId=").append(String.valueOf(this.lastMaintenanceRunId));
        sb.append(", nextMaintenanceRunId=").append(String.valueOf(this.nextMaintenanceRunId));
        sb.append(", isCpsOfflineReportEnabled=").append(String.valueOf(this.isCpsOfflineReportEnabled));
        sb.append(", networkBondingModeDetails=").append(String.valueOf((Object)this.networkBondingModeDetails));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", definedFileSystemConfigurations=").append(String.valueOf(this.definedFileSystemConfigurations));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", isSchedulingPolicyAssociated=").append(String.valueOf(this.isSchedulingPolicyAssociated));
        sb.append(", exascaleConfig=").append(String.valueOf((Object)this.exascaleConfig));
        sb.append(", databaseServerType=").append(String.valueOf(this.databaseServerType));
        sb.append(", storageServerType=").append(String.valueOf(this.storageServerType));
        sb.append(", computeModel=").append(String.valueOf((Object)this.computeModel));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExadataInfrastructureSummary)) {
            return false;
        }
        ExadataInfrastructureSummary other = (ExadataInfrastructureSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.shape, other.shape) && Objects.equals(this.timeZone, other.timeZone) && Objects.equals(this.cpusEnabled, other.cpusEnabled) && Objects.equals(this.maxCpuCount, other.maxCpuCount) && Objects.equals(this.memorySizeInGBs, other.memorySizeInGBs) && Objects.equals(this.maxMemoryInGBs, other.maxMemoryInGBs) && Objects.equals(this.dbNodeStorageSizeInGBs, other.dbNodeStorageSizeInGBs) && Objects.equals(this.maxDbNodeStorageInGBs, other.maxDbNodeStorageInGBs) && Objects.equals(this.dataStorageSizeInTBs, other.dataStorageSizeInTBs) && Objects.equals(this.maxDataStorageInTBs, other.maxDataStorageInTBs) && Objects.equals(this.rackSerialNumber, other.rackSerialNumber) && Objects.equals(this.storageCount, other.storageCount) && Objects.equals(this.additionalStorageCount, other.additionalStorageCount) && Objects.equals(this.activatedStorageCount, other.activatedStorageCount) && Objects.equals(this.computeCount, other.computeCount) && Objects.equals(this.isMultiRackDeployment, other.isMultiRackDeployment) && Arrays.equals(this.multiRackConfigurationFile, other.multiRackConfigurationFile) && Objects.equals(this.additionalComputeCount, other.additionalComputeCount) && Objects.equals((Object)this.additionalComputeSystemModel, (Object)other.additionalComputeSystemModel) && Objects.equals(this.cloudControlPlaneServer1, other.cloudControlPlaneServer1) && Objects.equals(this.cloudControlPlaneServer2, other.cloudControlPlaneServer2) && Objects.equals(this.netmask, other.netmask) && Objects.equals(this.gateway, other.gateway) && Objects.equals(this.adminNetworkCIDR, other.adminNetworkCIDR) && Objects.equals(this.infiniBandNetworkCIDR, other.infiniBandNetworkCIDR) && Objects.equals(this.corporateProxy, other.corporateProxy) && Objects.equals(this.dnsServer, other.dnsServer) && Objects.equals(this.ntpServer, other.ntpServer) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.csiNumber, other.csiNumber) && Objects.equals(this.contacts, other.contacts) && Objects.equals((Object)this.maintenanceSLOStatus, (Object)other.maintenanceSLOStatus) && Objects.equals((Object)this.maintenanceWindow, (Object)other.maintenanceWindow) && Objects.equals(this.storageServerVersion, other.storageServerVersion) && Objects.equals(this.dbServerVersion, other.dbServerVersion) && Objects.equals(this.monthlyDbServerVersion, other.monthlyDbServerVersion) && Objects.equals(this.lastMaintenanceRunId, other.lastMaintenanceRunId) && Objects.equals(this.nextMaintenanceRunId, other.nextMaintenanceRunId) && Objects.equals(this.isCpsOfflineReportEnabled, other.isCpsOfflineReportEnabled) && Objects.equals((Object)this.networkBondingModeDetails, (Object)other.networkBondingModeDetails) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.definedFileSystemConfigurations, other.definedFileSystemConfigurations) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.isSchedulingPolicyAssociated, other.isSchedulingPolicyAssociated) && Objects.equals((Object)this.exascaleConfig, (Object)other.exascaleConfig) && Objects.equals(this.databaseServerType, other.databaseServerType) && Objects.equals(this.storageServerType, other.storageServerType) && Objects.equals((Object)this.computeModel, (Object)other.computeModel) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.timeZone == null ? 43 : this.timeZone.hashCode());
        result = result * 59 + (this.cpusEnabled == null ? 43 : this.cpusEnabled.hashCode());
        result = result * 59 + (this.maxCpuCount == null ? 43 : this.maxCpuCount.hashCode());
        result = result * 59 + (this.memorySizeInGBs == null ? 43 : this.memorySizeInGBs.hashCode());
        result = result * 59 + (this.maxMemoryInGBs == null ? 43 : this.maxMemoryInGBs.hashCode());
        result = result * 59 + (this.dbNodeStorageSizeInGBs == null ? 43 : this.dbNodeStorageSizeInGBs.hashCode());
        result = result * 59 + (this.maxDbNodeStorageInGBs == null ? 43 : this.maxDbNodeStorageInGBs.hashCode());
        result = result * 59 + (this.dataStorageSizeInTBs == null ? 43 : this.dataStorageSizeInTBs.hashCode());
        result = result * 59 + (this.maxDataStorageInTBs == null ? 43 : this.maxDataStorageInTBs.hashCode());
        result = result * 59 + (this.rackSerialNumber == null ? 43 : this.rackSerialNumber.hashCode());
        result = result * 59 + (this.storageCount == null ? 43 : this.storageCount.hashCode());
        result = result * 59 + (this.additionalStorageCount == null ? 43 : this.additionalStorageCount.hashCode());
        result = result * 59 + (this.activatedStorageCount == null ? 43 : this.activatedStorageCount.hashCode());
        result = result * 59 + (this.computeCount == null ? 43 : this.computeCount.hashCode());
        result = result * 59 + (this.isMultiRackDeployment == null ? 43 : this.isMultiRackDeployment.hashCode());
        result = result * 59 + Arrays.hashCode(this.multiRackConfigurationFile);
        result = result * 59 + (this.additionalComputeCount == null ? 43 : this.additionalComputeCount.hashCode());
        result = result * 59 + (this.additionalComputeSystemModel == null ? 43 : this.additionalComputeSystemModel.hashCode());
        result = result * 59 + (this.cloudControlPlaneServer1 == null ? 43 : this.cloudControlPlaneServer1.hashCode());
        result = result * 59 + (this.cloudControlPlaneServer2 == null ? 43 : this.cloudControlPlaneServer2.hashCode());
        result = result * 59 + (this.netmask == null ? 43 : this.netmask.hashCode());
        result = result * 59 + (this.gateway == null ? 43 : this.gateway.hashCode());
        result = result * 59 + (this.adminNetworkCIDR == null ? 43 : this.adminNetworkCIDR.hashCode());
        result = result * 59 + (this.infiniBandNetworkCIDR == null ? 43 : this.infiniBandNetworkCIDR.hashCode());
        result = result * 59 + (this.corporateProxy == null ? 43 : this.corporateProxy.hashCode());
        result = result * 59 + (this.dnsServer == null ? 43 : this.dnsServer.hashCode());
        result = result * 59 + (this.ntpServer == null ? 43 : this.ntpServer.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.csiNumber == null ? 43 : this.csiNumber.hashCode());
        result = result * 59 + (this.contacts == null ? 43 : this.contacts.hashCode());
        result = result * 59 + (this.maintenanceSLOStatus == null ? 43 : this.maintenanceSLOStatus.hashCode());
        result = result * 59 + (this.maintenanceWindow == null ? 43 : this.maintenanceWindow.hashCode());
        result = result * 59 + (this.storageServerVersion == null ? 43 : this.storageServerVersion.hashCode());
        result = result * 59 + (this.dbServerVersion == null ? 43 : this.dbServerVersion.hashCode());
        result = result * 59 + (this.monthlyDbServerVersion == null ? 43 : this.monthlyDbServerVersion.hashCode());
        result = result * 59 + (this.lastMaintenanceRunId == null ? 43 : this.lastMaintenanceRunId.hashCode());
        result = result * 59 + (this.nextMaintenanceRunId == null ? 43 : this.nextMaintenanceRunId.hashCode());
        result = result * 59 + (this.isCpsOfflineReportEnabled == null ? 43 : this.isCpsOfflineReportEnabled.hashCode());
        result = result * 59 + (this.networkBondingModeDetails == null ? 43 : this.networkBondingModeDetails.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.definedFileSystemConfigurations == null ? 43 : this.definedFileSystemConfigurations.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.isSchedulingPolicyAssociated == null ? 43 : this.isSchedulingPolicyAssociated.hashCode());
        result = result * 59 + (this.exascaleConfig == null ? 43 : this.exascaleConfig.hashCode());
        result = result * 59 + (this.databaseServerType == null ? 43 : this.databaseServerType.hashCode());
        result = result * 59 + (this.storageServerType == null ? 43 : this.storageServerType.hashCode());
        result = result * 59 + (this.computeModel == null ? 43 : this.computeModel.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        RequiresActivation("REQUIRES_ACTIVATION"),
        Activating("ACTIVATING"),
        Active("ACTIVE"),
        ActivationFailed("ACTIVATION_FAILED"),
        Failed("FAILED"),
        Updating("UPDATING"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Disconnected("DISCONNECTED"),
        MaintenanceInProgress("MAINTENANCE_IN_PROGRESS"),
        WaitingForConnectivity("WAITING_FOR_CONNECTIVITY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AdditionalComputeSystemModel implements BmcEnum
    {
        X7("X7"),
        X8("X8"),
        X8M("X8M"),
        X9M("X9M"),
        X10M("X10M"),
        X11M("X11M"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AdditionalComputeSystemModel> map;

        private AdditionalComputeSystemModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AdditionalComputeSystemModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AdditionalComputeSystemModel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AdditionalComputeSystemModel.class);
            map = new HashMap<String, AdditionalComputeSystemModel>();
            for (AdditionalComputeSystemModel v : AdditionalComputeSystemModel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum MaintenanceSLOStatus implements BmcEnum
    {
        Ok("OK"),
        Degraded("DEGRADED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MaintenanceSLOStatus> map;

        private MaintenanceSLOStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MaintenanceSLOStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MaintenanceSLOStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MaintenanceSLOStatus.class);
            map = new HashMap<String, MaintenanceSLOStatus>();
            for (MaintenanceSLOStatus v : MaintenanceSLOStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ComputeModel implements BmcEnum
    {
        Ecpu("ECPU"),
        Ocpu("OCPU"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ComputeModel> map;

        private ComputeModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ComputeModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ComputeModel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ComputeModel.class);
            map = new HashMap<String, ComputeModel>();
            for (ComputeModel v : ComputeModel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="timeZone")
        private String timeZone;
        @JsonProperty(value="cpusEnabled")
        private Integer cpusEnabled;
        @JsonProperty(value="maxCpuCount")
        private Integer maxCpuCount;
        @JsonProperty(value="memorySizeInGBs")
        private Integer memorySizeInGBs;
        @JsonProperty(value="maxMemoryInGBs")
        private Integer maxMemoryInGBs;
        @JsonProperty(value="dbNodeStorageSizeInGBs")
        private Integer dbNodeStorageSizeInGBs;
        @JsonProperty(value="maxDbNodeStorageInGBs")
        private Integer maxDbNodeStorageInGBs;
        @JsonProperty(value="dataStorageSizeInTBs")
        private Double dataStorageSizeInTBs;
        @JsonProperty(value="maxDataStorageInTBs")
        private Double maxDataStorageInTBs;
        @JsonProperty(value="rackSerialNumber")
        private String rackSerialNumber;
        @JsonProperty(value="storageCount")
        private Integer storageCount;
        @JsonProperty(value="additionalStorageCount")
        private Integer additionalStorageCount;
        @JsonProperty(value="activatedStorageCount")
        private Integer activatedStorageCount;
        @JsonProperty(value="computeCount")
        private Integer computeCount;
        @JsonProperty(value="isMultiRackDeployment")
        private Boolean isMultiRackDeployment;
        @JsonProperty(value="multiRackConfigurationFile")
        private byte[] multiRackConfigurationFile;
        @JsonProperty(value="additionalComputeCount")
        private Integer additionalComputeCount;
        @JsonProperty(value="additionalComputeSystemModel")
        private AdditionalComputeSystemModel additionalComputeSystemModel;
        @JsonProperty(value="cloudControlPlaneServer1")
        private String cloudControlPlaneServer1;
        @JsonProperty(value="cloudControlPlaneServer2")
        private String cloudControlPlaneServer2;
        @JsonProperty(value="netmask")
        private String netmask;
        @JsonProperty(value="gateway")
        private String gateway;
        @JsonProperty(value="adminNetworkCIDR")
        private String adminNetworkCIDR;
        @JsonProperty(value="infiniBandNetworkCIDR")
        private String infiniBandNetworkCIDR;
        @JsonProperty(value="corporateProxy")
        private String corporateProxy;
        @JsonProperty(value="dnsServer")
        private List<String> dnsServer;
        @JsonProperty(value="ntpServer")
        private List<String> ntpServer;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="csiNumber")
        private String csiNumber;
        @JsonProperty(value="contacts")
        private List<ExadataInfrastructureContact> contacts;
        @JsonProperty(value="maintenanceSLOStatus")
        private MaintenanceSLOStatus maintenanceSLOStatus;
        @JsonProperty(value="maintenanceWindow")
        private MaintenanceWindow maintenanceWindow;
        @JsonProperty(value="storageServerVersion")
        private String storageServerVersion;
        @JsonProperty(value="dbServerVersion")
        private String dbServerVersion;
        @JsonProperty(value="monthlyDbServerVersion")
        private String monthlyDbServerVersion;
        @JsonProperty(value="lastMaintenanceRunId")
        private String lastMaintenanceRunId;
        @JsonProperty(value="nextMaintenanceRunId")
        private String nextMaintenanceRunId;
        @JsonProperty(value="isCpsOfflineReportEnabled")
        private Boolean isCpsOfflineReportEnabled;
        @JsonProperty(value="networkBondingModeDetails")
        private NetworkBondingModeDetails networkBondingModeDetails;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="definedFileSystemConfigurations")
        private List<DefinedFileSystemConfiguration> definedFileSystemConfigurations;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="isSchedulingPolicyAssociated")
        private Boolean isSchedulingPolicyAssociated;
        @JsonProperty(value="exascaleConfig")
        private ExascaleConfigDetails exascaleConfig;
        @JsonProperty(value="databaseServerType")
        private String databaseServerType;
        @JsonProperty(value="storageServerType")
        private String storageServerType;
        @JsonProperty(value="computeModel")
        private ComputeModel computeModel;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            this.__explicitlySet__.add("timeZone");
            return this;
        }

        public Builder cpusEnabled(Integer cpusEnabled) {
            this.cpusEnabled = cpusEnabled;
            this.__explicitlySet__.add("cpusEnabled");
            return this;
        }

        public Builder maxCpuCount(Integer maxCpuCount) {
            this.maxCpuCount = maxCpuCount;
            this.__explicitlySet__.add("maxCpuCount");
            return this;
        }

        public Builder memorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            this.__explicitlySet__.add("memorySizeInGBs");
            return this;
        }

        public Builder maxMemoryInGBs(Integer maxMemoryInGBs) {
            this.maxMemoryInGBs = maxMemoryInGBs;
            this.__explicitlySet__.add("maxMemoryInGBs");
            return this;
        }

        public Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
            this.__explicitlySet__.add("dbNodeStorageSizeInGBs");
            return this;
        }

        public Builder maxDbNodeStorageInGBs(Integer maxDbNodeStorageInGBs) {
            this.maxDbNodeStorageInGBs = maxDbNodeStorageInGBs;
            this.__explicitlySet__.add("maxDbNodeStorageInGBs");
            return this;
        }

        public Builder dataStorageSizeInTBs(Double dataStorageSizeInTBs) {
            this.dataStorageSizeInTBs = dataStorageSizeInTBs;
            this.__explicitlySet__.add("dataStorageSizeInTBs");
            return this;
        }

        public Builder maxDataStorageInTBs(Double maxDataStorageInTBs) {
            this.maxDataStorageInTBs = maxDataStorageInTBs;
            this.__explicitlySet__.add("maxDataStorageInTBs");
            return this;
        }

        public Builder rackSerialNumber(String rackSerialNumber) {
            this.rackSerialNumber = rackSerialNumber;
            this.__explicitlySet__.add("rackSerialNumber");
            return this;
        }

        public Builder storageCount(Integer storageCount) {
            this.storageCount = storageCount;
            this.__explicitlySet__.add("storageCount");
            return this;
        }

        public Builder additionalStorageCount(Integer additionalStorageCount) {
            this.additionalStorageCount = additionalStorageCount;
            this.__explicitlySet__.add("additionalStorageCount");
            return this;
        }

        public Builder activatedStorageCount(Integer activatedStorageCount) {
            this.activatedStorageCount = activatedStorageCount;
            this.__explicitlySet__.add("activatedStorageCount");
            return this;
        }

        public Builder computeCount(Integer computeCount) {
            this.computeCount = computeCount;
            this.__explicitlySet__.add("computeCount");
            return this;
        }

        public Builder isMultiRackDeployment(Boolean isMultiRackDeployment) {
            this.isMultiRackDeployment = isMultiRackDeployment;
            this.__explicitlySet__.add("isMultiRackDeployment");
            return this;
        }

        public Builder multiRackConfigurationFile(byte[] multiRackConfigurationFile) {
            this.multiRackConfigurationFile = multiRackConfigurationFile;
            this.__explicitlySet__.add("multiRackConfigurationFile");
            return this;
        }

        public Builder additionalComputeCount(Integer additionalComputeCount) {
            this.additionalComputeCount = additionalComputeCount;
            this.__explicitlySet__.add("additionalComputeCount");
            return this;
        }

        public Builder additionalComputeSystemModel(AdditionalComputeSystemModel additionalComputeSystemModel) {
            this.additionalComputeSystemModel = additionalComputeSystemModel;
            this.__explicitlySet__.add("additionalComputeSystemModel");
            return this;
        }

        public Builder cloudControlPlaneServer1(String cloudControlPlaneServer1) {
            this.cloudControlPlaneServer1 = cloudControlPlaneServer1;
            this.__explicitlySet__.add("cloudControlPlaneServer1");
            return this;
        }

        public Builder cloudControlPlaneServer2(String cloudControlPlaneServer2) {
            this.cloudControlPlaneServer2 = cloudControlPlaneServer2;
            this.__explicitlySet__.add("cloudControlPlaneServer2");
            return this;
        }

        public Builder netmask(String netmask) {
            this.netmask = netmask;
            this.__explicitlySet__.add("netmask");
            return this;
        }

        public Builder gateway(String gateway) {
            this.gateway = gateway;
            this.__explicitlySet__.add("gateway");
            return this;
        }

        public Builder adminNetworkCIDR(String adminNetworkCIDR) {
            this.adminNetworkCIDR = adminNetworkCIDR;
            this.__explicitlySet__.add("adminNetworkCIDR");
            return this;
        }

        public Builder infiniBandNetworkCIDR(String infiniBandNetworkCIDR) {
            this.infiniBandNetworkCIDR = infiniBandNetworkCIDR;
            this.__explicitlySet__.add("infiniBandNetworkCIDR");
            return this;
        }

        public Builder corporateProxy(String corporateProxy) {
            this.corporateProxy = corporateProxy;
            this.__explicitlySet__.add("corporateProxy");
            return this;
        }

        public Builder dnsServer(List<String> dnsServer) {
            this.dnsServer = dnsServer;
            this.__explicitlySet__.add("dnsServer");
            return this;
        }

        public Builder ntpServer(List<String> ntpServer) {
            this.ntpServer = ntpServer;
            this.__explicitlySet__.add("ntpServer");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder csiNumber(String csiNumber) {
            this.csiNumber = csiNumber;
            this.__explicitlySet__.add("csiNumber");
            return this;
        }

        public Builder contacts(List<ExadataInfrastructureContact> contacts) {
            this.contacts = contacts;
            this.__explicitlySet__.add("contacts");
            return this;
        }

        public Builder maintenanceSLOStatus(MaintenanceSLOStatus maintenanceSLOStatus) {
            this.maintenanceSLOStatus = maintenanceSLOStatus;
            this.__explicitlySet__.add("maintenanceSLOStatus");
            return this;
        }

        public Builder maintenanceWindow(MaintenanceWindow maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            this.__explicitlySet__.add("maintenanceWindow");
            return this;
        }

        public Builder storageServerVersion(String storageServerVersion) {
            this.storageServerVersion = storageServerVersion;
            this.__explicitlySet__.add("storageServerVersion");
            return this;
        }

        public Builder dbServerVersion(String dbServerVersion) {
            this.dbServerVersion = dbServerVersion;
            this.__explicitlySet__.add("dbServerVersion");
            return this;
        }

        public Builder monthlyDbServerVersion(String monthlyDbServerVersion) {
            this.monthlyDbServerVersion = monthlyDbServerVersion;
            this.__explicitlySet__.add("monthlyDbServerVersion");
            return this;
        }

        public Builder lastMaintenanceRunId(String lastMaintenanceRunId) {
            this.lastMaintenanceRunId = lastMaintenanceRunId;
            this.__explicitlySet__.add("lastMaintenanceRunId");
            return this;
        }

        public Builder nextMaintenanceRunId(String nextMaintenanceRunId) {
            this.nextMaintenanceRunId = nextMaintenanceRunId;
            this.__explicitlySet__.add("nextMaintenanceRunId");
            return this;
        }

        public Builder isCpsOfflineReportEnabled(Boolean isCpsOfflineReportEnabled) {
            this.isCpsOfflineReportEnabled = isCpsOfflineReportEnabled;
            this.__explicitlySet__.add("isCpsOfflineReportEnabled");
            return this;
        }

        public Builder networkBondingModeDetails(NetworkBondingModeDetails networkBondingModeDetails) {
            this.networkBondingModeDetails = networkBondingModeDetails;
            this.__explicitlySet__.add("networkBondingModeDetails");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder definedFileSystemConfigurations(List<DefinedFileSystemConfiguration> definedFileSystemConfigurations) {
            this.definedFileSystemConfigurations = definedFileSystemConfigurations;
            this.__explicitlySet__.add("definedFileSystemConfigurations");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder isSchedulingPolicyAssociated(Boolean isSchedulingPolicyAssociated) {
            this.isSchedulingPolicyAssociated = isSchedulingPolicyAssociated;
            this.__explicitlySet__.add("isSchedulingPolicyAssociated");
            return this;
        }

        public Builder exascaleConfig(ExascaleConfigDetails exascaleConfig) {
            this.exascaleConfig = exascaleConfig;
            this.__explicitlySet__.add("exascaleConfig");
            return this;
        }

        public Builder databaseServerType(String databaseServerType) {
            this.databaseServerType = databaseServerType;
            this.__explicitlySet__.add("databaseServerType");
            return this;
        }

        public Builder storageServerType(String storageServerType) {
            this.storageServerType = storageServerType;
            this.__explicitlySet__.add("storageServerType");
            return this;
        }

        public Builder computeModel(ComputeModel computeModel) {
            this.computeModel = computeModel;
            this.__explicitlySet__.add("computeModel");
            return this;
        }

        public ExadataInfrastructureSummary build() {
            ExadataInfrastructureSummary model = new ExadataInfrastructureSummary(this.id, this.compartmentId, this.lifecycleState, this.displayName, this.shape, this.timeZone, this.cpusEnabled, this.maxCpuCount, this.memorySizeInGBs, this.maxMemoryInGBs, this.dbNodeStorageSizeInGBs, this.maxDbNodeStorageInGBs, this.dataStorageSizeInTBs, this.maxDataStorageInTBs, this.rackSerialNumber, this.storageCount, this.additionalStorageCount, this.activatedStorageCount, this.computeCount, this.isMultiRackDeployment, this.multiRackConfigurationFile, this.additionalComputeCount, this.additionalComputeSystemModel, this.cloudControlPlaneServer1, this.cloudControlPlaneServer2, this.netmask, this.gateway, this.adminNetworkCIDR, this.infiniBandNetworkCIDR, this.corporateProxy, this.dnsServer, this.ntpServer, this.timeCreated, this.lifecycleDetails, this.csiNumber, this.contacts, this.maintenanceSLOStatus, this.maintenanceWindow, this.storageServerVersion, this.dbServerVersion, this.monthlyDbServerVersion, this.lastMaintenanceRunId, this.nextMaintenanceRunId, this.isCpsOfflineReportEnabled, this.networkBondingModeDetails, this.availabilityDomain, this.definedFileSystemConfigurations, this.freeformTags, this.definedTags, this.isSchedulingPolicyAssociated, this.exascaleConfig, this.databaseServerType, this.storageServerType, this.computeModel);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExadataInfrastructureSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("timeZone")) {
                this.timeZone(model.getTimeZone());
            }
            if (model.wasPropertyExplicitlySet("cpusEnabled")) {
                this.cpusEnabled(model.getCpusEnabled());
            }
            if (model.wasPropertyExplicitlySet("maxCpuCount")) {
                this.maxCpuCount(model.getMaxCpuCount());
            }
            if (model.wasPropertyExplicitlySet("memorySizeInGBs")) {
                this.memorySizeInGBs(model.getMemorySizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("maxMemoryInGBs")) {
                this.maxMemoryInGBs(model.getMaxMemoryInGBs());
            }
            if (model.wasPropertyExplicitlySet("dbNodeStorageSizeInGBs")) {
                this.dbNodeStorageSizeInGBs(model.getDbNodeStorageSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("maxDbNodeStorageInGBs")) {
                this.maxDbNodeStorageInGBs(model.getMaxDbNodeStorageInGBs());
            }
            if (model.wasPropertyExplicitlySet("dataStorageSizeInTBs")) {
                this.dataStorageSizeInTBs(model.getDataStorageSizeInTBs());
            }
            if (model.wasPropertyExplicitlySet("maxDataStorageInTBs")) {
                this.maxDataStorageInTBs(model.getMaxDataStorageInTBs());
            }
            if (model.wasPropertyExplicitlySet("rackSerialNumber")) {
                this.rackSerialNumber(model.getRackSerialNumber());
            }
            if (model.wasPropertyExplicitlySet("storageCount")) {
                this.storageCount(model.getStorageCount());
            }
            if (model.wasPropertyExplicitlySet("additionalStorageCount")) {
                this.additionalStorageCount(model.getAdditionalStorageCount());
            }
            if (model.wasPropertyExplicitlySet("activatedStorageCount")) {
                this.activatedStorageCount(model.getActivatedStorageCount());
            }
            if (model.wasPropertyExplicitlySet("computeCount")) {
                this.computeCount(model.getComputeCount());
            }
            if (model.wasPropertyExplicitlySet("isMultiRackDeployment")) {
                this.isMultiRackDeployment(model.getIsMultiRackDeployment());
            }
            if (model.wasPropertyExplicitlySet("multiRackConfigurationFile")) {
                this.multiRackConfigurationFile(model.getMultiRackConfigurationFile());
            }
            if (model.wasPropertyExplicitlySet("additionalComputeCount")) {
                this.additionalComputeCount(model.getAdditionalComputeCount());
            }
            if (model.wasPropertyExplicitlySet("additionalComputeSystemModel")) {
                this.additionalComputeSystemModel(model.getAdditionalComputeSystemModel());
            }
            if (model.wasPropertyExplicitlySet("cloudControlPlaneServer1")) {
                this.cloudControlPlaneServer1(model.getCloudControlPlaneServer1());
            }
            if (model.wasPropertyExplicitlySet("cloudControlPlaneServer2")) {
                this.cloudControlPlaneServer2(model.getCloudControlPlaneServer2());
            }
            if (model.wasPropertyExplicitlySet("netmask")) {
                this.netmask(model.getNetmask());
            }
            if (model.wasPropertyExplicitlySet("gateway")) {
                this.gateway(model.getGateway());
            }
            if (model.wasPropertyExplicitlySet("adminNetworkCIDR")) {
                this.adminNetworkCIDR(model.getAdminNetworkCIDR());
            }
            if (model.wasPropertyExplicitlySet("infiniBandNetworkCIDR")) {
                this.infiniBandNetworkCIDR(model.getInfiniBandNetworkCIDR());
            }
            if (model.wasPropertyExplicitlySet("corporateProxy")) {
                this.corporateProxy(model.getCorporateProxy());
            }
            if (model.wasPropertyExplicitlySet("dnsServer")) {
                this.dnsServer(model.getDnsServer());
            }
            if (model.wasPropertyExplicitlySet("ntpServer")) {
                this.ntpServer(model.getNtpServer());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("csiNumber")) {
                this.csiNumber(model.getCsiNumber());
            }
            if (model.wasPropertyExplicitlySet("contacts")) {
                this.contacts(model.getContacts());
            }
            if (model.wasPropertyExplicitlySet("maintenanceSLOStatus")) {
                this.maintenanceSLOStatus(model.getMaintenanceSLOStatus());
            }
            if (model.wasPropertyExplicitlySet("maintenanceWindow")) {
                this.maintenanceWindow(model.getMaintenanceWindow());
            }
            if (model.wasPropertyExplicitlySet("storageServerVersion")) {
                this.storageServerVersion(model.getStorageServerVersion());
            }
            if (model.wasPropertyExplicitlySet("dbServerVersion")) {
                this.dbServerVersion(model.getDbServerVersion());
            }
            if (model.wasPropertyExplicitlySet("monthlyDbServerVersion")) {
                this.monthlyDbServerVersion(model.getMonthlyDbServerVersion());
            }
            if (model.wasPropertyExplicitlySet("lastMaintenanceRunId")) {
                this.lastMaintenanceRunId(model.getLastMaintenanceRunId());
            }
            if (model.wasPropertyExplicitlySet("nextMaintenanceRunId")) {
                this.nextMaintenanceRunId(model.getNextMaintenanceRunId());
            }
            if (model.wasPropertyExplicitlySet("isCpsOfflineReportEnabled")) {
                this.isCpsOfflineReportEnabled(model.getIsCpsOfflineReportEnabled());
            }
            if (model.wasPropertyExplicitlySet("networkBondingModeDetails")) {
                this.networkBondingModeDetails(model.getNetworkBondingModeDetails());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("definedFileSystemConfigurations")) {
                this.definedFileSystemConfigurations(model.getDefinedFileSystemConfigurations());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("isSchedulingPolicyAssociated")) {
                this.isSchedulingPolicyAssociated(model.getIsSchedulingPolicyAssociated());
            }
            if (model.wasPropertyExplicitlySet("exascaleConfig")) {
                this.exascaleConfig(model.getExascaleConfig());
            }
            if (model.wasPropertyExplicitlySet("databaseServerType")) {
                this.databaseServerType(model.getDatabaseServerType());
            }
            if (model.wasPropertyExplicitlySet("storageServerType")) {
                this.storageServerType(model.getStorageServerType());
            }
            if (model.wasPropertyExplicitlySet("computeModel")) {
                this.computeModel(model.getComputeModel());
            }
            return this;
        }
    }
}

