/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DataGuardGroupMember
extends ExplicitlySetBmcModel {
    @JsonProperty(value="dbSystemId")
    private final String dbSystemId;
    @JsonProperty(value="databaseId")
    private final String databaseId;
    @JsonProperty(value="role")
    private final Role role;
    @JsonProperty(value="applyLag")
    private final String applyLag;
    @JsonProperty(value="applyRate")
    private final String applyRate;
    @JsonProperty(value="transportLag")
    private final String transportLag;
    @JsonProperty(value="transportLagRefresh")
    private final String transportLagRefresh;
    @JsonProperty(value="transportType")
    private final TransportType transportType;
    @JsonProperty(value="isActiveDataGuardEnabled")
    private final Boolean isActiveDataGuardEnabled;

    @Deprecated
    @ConstructorProperties(value={"dbSystemId", "databaseId", "role", "applyLag", "applyRate", "transportLag", "transportLagRefresh", "transportType", "isActiveDataGuardEnabled"})
    public DataGuardGroupMember(String dbSystemId, String databaseId, Role role, String applyLag, String applyRate, String transportLag, String transportLagRefresh, TransportType transportType, Boolean isActiveDataGuardEnabled) {
        this.dbSystemId = dbSystemId;
        this.databaseId = databaseId;
        this.role = role;
        this.applyLag = applyLag;
        this.applyRate = applyRate;
        this.transportLag = transportLag;
        this.transportLagRefresh = transportLagRefresh;
        this.transportType = transportType;
        this.isActiveDataGuardEnabled = isActiveDataGuardEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public Role getRole() {
        return this.role;
    }

    public String getApplyLag() {
        return this.applyLag;
    }

    public String getApplyRate() {
        return this.applyRate;
    }

    public String getTransportLag() {
        return this.transportLag;
    }

    public String getTransportLagRefresh() {
        return this.transportLagRefresh;
    }

    public TransportType getTransportType() {
        return this.transportType;
    }

    public Boolean getIsActiveDataGuardEnabled() {
        return this.isActiveDataGuardEnabled;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataGuardGroupMember(");
        sb.append("super=").append(super.toString());
        sb.append("dbSystemId=").append(String.valueOf(this.dbSystemId));
        sb.append(", databaseId=").append(String.valueOf(this.databaseId));
        sb.append(", role=").append(String.valueOf((Object)this.role));
        sb.append(", applyLag=").append(String.valueOf(this.applyLag));
        sb.append(", applyRate=").append(String.valueOf(this.applyRate));
        sb.append(", transportLag=").append(String.valueOf(this.transportLag));
        sb.append(", transportLagRefresh=").append(String.valueOf(this.transportLagRefresh));
        sb.append(", transportType=").append(String.valueOf((Object)this.transportType));
        sb.append(", isActiveDataGuardEnabled=").append(String.valueOf(this.isActiveDataGuardEnabled));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataGuardGroupMember)) {
            return false;
        }
        DataGuardGroupMember other = (DataGuardGroupMember)((Object)o);
        return Objects.equals(this.dbSystemId, other.dbSystemId) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals((Object)this.role, (Object)other.role) && Objects.equals(this.applyLag, other.applyLag) && Objects.equals(this.applyRate, other.applyRate) && Objects.equals(this.transportLag, other.transportLag) && Objects.equals(this.transportLagRefresh, other.transportLagRefresh) && Objects.equals((Object)this.transportType, (Object)other.transportType) && Objects.equals(this.isActiveDataGuardEnabled, other.isActiveDataGuardEnabled) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.dbSystemId == null ? 43 : this.dbSystemId.hashCode());
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.role == null ? 43 : this.role.hashCode());
        result = result * 59 + (this.applyLag == null ? 43 : this.applyLag.hashCode());
        result = result * 59 + (this.applyRate == null ? 43 : this.applyRate.hashCode());
        result = result * 59 + (this.transportLag == null ? 43 : this.transportLag.hashCode());
        result = result * 59 + (this.transportLagRefresh == null ? 43 : this.transportLagRefresh.hashCode());
        result = result * 59 + (this.transportType == null ? 43 : this.transportType.hashCode());
        result = result * 59 + (this.isActiveDataGuardEnabled == null ? 43 : this.isActiveDataGuardEnabled.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Role implements BmcEnum
    {
        Primary("PRIMARY"),
        Standby("STANDBY"),
        DisabledStandby("DISABLED_STANDBY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Role> map;

        private Role(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Role create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Role', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Role.class);
            map = new HashMap<String, Role>();
            for (Role v : Role.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum TransportType implements BmcEnum
    {
        Sync("SYNC"),
        Async("ASYNC"),
        Fastsync("FASTSYNC"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TransportType> map;

        private TransportType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TransportType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TransportType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TransportType.class);
            map = new HashMap<String, TransportType>();
            for (TransportType v : TransportType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="dbSystemId")
        private String dbSystemId;
        @JsonProperty(value="databaseId")
        private String databaseId;
        @JsonProperty(value="role")
        private Role role;
        @JsonProperty(value="applyLag")
        private String applyLag;
        @JsonProperty(value="applyRate")
        private String applyRate;
        @JsonProperty(value="transportLag")
        private String transportLag;
        @JsonProperty(value="transportLagRefresh")
        private String transportLagRefresh;
        @JsonProperty(value="transportType")
        private TransportType transportType;
        @JsonProperty(value="isActiveDataGuardEnabled")
        private Boolean isActiveDataGuardEnabled;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            this.__explicitlySet__.add("dbSystemId");
            return this;
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            this.__explicitlySet__.add("databaseId");
            return this;
        }

        public Builder role(Role role) {
            this.role = role;
            this.__explicitlySet__.add("role");
            return this;
        }

        public Builder applyLag(String applyLag) {
            this.applyLag = applyLag;
            this.__explicitlySet__.add("applyLag");
            return this;
        }

        public Builder applyRate(String applyRate) {
            this.applyRate = applyRate;
            this.__explicitlySet__.add("applyRate");
            return this;
        }

        public Builder transportLag(String transportLag) {
            this.transportLag = transportLag;
            this.__explicitlySet__.add("transportLag");
            return this;
        }

        public Builder transportLagRefresh(String transportLagRefresh) {
            this.transportLagRefresh = transportLagRefresh;
            this.__explicitlySet__.add("transportLagRefresh");
            return this;
        }

        public Builder transportType(TransportType transportType) {
            this.transportType = transportType;
            this.__explicitlySet__.add("transportType");
            return this;
        }

        public Builder isActiveDataGuardEnabled(Boolean isActiveDataGuardEnabled) {
            this.isActiveDataGuardEnabled = isActiveDataGuardEnabled;
            this.__explicitlySet__.add("isActiveDataGuardEnabled");
            return this;
        }

        public DataGuardGroupMember build() {
            DataGuardGroupMember model = new DataGuardGroupMember(this.dbSystemId, this.databaseId, this.role, this.applyLag, this.applyRate, this.transportLag, this.transportLagRefresh, this.transportType, this.isActiveDataGuardEnabled);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DataGuardGroupMember model) {
            if (model.wasPropertyExplicitlySet("dbSystemId")) {
                this.dbSystemId(model.getDbSystemId());
            }
            if (model.wasPropertyExplicitlySet("databaseId")) {
                this.databaseId(model.getDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("role")) {
                this.role(model.getRole());
            }
            if (model.wasPropertyExplicitlySet("applyLag")) {
                this.applyLag(model.getApplyLag());
            }
            if (model.wasPropertyExplicitlySet("applyRate")) {
                this.applyRate(model.getApplyRate());
            }
            if (model.wasPropertyExplicitlySet("transportLag")) {
                this.transportLag(model.getTransportLag());
            }
            if (model.wasPropertyExplicitlySet("transportLagRefresh")) {
                this.transportLagRefresh(model.getTransportLagRefresh());
            }
            if (model.wasPropertyExplicitlySet("transportType")) {
                this.transportType(model.getTransportType());
            }
            if (model.wasPropertyExplicitlySet("isActiveDataGuardEnabled")) {
                this.isActiveDataGuardEnabled(model.getIsActiveDataGuardEnabled());
            }
            return this;
        }
    }
}

