/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DataGuardAssociationSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="databaseId")
    private final String databaseId;
    @JsonProperty(value="role")
    private final Role role;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="peerDbSystemId")
    private final String peerDbSystemId;
    @JsonProperty(value="peerDbHomeId")
    private final String peerDbHomeId;
    @JsonProperty(value="peerDatabaseId")
    private final String peerDatabaseId;
    @JsonProperty(value="peerDataGuardAssociationId")
    private final String peerDataGuardAssociationId;
    @JsonProperty(value="peerRole")
    private final PeerRole peerRole;
    @JsonProperty(value="applyLag")
    private final String applyLag;
    @JsonProperty(value="applyRate")
    private final String applyRate;
    @JsonProperty(value="protectionMode")
    private final ProtectionMode protectionMode;
    @JsonProperty(value="transportType")
    private final TransportType transportType;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="isActiveDataGuardEnabled")
    private final Boolean isActiveDataGuardEnabled;

    @Deprecated
    @ConstructorProperties(value={"id", "databaseId", "role", "lifecycleState", "lifecycleDetails", "peerDbSystemId", "peerDbHomeId", "peerDatabaseId", "peerDataGuardAssociationId", "peerRole", "applyLag", "applyRate", "protectionMode", "transportType", "timeCreated", "isActiveDataGuardEnabled"})
    public DataGuardAssociationSummary(String id, String databaseId, Role role, LifecycleState lifecycleState, String lifecycleDetails, String peerDbSystemId, String peerDbHomeId, String peerDatabaseId, String peerDataGuardAssociationId, PeerRole peerRole, String applyLag, String applyRate, ProtectionMode protectionMode, TransportType transportType, Date timeCreated, Boolean isActiveDataGuardEnabled) {
        this.id = id;
        this.databaseId = databaseId;
        this.role = role;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.peerDbSystemId = peerDbSystemId;
        this.peerDbHomeId = peerDbHomeId;
        this.peerDatabaseId = peerDatabaseId;
        this.peerDataGuardAssociationId = peerDataGuardAssociationId;
        this.peerRole = peerRole;
        this.applyLag = applyLag;
        this.applyRate = applyRate;
        this.protectionMode = protectionMode;
        this.transportType = transportType;
        this.timeCreated = timeCreated;
        this.isActiveDataGuardEnabled = isActiveDataGuardEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public Role getRole() {
        return this.role;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String getPeerDbSystemId() {
        return this.peerDbSystemId;
    }

    public String getPeerDbHomeId() {
        return this.peerDbHomeId;
    }

    public String getPeerDatabaseId() {
        return this.peerDatabaseId;
    }

    public String getPeerDataGuardAssociationId() {
        return this.peerDataGuardAssociationId;
    }

    public PeerRole getPeerRole() {
        return this.peerRole;
    }

    public String getApplyLag() {
        return this.applyLag;
    }

    public String getApplyRate() {
        return this.applyRate;
    }

    public ProtectionMode getProtectionMode() {
        return this.protectionMode;
    }

    public TransportType getTransportType() {
        return this.transportType;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Boolean getIsActiveDataGuardEnabled() {
        return this.isActiveDataGuardEnabled;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataGuardAssociationSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", databaseId=").append(String.valueOf(this.databaseId));
        sb.append(", role=").append(String.valueOf((Object)this.role));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", peerDbSystemId=").append(String.valueOf(this.peerDbSystemId));
        sb.append(", peerDbHomeId=").append(String.valueOf(this.peerDbHomeId));
        sb.append(", peerDatabaseId=").append(String.valueOf(this.peerDatabaseId));
        sb.append(", peerDataGuardAssociationId=").append(String.valueOf(this.peerDataGuardAssociationId));
        sb.append(", peerRole=").append(String.valueOf((Object)this.peerRole));
        sb.append(", applyLag=").append(String.valueOf(this.applyLag));
        sb.append(", applyRate=").append(String.valueOf(this.applyRate));
        sb.append(", protectionMode=").append(String.valueOf((Object)this.protectionMode));
        sb.append(", transportType=").append(String.valueOf((Object)this.transportType));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", isActiveDataGuardEnabled=").append(String.valueOf(this.isActiveDataGuardEnabled));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataGuardAssociationSummary)) {
            return false;
        }
        DataGuardAssociationSummary other = (DataGuardAssociationSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals((Object)this.role, (Object)other.role) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.peerDbSystemId, other.peerDbSystemId) && Objects.equals(this.peerDbHomeId, other.peerDbHomeId) && Objects.equals(this.peerDatabaseId, other.peerDatabaseId) && Objects.equals(this.peerDataGuardAssociationId, other.peerDataGuardAssociationId) && Objects.equals((Object)this.peerRole, (Object)other.peerRole) && Objects.equals(this.applyLag, other.applyLag) && Objects.equals(this.applyRate, other.applyRate) && Objects.equals((Object)this.protectionMode, (Object)other.protectionMode) && Objects.equals((Object)this.transportType, (Object)other.transportType) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.isActiveDataGuardEnabled, other.isActiveDataGuardEnabled) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.role == null ? 43 : this.role.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.peerDbSystemId == null ? 43 : this.peerDbSystemId.hashCode());
        result = result * 59 + (this.peerDbHomeId == null ? 43 : this.peerDbHomeId.hashCode());
        result = result * 59 + (this.peerDatabaseId == null ? 43 : this.peerDatabaseId.hashCode());
        result = result * 59 + (this.peerDataGuardAssociationId == null ? 43 : this.peerDataGuardAssociationId.hashCode());
        result = result * 59 + (this.peerRole == null ? 43 : this.peerRole.hashCode());
        result = result * 59 + (this.applyLag == null ? 43 : this.applyLag.hashCode());
        result = result * 59 + (this.applyRate == null ? 43 : this.applyRate.hashCode());
        result = result * 59 + (this.protectionMode == null ? 43 : this.protectionMode.hashCode());
        result = result * 59 + (this.transportType == null ? 43 : this.transportType.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.isActiveDataGuardEnabled == null ? 43 : this.isActiveDataGuardEnabled.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Role implements BmcEnum
    {
        Primary("PRIMARY"),
        Standby("STANDBY"),
        DisabledStandby("DISABLED_STANDBY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Role> map;

        private Role(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Role create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Role', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Role.class);
            map = new HashMap<String, Role>();
            for (Role v : Role.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Provisioning("PROVISIONING"),
        Available("AVAILABLE"),
        Updating("UPDATING"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Failed("FAILED"),
        Upgrading("UPGRADING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PeerRole implements BmcEnum
    {
        Primary("PRIMARY"),
        Standby("STANDBY"),
        DisabledStandby("DISABLED_STANDBY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PeerRole> map;

        private PeerRole(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PeerRole create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PeerRole', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PeerRole.class);
            map = new HashMap<String, PeerRole>();
            for (PeerRole v : PeerRole.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ProtectionMode implements BmcEnum
    {
        MaximumAvailability("MAXIMUM_AVAILABILITY"),
        MaximumPerformance("MAXIMUM_PERFORMANCE"),
        MaximumProtection("MAXIMUM_PROTECTION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ProtectionMode> map;

        private ProtectionMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ProtectionMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ProtectionMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ProtectionMode.class);
            map = new HashMap<String, ProtectionMode>();
            for (ProtectionMode v : ProtectionMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum TransportType implements BmcEnum
    {
        Sync("SYNC"),
        Async("ASYNC"),
        Fastsync("FASTSYNC"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TransportType> map;

        private TransportType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TransportType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TransportType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TransportType.class);
            map = new HashMap<String, TransportType>();
            for (TransportType v : TransportType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="databaseId")
        private String databaseId;
        @JsonProperty(value="role")
        private Role role;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="peerDbSystemId")
        private String peerDbSystemId;
        @JsonProperty(value="peerDbHomeId")
        private String peerDbHomeId;
        @JsonProperty(value="peerDatabaseId")
        private String peerDatabaseId;
        @JsonProperty(value="peerDataGuardAssociationId")
        private String peerDataGuardAssociationId;
        @JsonProperty(value="peerRole")
        private PeerRole peerRole;
        @JsonProperty(value="applyLag")
        private String applyLag;
        @JsonProperty(value="applyRate")
        private String applyRate;
        @JsonProperty(value="protectionMode")
        private ProtectionMode protectionMode;
        @JsonProperty(value="transportType")
        private TransportType transportType;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="isActiveDataGuardEnabled")
        private Boolean isActiveDataGuardEnabled;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            this.__explicitlySet__.add("databaseId");
            return this;
        }

        public Builder role(Role role) {
            this.role = role;
            this.__explicitlySet__.add("role");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder peerDbSystemId(String peerDbSystemId) {
            this.peerDbSystemId = peerDbSystemId;
            this.__explicitlySet__.add("peerDbSystemId");
            return this;
        }

        public Builder peerDbHomeId(String peerDbHomeId) {
            this.peerDbHomeId = peerDbHomeId;
            this.__explicitlySet__.add("peerDbHomeId");
            return this;
        }

        public Builder peerDatabaseId(String peerDatabaseId) {
            this.peerDatabaseId = peerDatabaseId;
            this.__explicitlySet__.add("peerDatabaseId");
            return this;
        }

        public Builder peerDataGuardAssociationId(String peerDataGuardAssociationId) {
            this.peerDataGuardAssociationId = peerDataGuardAssociationId;
            this.__explicitlySet__.add("peerDataGuardAssociationId");
            return this;
        }

        public Builder peerRole(PeerRole peerRole) {
            this.peerRole = peerRole;
            this.__explicitlySet__.add("peerRole");
            return this;
        }

        public Builder applyLag(String applyLag) {
            this.applyLag = applyLag;
            this.__explicitlySet__.add("applyLag");
            return this;
        }

        public Builder applyRate(String applyRate) {
            this.applyRate = applyRate;
            this.__explicitlySet__.add("applyRate");
            return this;
        }

        public Builder protectionMode(ProtectionMode protectionMode) {
            this.protectionMode = protectionMode;
            this.__explicitlySet__.add("protectionMode");
            return this;
        }

        public Builder transportType(TransportType transportType) {
            this.transportType = transportType;
            this.__explicitlySet__.add("transportType");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder isActiveDataGuardEnabled(Boolean isActiveDataGuardEnabled) {
            this.isActiveDataGuardEnabled = isActiveDataGuardEnabled;
            this.__explicitlySet__.add("isActiveDataGuardEnabled");
            return this;
        }

        public DataGuardAssociationSummary build() {
            DataGuardAssociationSummary model = new DataGuardAssociationSummary(this.id, this.databaseId, this.role, this.lifecycleState, this.lifecycleDetails, this.peerDbSystemId, this.peerDbHomeId, this.peerDatabaseId, this.peerDataGuardAssociationId, this.peerRole, this.applyLag, this.applyRate, this.protectionMode, this.transportType, this.timeCreated, this.isActiveDataGuardEnabled);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DataGuardAssociationSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("databaseId")) {
                this.databaseId(model.getDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("role")) {
                this.role(model.getRole());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("peerDbSystemId")) {
                this.peerDbSystemId(model.getPeerDbSystemId());
            }
            if (model.wasPropertyExplicitlySet("peerDbHomeId")) {
                this.peerDbHomeId(model.getPeerDbHomeId());
            }
            if (model.wasPropertyExplicitlySet("peerDatabaseId")) {
                this.peerDatabaseId(model.getPeerDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("peerDataGuardAssociationId")) {
                this.peerDataGuardAssociationId(model.getPeerDataGuardAssociationId());
            }
            if (model.wasPropertyExplicitlySet("peerRole")) {
                this.peerRole(model.getPeerRole());
            }
            if (model.wasPropertyExplicitlySet("applyLag")) {
                this.applyLag(model.getApplyLag());
            }
            if (model.wasPropertyExplicitlySet("applyRate")) {
                this.applyRate(model.getApplyRate());
            }
            if (model.wasPropertyExplicitlySet("protectionMode")) {
                this.protectionMode(model.getProtectionMode());
            }
            if (model.wasPropertyExplicitlySet("transportType")) {
                this.transportType(model.getTransportType());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("isActiveDataGuardEnabled")) {
                this.isActiveDataGuardEnabled(model.getIsActiveDataGuardEnabled());
            }
            return this;
        }
    }
}

