/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ChangeDataguardRoleDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="role")
    private final Role role;
    @JsonProperty(value="autonomousContainerDatabaseDataguardAssociationId")
    private final String autonomousContainerDatabaseDataguardAssociationId;
    @JsonProperty(value="connectionStringsType")
    private final ConnectionStringsType connectionStringsType;

    @Deprecated
    @ConstructorProperties(value={"role", "autonomousContainerDatabaseDataguardAssociationId", "connectionStringsType"})
    public ChangeDataguardRoleDetails(Role role, String autonomousContainerDatabaseDataguardAssociationId, ConnectionStringsType connectionStringsType) {
        this.role = role;
        this.autonomousContainerDatabaseDataguardAssociationId = autonomousContainerDatabaseDataguardAssociationId;
        this.connectionStringsType = connectionStringsType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Role getRole() {
        return this.role;
    }

    public String getAutonomousContainerDatabaseDataguardAssociationId() {
        return this.autonomousContainerDatabaseDataguardAssociationId;
    }

    public ConnectionStringsType getConnectionStringsType() {
        return this.connectionStringsType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ChangeDataguardRoleDetails(");
        sb.append("super=").append(super.toString());
        sb.append("role=").append(String.valueOf((Object)this.role));
        sb.append(", autonomousContainerDatabaseDataguardAssociationId=").append(String.valueOf(this.autonomousContainerDatabaseDataguardAssociationId));
        sb.append(", connectionStringsType=").append(String.valueOf((Object)this.connectionStringsType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeDataguardRoleDetails)) {
            return false;
        }
        ChangeDataguardRoleDetails other = (ChangeDataguardRoleDetails)((Object)o);
        return Objects.equals((Object)this.role, (Object)other.role) && Objects.equals(this.autonomousContainerDatabaseDataguardAssociationId, other.autonomousContainerDatabaseDataguardAssociationId) && Objects.equals((Object)this.connectionStringsType, (Object)other.connectionStringsType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.role == null ? 43 : this.role.hashCode());
        result = result * 59 + (this.autonomousContainerDatabaseDataguardAssociationId == null ? 43 : this.autonomousContainerDatabaseDataguardAssociationId.hashCode());
        result = result * 59 + (this.connectionStringsType == null ? 43 : this.connectionStringsType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Role implements BmcEnum
    {
        Primary("PRIMARY"),
        Standby("STANDBY"),
        DisabledStandby("DISABLED_STANDBY"),
        BackupCopy("BACKUP_COPY"),
        SnapshotStandby("SNAPSHOT_STANDBY");

        private final String value;
        private static Map<String, Role> map;

        private Role(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Role create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Role: " + key);
        }

        static {
            map = new HashMap<String, Role>();
            for (Role v : Role.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ConnectionStringsType implements BmcEnum
    {
        SnapshotServices("SNAPSHOT_SERVICES"),
        PrimaryServices("PRIMARY_SERVICES");

        private final String value;
        private static Map<String, ConnectionStringsType> map;

        private ConnectionStringsType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ConnectionStringsType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ConnectionStringsType: " + key);
        }

        static {
            map = new HashMap<String, ConnectionStringsType>();
            for (ConnectionStringsType v : ConnectionStringsType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="role")
        private Role role;
        @JsonProperty(value="autonomousContainerDatabaseDataguardAssociationId")
        private String autonomousContainerDatabaseDataguardAssociationId;
        @JsonProperty(value="connectionStringsType")
        private ConnectionStringsType connectionStringsType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder role(Role role) {
            this.role = role;
            this.__explicitlySet__.add("role");
            return this;
        }

        public Builder autonomousContainerDatabaseDataguardAssociationId(String autonomousContainerDatabaseDataguardAssociationId) {
            this.autonomousContainerDatabaseDataguardAssociationId = autonomousContainerDatabaseDataguardAssociationId;
            this.__explicitlySet__.add("autonomousContainerDatabaseDataguardAssociationId");
            return this;
        }

        public Builder connectionStringsType(ConnectionStringsType connectionStringsType) {
            this.connectionStringsType = connectionStringsType;
            this.__explicitlySet__.add("connectionStringsType");
            return this;
        }

        public ChangeDataguardRoleDetails build() {
            ChangeDataguardRoleDetails model = new ChangeDataguardRoleDetails(this.role, this.autonomousContainerDatabaseDataguardAssociationId, this.connectionStringsType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ChangeDataguardRoleDetails model) {
            if (model.wasPropertyExplicitlySet("role")) {
                this.role(model.getRole());
            }
            if (model.wasPropertyExplicitlySet("autonomousContainerDatabaseDataguardAssociationId")) {
                this.autonomousContainerDatabaseDataguardAssociationId(model.getAutonomousContainerDatabaseDataguardAssociationId());
            }
            if (model.wasPropertyExplicitlySet("connectionStringsType")) {
                this.connectionStringsType(model.getConnectionStringsType());
            }
            return this;
        }
    }
}

