/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.AutonomousDatabaseEncryptionKeyDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AutonomousDatabaseEncryptionKeyHistoryEntry
extends ExplicitlySetBmcModel {
    @JsonProperty(value="encryptionKey")
    private final AutonomousDatabaseEncryptionKeyDetails encryptionKey;
    @JsonProperty(value="timeActivated")
    private final Date timeActivated;

    @Deprecated
    @ConstructorProperties(value={"encryptionKey", "timeActivated"})
    public AutonomousDatabaseEncryptionKeyHistoryEntry(AutonomousDatabaseEncryptionKeyDetails encryptionKey, Date timeActivated) {
        this.encryptionKey = encryptionKey;
        this.timeActivated = timeActivated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public AutonomousDatabaseEncryptionKeyDetails getEncryptionKey() {
        return this.encryptionKey;
    }

    public Date getTimeActivated() {
        return this.timeActivated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutonomousDatabaseEncryptionKeyHistoryEntry(");
        sb.append("super=").append(super.toString());
        sb.append("encryptionKey=").append(String.valueOf((Object)this.encryptionKey));
        sb.append(", timeActivated=").append(String.valueOf(this.timeActivated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutonomousDatabaseEncryptionKeyHistoryEntry)) {
            return false;
        }
        AutonomousDatabaseEncryptionKeyHistoryEntry other = (AutonomousDatabaseEncryptionKeyHistoryEntry)((Object)o);
        return Objects.equals((Object)this.encryptionKey, (Object)other.encryptionKey) && Objects.equals(this.timeActivated, other.timeActivated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.encryptionKey == null ? 43 : this.encryptionKey.hashCode());
        result = result * 59 + (this.timeActivated == null ? 43 : this.timeActivated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="encryptionKey")
        private AutonomousDatabaseEncryptionKeyDetails encryptionKey;
        @JsonProperty(value="timeActivated")
        private Date timeActivated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder encryptionKey(AutonomousDatabaseEncryptionKeyDetails encryptionKey) {
            this.encryptionKey = encryptionKey;
            this.__explicitlySet__.add("encryptionKey");
            return this;
        }

        public Builder timeActivated(Date timeActivated) {
            this.timeActivated = timeActivated;
            this.__explicitlySet__.add("timeActivated");
            return this;
        }

        public AutonomousDatabaseEncryptionKeyHistoryEntry build() {
            AutonomousDatabaseEncryptionKeyHistoryEntry model = new AutonomousDatabaseEncryptionKeyHistoryEntry(this.encryptionKey, this.timeActivated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AutonomousDatabaseEncryptionKeyHistoryEntry model) {
            if (model.wasPropertyExplicitlySet("encryptionKey")) {
                this.encryptionKey(model.getEncryptionKey());
            }
            if (model.wasPropertyExplicitlySet("timeActivated")) {
                this.timeActivated(model.getTimeActivated());
            }
            return this;
        }
    }
}

