/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.blockchain.completers;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.dbtools.app.CompletionItem;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.completer.SemanticCompleter;
import oracle.dbtools.sqlcl.commands.blockchain.BICException;
import oracle.dbtools.sqlcl.commands.blockchain.Messages;

public class ImmutableTableNameCompleter
implements SemanticCompleter {
    private static final Pattern SPECIAL_CHARACTERS_PATTERN = Pattern.compile("[~!@#$%^&*()_+{}|:\"<>?\\[\\]\\\\;',./\\-]");
    private static final Pattern LOWERCASE_PATTERN = Pattern.compile("[a-z]");
    private static final Pattern UPPERCASE_PATTERN = Pattern.compile("[A-Z]");

    public List<CompletionItem> complete(String prefix, ScriptRunnerContext ctx, Map<String, Object> transformedOptionsMap) {
        LinkedList<CompletionItem> ret = new LinkedList<CompletionItem>();
        if (prefix.startsWith("\":") || prefix.startsWith(":")) {
            ArrayList list = new ArrayList(ctx.getVarMap().keySet());
            for (String l : list) {
                ret.add(new CompletionItem("\":" + l + "\"", CompletionItem.Type.USER));
            }
        } else {
            try (Statement stmt = ctx.getCurrentConnection().createStatement();
                 ResultSet rs = stmt.executeQuery("select schema_name, table_name from ALL_IMMUTABLE_TABLES");){
                while (rs.next()) {
                    Object schemaNameModified = rs.getString(1);
                    Object tableNameModified = rs.getString(2);
                    schemaNameModified = ImmutableTableNameCompleter.containsRequiredCharacters((String)schemaNameModified) != false ? "\"\"\"" + (String)schemaNameModified + "\"\"" : "\"" + (String)schemaNameModified;
                    tableNameModified = ImmutableTableNameCompleter.containsRequiredCharacters((String)tableNameModified) != false ? "\"\"" + (String)tableNameModified + "\"\"\"" : (String)tableNameModified + "\"";
                    String tableName = (String)schemaNameModified + "." + (String)tableNameModified;
                    ret.add(new CompletionItem(tableName, CompletionItem.Type.USER));
                }
            }
            catch (Throwable e) {
                BICException e1 = new BICException(new String[]{String.format(Messages.getString("BICEXP.COMPLETER_ERROR"), e.getMessage())});
                ctx.writeln(e1.getMessage());
            }
        }
        return ret;
    }

    public static Boolean containsRequiredCharacters(String name) {
        boolean hasSpecialCharacter = SPECIAL_CHARACTERS_PATTERN.matcher(name).find();
        boolean hasLowercase = LOWERCASE_PATTERN.matcher(name).find();
        boolean hasUppercase = UPPERCASE_PATTERN.matcher(name).find();
        if (hasSpecialCharacter || hasLowercase && hasUppercase) {
            return true;
        }
        return false;
    }
}

