/*
 * Decompiled with CFR 0.152.
 */
package oracle.arbori.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.arbori.util.Array;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;

public interface CharOffsets {
    public static int charPos2LineNo(String txt, int pos) {
        int ret = 1;
        for (int i = 0; i < pos; ++i) {
            if (txt.charAt(i) != '\n') continue;
            ++ret;
        }
        return ret;
    }

    public static int lineNo2CharPos(String txt, int line) {
        int l = 1;
        for (int i = 0; i < txt.length(); ++i) {
            if (txt.charAt(i) == '\r') {
                ++i;
            }
            if (l == line) {
                return i;
            }
            if (txt.charAt(i) != '\n') continue;
            ++l;
        }
        return -1;
    }

    public static int[] lineMap(String txt) {
        LinkedList<Integer> tmp = new LinkedList<Integer>();
        for (int i = 0; i < txt.length(); ++i) {
            if (txt.charAt(i) != '\n') continue;
            tmp.add(i);
        }
        int[] ret = new int[tmp.size()];
        int i = 0;
        Iterator iterator = tmp.iterator();
        while (iterator.hasNext()) {
            int x = (Integer)iterator.next();
            ret[i++] = x;
        }
        return ret;
    }

    public static int lineNo2CharPos0(int[] lineMap, int line) {
        if (line == 0) {
            return 0;
        }
        if (lineMap.length <= line) {
            return lineMap[lineMap.length - 1] + 1;
        }
        return lineMap[line - 1] + 1;
    }

    public static int lineNo2CharPos1(int[] lineMap, int line) {
        return CharOffsets.lineNo2CharPos0(lineMap, line - 1);
    }

    public static int charPos2LineNo0(int[] lineMap, int pos) {
        if (lineMap.length == 0) {
            return 0;
        }
        if (lineMap[lineMap.length - 1] < pos) {
            return lineMap.length;
        }
        return Array.indexOf(lineMap, pos);
    }

    public static int charPos2LineNo1(int[] lineMap, int pos) {
        return CharOffsets.charPos2LineNo0(lineMap, pos) + 1;
    }

    public static int lineDiff(String content1, String content2) {
        List<LexerToken> src1 = Lexer.parse(content1);
        List<LexerToken> src2 = Lexer.parse(content2);
        int size = Integer.min(src1.size(), src2.size());
        for (int i = 0; i < size; ++i) {
            LexerToken t1 = src1.get(i);
            if (t1.content.equals(src2.get((int)i).content)) continue;
            return CharOffsets.charPos2LineNo(content1, t1.begin);
        }
        if (src1.size() < src2.size()) {
            if (src1.size() == 0) {
                return 1;
            }
            return CharOffsets.charPos2LineNo(content1, src1.get((int)(src1.size() - 1)).end);
        }
        if (src2.size() < src1.size()) {
            if (src2.size() == 0) {
                return 1;
            }
            return CharOffsets.charPos2LineNo(content2, src2.get((int)(src2.size() - 1)).end);
        }
        return -1;
    }
}

