/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scripting;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.scripting.Messages;
import oracle.dbtools.scripting.Script;

public class ScriptingUtils {
    private static Logger LOGGER = Logger.getLogger(ScriptingUtils.class.getName());

    public static Object runScript(Script script, Map<String, Object> map) throws ScriptException {
        return ScriptingUtils.runScript(null, script, map);
    }

    public static Object runScript(ScriptRunnerContext ctx, Script script, Map<String, Object> map) throws ScriptException {
        ScriptEngine engine;
        System.setProperty("polyglot.js.nashorn-compat", "true");
        ScriptEngineManager mgr = new ScriptEngineManager();
        SimpleScriptContext scriptCtx = new SimpleScriptContext();
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("polyglot.js.allowHostAccess", (Object)true);
        bindings.put("polyglot.js.allowNativeAccess", (Object)true);
        bindings.put("polyglot.js.allowCreateThread", (Object)true);
        bindings.put("polyglot.js.allowIO", (Object)true);
        bindings.put("polyglot.js.allowHostClassLoading", (Object)true);
        bindings.put("polyglot.js.allowHostClassLookup", s -> true);
        bindings.put("polyglot.js.allowAllAccess", (Object)true);
        for (String key : map.keySet()) {
            bindings.put(key, map.get(key));
            Logger.getLogger(ScriptingUtils.class.getClass().getName()).finer("Adding:" + key);
        }
        mgr.setBindings(bindings);
        scriptCtx.setBindings(bindings, 200);
        String language = script.getExtension() == null ? script.getLanguage() : script.getExtension();
        ScriptEngine scriptEngine = engine = script.getExtension() == null ? mgr.getEngineByExtension(script.getLanguage()) : mgr.getEngineByExtension(script.getExtension());
        if (engine == null) {
            ctx.write(Messages.getString("NO_JS_AVAIL"));
            return null;
        }
        if (ctx != null && ctx.getProperty("SCRIPT_ENGINE:" + language) != null) {
            LOGGER.info("\nReUsing  Engine: " + language + "\n");
            engine = (ScriptEngine)ctx.getProperty("SCRIPT_ENGINE:" + language);
        }
        Object ret = null;
        try {
            ret = engine.eval(script.getScript(), (ScriptContext)scriptCtx);
        }
        catch (Exception sqlex) {
            if (sqlex instanceof SQLException || sqlex.getCause() instanceof SQLException) {
                ExceptionHandler.handleException(sqlex);
            }
            throw sqlex;
        }
        if (ret != null) {
            Logger.getLogger(ScriptingUtils.class.getClass().getName()).finer("Returned:" + ret.toString());
        }
        if (ctx != null) {
            LOGGER.info("\nSaving  Engine: " + language + "\n");
            ctx.putProperty("SCRIPT_ENGINE:" + language, engine);
        }
        return ret;
    }

    public static String showEngines() {
        String NL = "\n";
        String SPACE = " ";
        StringBuilder sb = new StringBuilder();
        ScriptEngineManager manager = new ScriptEngineManager();
        List<ScriptEngineFactory> factories = manager.getEngineFactories();
        if (!factories.isEmpty()) {
            for (ScriptEngineFactory factory : factories) {
                sb.append(factory.getEngineName() + "\n");
                sb.append(" Engine Version:" + factory.getEngineVersion() + "\n");
                sb.append(" Language Name:" + factory.getLanguageName() + "\n");
                sb.append(" Language Version:" + factory.getLanguageVersion() + "\n");
                sb.append(" Extensions:" + String.valueOf(factory.getExtensions()) + "\n");
                sb.append(" Mime Types:" + String.valueOf(factory.getMimeTypes()) + "\n");
                sb.append(" Aliases:" + String.valueOf(factory.getNames()) + "\n");
            }
        } else {
            sb.append("No Javascript engines available\n");
        }
        return sb.toString();
    }
}

