/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.export;

import java.util.List;
import oracle.dbtools.data.common.NullOrEmpty;
import oracle.dbtools.rest.generators.RestCodeGenResults;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestPrivilege;
import oracle.dbtools.rest.model.RestSchema;

public class RestExport {
    private static final String NEWLINE = RestCodeGenResults.NEWLINE;
    private RestCodeGenResults m_codeGen;
    private StringBuilder m_codeSB;
    private String m_schema;
    private String m_ordsSchemaVer;

    public RestExport(String productName, String productVersion, String schema, String ordsSchemaVer) {
        this(productName, productVersion, schema, ordsSchemaVer, 0);
    }

    public RestExport(String productName, String productVersion, String schema, String ordsSchemaVer, int dbVersion) {
        this.m_schema = schema;
        this.m_ordsSchemaVer = ordsSchemaVer;
        this.m_codeGen = dbVersion != 0 ? new RestCodeGenResults(productName, productVersion, dbVersion) : new RestCodeGenResults(productName, productVersion);
    }

    public void setBackwardsCompatible(boolean indicator) {
        this.getCodeGen().setBackwardsCompatible(indicator);
    }

    public String exportModulesRolesPrivileges(RestSchema schema, List<RestModule> modules, List<String> roles, List<RestPrivilege> privileges) {
        String code;
        String privs;
        if (schema != null) {
            this.addCode(this.getCodeGen().generateEnableSchema(schema));
        }
        if (modules != null && !modules.isEmpty()) {
            for (RestModule module : modules) {
                this.addCode(this.getCodeGen().generateModuleTemplatesHandlers(module, false, false), false);
            }
        }
        if (roles != null && !roles.isEmpty()) {
            this.addCode(this.getCodeGen().getCreateRoles(roles, false, false));
        }
        boolean hasPrivileges = false;
        if (privileges != null && !privileges.isEmpty() && (privs = this.getCodeGen().getDefinePrivileges(privileges, false, false)) != null) {
            hasPrivileges = true;
            this.addCode(privs, false);
        }
        if (!NullOrEmpty.nullOrEmpty(code = this.getCode())) {
            String beginEndStmt = null;
            beginEndStmt = hasPrivileges ? this.getCodeGen().getPrivilegeBeginEnd(code, true) : this.getCodeGen().getBeginStatementsEnd(code, true);
            if (!NullOrEmpty.nullOrEmpty(beginEndStmt)) {
                StringBuilder fullCode = new StringBuilder();
                String commentHdr = this.getCodeGen().getCommentHeader(this.m_schema, this.m_ordsSchemaVer);
                if (commentHdr != null) {
                    fullCode.append(commentHdr).append(NEWLINE).append(beginEndStmt);
                } else {
                    fullCode.append(beginEndStmt);
                }
                return fullCode.toString();
            }
        }
        return null;
    }

    private RestCodeGenResults getCodeGen() {
        if (this.m_codeGen == null) {
            this.m_codeGen = new RestCodeGenResults();
        }
        return this.m_codeGen;
    }

    private void addCode(String code) {
        this.addCode(code, true);
    }

    private void addCode(String code, boolean includeNewLine) {
        if (code != null) {
            if (this.m_codeSB == null) {
                this.m_codeSB = new StringBuilder();
            }
            this.m_codeSB.append(code);
            if (includeNewLine) {
                this.m_codeSB.append(NEWLINE);
            }
        }
    }

    private String getCode() {
        if (this.m_codeSB == null) {
            return "";
        }
        return this.m_codeSB.toString();
    }
}

