/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.transformer.database;

import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.arbori.util.DbObjNames;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.TransformContext;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.basic.PrimitiveTransformers;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.basic.TypedList;

public class CanonicalDbNamesTransformer
extends TypedList<String> {
    public CanonicalDbNamesTransformer(Transformer<String, String> elementTransformer) {
        super(elementTransformer);
    }

    public CanonicalDbNamesTransformer() {
        super(PrimitiveTransformers.get(String.class));
    }

    @Override
    public List<String> transform(String rawValue, TransformContext context, Environment environment) {
        if (rawValue == null) {
            return null;
        }
        LinkedList<String> ret = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(rawValue, ",");
        while (st.hasMoreTokens()) {
            Object object = st.nextToken().trim();
            int pos = ((String)object).indexOf(46);
            String owner = null;
            if (0 < pos) {
                owner = ((String)object).substring(0, pos);
                object = ((String)object).substring(pos + 1);
                owner = DbObjNames.handleMixedCase((String)owner);
            }
            object = DbObjNames.handleMixedCase((String)object);
            if (owner != null) {
                object = owner + "." + (String)object;
            }
            ret.add((String)object);
        }
        return ret;
    }
}

