/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.transformer.basic;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.TransformContext;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;

public class TypedList<E>
implements Transformer<String, List<E>> {
    private static final Pattern LIST_PATTERN = Pattern.compile("(?:(?:'(?:[^']|'')*')|(?:\"(?:[^\"]|\"\")*\")|,|(?:\\s+)|(?:[^\\s,'\"]+))");
    private static final Pattern ESCAPES_SINGLE_PATTERN = Pattern.compile("''");
    private static final Pattern ESCAPES_DOUBLE_PATTERN = Pattern.compile("\"\"");
    private final Transformer<String, E> elementTransformer;

    public TypedList(Transformer<String, E> elementTransformer) {
        this.elementTransformer = elementTransformer;
    }

    @Override
    public List<E> transform(String rawValue, TransformContext context, Environment environment) {
        List<String> rawElements = this.split(rawValue);
        ArrayList<E> elements = new ArrayList<E>();
        for (String rawElement : rawElements) {
            E value = this.elementTransformer.transform(rawElement, context, environment);
            if (value == null) continue;
            elements.add(value);
        }
        return elements;
    }

    private List<String> split(String value) {
        ArrayList<String> elements = new ArrayList<String>();
        Matcher lineMatcher = LIST_PATTERN.matcher(value);
        boolean firstNonWhite = true;
        boolean previousComma = false;
        while (lineMatcher.find()) {
            String reducedValue;
            String wordMatch = lineMatcher.group(0);
            if (wordMatch.equals(",")) {
                if (firstNonWhite || previousComma) {
                    elements.add("");
                }
                previousComma = true;
                firstNonWhite = false;
                continue;
            }
            if (wordMatch.isBlank()) continue;
            Pattern escapesPattern = null;
            if (wordMatch.length() > 1) {
                char first = wordMatch.charAt(0);
                if (first == '\'') {
                    escapesPattern = ESCAPES_SINGLE_PATTERN;
                } else if (first == '\"') {
                    escapesPattern = ESCAPES_DOUBLE_PATTERN;
                }
            }
            if (escapesPattern != null) {
                String dequotedWord = wordMatch.substring(1, wordMatch.length() - 1);
                Matcher escapesMatcher = escapesPattern.matcher(dequotedWord);
                StringBuilder sbuf = new StringBuilder();
                int charNo = 0;
                while (escapesMatcher.find()) {
                    String escapesMatch = escapesMatcher.group();
                    int escapesStart = escapesMatcher.start();
                    int escapesEnd = escapesMatcher.end();
                    switch (escapesMatch) {
                        case "''": {
                            sbuf.append(dequotedWord.substring(charNo, escapesStart));
                            sbuf.append("'");
                            break;
                        }
                        case "\"\"": {
                            sbuf.append(dequotedWord.substring(charNo, escapesStart));
                            sbuf.append("\"");
                        }
                    }
                    charNo = escapesEnd;
                }
                sbuf.append(dequotedWord.substring(charNo));
                reducedValue = sbuf.toString();
            } else {
                reducedValue = wordMatch;
            }
            elements.add(reducedValue);
            previousComma = false;
            firstNonWhite = false;
        }
        return elements;
    }

    @Override
    public String getFormat(Locale locale) {
        if (this.elementTransformer != null && this.elementTransformer.getFormat(locale) != null) {
            return this.elementTransformer.getFormat(locale) + ",...";
        }
        return null;
    }

    @Override
    public String toString(List<E> value) {
        if (this.elementTransformer != null && value != null) {
            StringBuilder sbuf = new StringBuilder();
            boolean first = true;
            for (E val : value) {
                if (first) {
                    first = false;
                } else {
                    sbuf.append(",");
                }
                sbuf.append(this.elementTransformer.toString(val));
            }
            return sbuf.toString();
        }
        return value.toString();
    }
}

