/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Expression;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ExpressionBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Grammar;
import oracle.dbtools.raptor.newscriptrunner.util.parser.GrammarBuildContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Monitor;
import oracle.dbtools.raptor.newscriptrunner.util.parser.NamedExpressionVisitor;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Node;
import oracle.dbtools.raptor.newscriptrunner.util.parser.RootBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Rule;
import oracle.dbtools.raptor.newscriptrunner.util.parser.RuleBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Syntax;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.tokenizer.Token;

public class GrammarBuilder {
    private final List<Grammar<?>> extendedGrammars = new ArrayList();
    private final List<RuleBuilder> ruleBuilders = new ArrayList<RuleBuilder>();
    private Class<?> type;
    private boolean required;
    private Object defaultValue;
    private Monitor monitor;

    public GrammarBuilder extend(Grammar<?> extendedGrammar) {
        this.extendedGrammars.add(extendedGrammar);
        return this;
    }

    public GrammarBuilder dataType(Class<?> type) {
        this.type = type;
        return this;
    }

    public GrammarBuilder required() {
        this.required = true;
        return this;
    }

    public GrammarBuilder defaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public GrammarBuilder monitor(Monitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public GrammarBuilder add(RuleBuilder rule) {
        this.ruleBuilders.add(rule);
        return this;
    }

    public <T> Grammar<T> build() {
        final ArrayList resolvers = new ArrayList();
        GrammarBuildContext context = new GrammarBuildContext(){

            @Override
            public void addResolver(Consumer<Function<Object, Rule>> resolver) {
                resolvers.add(resolver);
            }

            @Override
            public Expression compose(Expression with) {
                if (GrammarBuilder.this.monitor != null) {
                    return new MonitoredExpression(with, GrammarBuilder.this.monitor);
                }
                return with;
            }

            @Override
            public List<Expression> build(List<ExpressionBuilder> builders) {
                ArrayList<Expression> expressions = new ArrayList<Expression>();
                for (ExpressionBuilder builder : builders) {
                    expressions.add(builder.build(this));
                }
                return expressions;
            }
        };
        HashMap<String, Rule> ruleMap = new HashMap<String, Rule>();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        Rule startRule = null;
        for (RuleBuilder ruleBuilder : this.ruleBuilders) {
            Rule rule;
            if (startRule == null) {
                startRule = rule = ruleBuilder.build(context, true);
            } else {
                rule = ruleBuilder.build(context, false);
            }
            rules.add(rule);
            ruleMap.put(rule.getId().toString(), rule);
        }
        for (Grammar grammar : this.extendedGrammars) {
            for (Rule rule : grammar.getRules()) {
                rules.add(rule);
                ruleMap.put(rule.getId().toString(), rule);
            }
        }
        if (startRule == null) {
            throw new IllegalArgumentException("a grammer must contain at least one rule");
        }
        for (Consumer consumer : resolvers) {
            consumer.accept(id -> {
                Rule rule = (Rule)ruleMap.get(id.toString());
                if (rule == null) {
                    throw new IllegalStateException("grammar error: rule '" + id.toString() + "' not found");
                }
                return rule;
            });
        }
        Expression root = new RootBuilder(startRule.getId(), startRule.getExpression()).build(context);
        return new GrammarImpl(this, startRule, rules, root);
    }

    protected GrammarBuilder() {
    }

    private static class GrammarImpl<T>
    implements Grammar<T> {
        private final Class<T> type;
        private T defaultValue;
        private final boolean required;
        private final Rule startRule;
        private final Expression root;
        private final Collection<Rule> rules;

        private GrammarImpl(GrammarBuilder builder, Rule startRule, Collection<Rule> rules, Expression root) {
            Class clazz = this.type = builder.type != null ? builder.type : String.class;
            if (builder.defaultValue != null && !this.type.isAssignableFrom(builder.defaultValue.getClass())) {
                throw new IllegalArgumentException("type of defaultValue is inconsistent with the grammar type " + builder.defaultValue.getClass().getName());
            }
            this.defaultValue = builder.defaultValue;
            this.required = builder.required;
            this.startRule = startRule;
            this.root = root;
            this.rules = rules;
        }

        @Override
        public Class<T> getDataType() {
            return this.type;
        }

        @Override
        public T getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public Rule getStartRule() {
            return this.startRule;
        }

        @Override
        public Collection<Rule> getRules() {
            return this.rules;
        }

        @Override
        public Node parse(List<Token> tokens, Environment environment) {
            Node node = Node.createRootNode(this.root, tokens, environment);
            this.root.parse(node);
            return node;
        }
    }

    private static class MonitoredExpression
    implements Expression {
        private final Expression expression;
        private final Monitor monitor;

        private MonitoredExpression(Expression expression, Monitor monitor) {
            this.expression = expression;
            this.monitor = monitor;
        }

        @Override
        public Syntax getSyntax() {
            return this.expression.getSyntax();
        }

        @Override
        public void visitNamedExpressions(NamedExpressionVisitor visitor) {
            this.expression.visitNamedExpressions(visitor);
        }

        @Override
        public void parse(Node node) {
            this.monitor.beforeParse();
            this.expression.parse(node);
            this.monitor.afterParse(node);
        }

        public String toString() {
            return this.expression.toString();
        }
    }
}

