/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Expression;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ExpressionBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.GrammarBuildContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.NamedExpressionVisitor;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Node;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Syntax;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;

public final class ChoiceBuilder
extends ExpressionBuilder {
    private final Transformer<Node, ?> transformer;
    private final List<ExpressionBuilder> items;

    protected ChoiceBuilder(Transformer<Node, ?> transformer, ExpressionBuilder ... items) {
        this.transformer = transformer;
        this.items = Arrays.asList(items);
    }

    @Override
    protected Expression build(GrammarBuildContext context) {
        return context.compose(new Choice(context, this));
    }

    private static class Choice
    implements Expression {
        private final Transformer<Node, ?> transformer;
        private final List<Expression> items;

        Choice(GrammarBuildContext context, ChoiceBuilder builder) {
            this.transformer = builder.transformer;
            this.items = context.build(builder.items);
        }

        @Override
        public Syntax getSyntax() {
            StringBuilder buff = new StringBuilder();
            boolean firstChoice = true;
            for (Expression choice : this.items) {
                if (firstChoice) {
                    firstChoice = false;
                } else {
                    buff.append(" | ");
                }
                buff.append(choice.getSyntax().get());
            }
            return new Syntax(buff.toString(), true);
        }

        @Override
        public void visitNamedExpressions(NamedExpressionVisitor visitor) {
            for (Expression item : this.items) {
                item.visitNamedExpressions(visitor);
            }
        }

        @Override
        public void parse(Node node) {
            Node emptyMatch = null;
            ArrayList<Node> unmatchedChildNodes = new ArrayList<Node>();
            for (Expression choice : this.items) {
                Node childNode = node.createChildContext(choice);
                choice.parse(childNode);
                if (childNode.isMatched() && !childNode.isEmpty()) {
                    this.setMatch(node, childNode);
                    return;
                }
                if (childNode.isMatched() && emptyMatch == null) {
                    emptyMatch = childNode;
                }
                unmatchedChildNodes.add(childNode);
            }
            if (emptyMatch != null) {
                this.setMatch(node, emptyMatch);
            }
            for (Node unmatchedChildNode : unmatchedChildNodes) {
                this.mergeChildNode(node, unmatchedChildNode);
            }
        }

        public String toString() {
            return "CHOICE";
        }

        private void setMatch(Node node, Node childNode) {
            this.mergeChildNode(node, childNode);
            node.addChildNode(childNode);
            node.setValueFrom(childNode, this.transformer);
            node.setMatched();
        }

        private void mergeChildNode(Node node, Node childNode) {
            node.mergeCompletions(childNode.getCompletions());
            node.mergeParseError(childNode.getParseError());
            node.mergeSemanticErrors(childNode.getSemanticErrors());
        }
    }
}

