/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.help;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpStrings;
import oracle.dbtools.raptor.newscriptrunner.util.help.PageAssembler;
import oracle.dbtools.raptor.newscriptrunner.util.help.StructuredHelpPage;

public abstract class AbstractPageAssembler
implements PageAssembler {
    private static final Pattern LAYOUT_PATTERN = Pattern.compile("(?:\\\\\\$|\\$|\\\\\\n|\\\\n|\\n|\\t|\\\\#|[ \\r\\f]+|[^\\\\$\\s]+)");

    @Override
    public StructuredHelpPage getPage(int lineSize, boolean alphaSort, Locale locale, HelpStrings helpStrings, List<String> moreHelpTopics, boolean enableColorCode) {
        LayoutHelper layoutHelper = new LayoutHelper(lineSize, enableColorCode);
        String rawPage = this.getRawPage(alphaSort, locale, helpStrings, moreHelpTopics);
        if (rawPage != null) {
            layoutHelper.layout(rawPage);
            return new StructuredHelpPage(layoutHelper.get(), Collections.emptyMap());
        }
        return null;
    }

    protected abstract String getRawPage(boolean var1, Locale var2, HelpStrings var3, List<String> var4);

    protected class LayoutHelper {
        private final StringBuilder buff = new StringBuilder();
        private final int maxLineLength;
        private final boolean enableColorCode;
        private int lineLength = 0;
        private int wrapPosition = -1;
        private int tabs = 0;
        private boolean atLineStart;
        private boolean inRegion;

        public LayoutHelper(int maxLineLength, boolean enableColorCode) {
            this.maxLineLength = maxLineLength;
            this.enableColorCode = enableColorCode;
        }

        public void layout(String text) {
            Matcher styleMatcher = LAYOUT_PATTERN.matcher(text);
            block18: while (styleMatcher.find()) {
                String match;
                switch (match = styleMatcher.group()) {
                    case "\\$": {
                        this.addWordPart("$");
                        continue block18;
                    }
                    case "$": {
                        this.regionColorDelim();
                        continue block18;
                    }
                    case "\\#": {
                        this.regionBoldDelim();
                        continue block18;
                    }
                    case "\n": {
                        this.addNewLine();
                        continue block18;
                    }
                    case "\\n": {
                        this.addTabNewLine();
                        continue block18;
                    }
                    case "\\\\n": {
                        this.addNewLine();
                        continue block18;
                    }
                    case "\t": {
                        this.addTab();
                        continue block18;
                    }
                }
                if (match.trim().isEmpty()) {
                    this.addWhiteSpace(match);
                    continue;
                }
                this.addWordPart(match);
            }
        }

        public String get() {
            return this.buff.toString();
        }

        private void addWordPart(String text) {
            int textLen = text.length();
            if (this.lineLength + textLen > this.maxLineLength && this.wrapPosition >= 0) {
                this.lineLength = 0;
                for (int t = 0; t < this.tabs; ++t) {
                    this.buff.insert(this.wrapPosition, "  ");
                    this.lineLength += 2;
                }
                this.buff.setCharAt(this.wrapPosition, '\n');
                this.wrapPosition = -1;
            }
            this.buff.append(text);
            this.lineLength += textLen;
            this.atLineStart = false;
        }

        private void addWhiteSpace(String text) {
            int textLen = text.length();
            if (this.lineLength + textLen > this.maxLineLength) {
                this.buff.append('\n');
                this.wrapPosition = -1;
                this.lineLength = 0;
                for (int t = 0; t < this.tabs; ++t) {
                    this.buff.append("  ");
                    this.lineLength += 2;
                }
            } else {
                this.buff.append(text);
                this.lineLength += textLen;
                this.wrapPosition = this.buff.length() - 1;
            }
            this.atLineStart = false;
        }

        private void addNewLine() {
            this.buff.append("\n");
            this.wrapPosition = -1;
            this.lineLength = 0;
            this.tabs = 0;
            this.atLineStart = true;
        }

        private void addTabNewLine() {
            this.buff.append("\n");
            this.lineLength = 0;
            for (int t = 0; t < this.tabs; ++t) {
                this.buff.append("  ");
                this.lineLength += 2;
            }
            this.wrapPosition = -1;
        }

        private void addTab() {
            if (this.lineLength + 2 > this.maxLineLength) {
                this.buff.append('\n');
                this.wrapPosition = -1;
                this.lineLength = 0;
                this.tabs = 0;
            } else {
                this.buff.append("  ");
                this.lineLength += 2;
                if (this.atLineStart) {
                    ++this.tabs;
                }
            }
        }

        private void regionColorDelim() {
            if (this.inRegion) {
                if (this.enableColorCode) {
                    this.buff.append('\u001b').append("[0m");
                }
                this.inRegion = false;
            } else {
                if (this.enableColorCode) {
                    this.buff.append('\u001b').append("[33m");
                }
                this.inRegion = true;
            }
        }

        private void regionBoldDelim() {
            if (this.inRegion) {
                this.buff.append('\u001b').append("[0m");
            } else {
                this.buff.append('\u001b').append("[1m");
            }
            this.inRegion = !this.inRegion;
        }
    }
}

