/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.jdbc.OracleConnection;

@Restricted(level=Restricted.Level.NONE)
public class ShowSga
implements IShowCommand,
IShowPrefixNameNewline {
    private static final String[] SHOWSGA = new String[]{"sga"};

    @Override
    public String[] getShowAliases() {
        return SHOWSGA;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowSga(conn, ctx, cmd);
        }
        if (ctx.getCurrentConnection() != null && ctx.getCurrentConnection().getClass().getName().equals("oracle.nucleo.jdbc.impl.NucleoConnectionImpl")) {
            ctx.write("Not supported for nucleo connection\n");
            return true;
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return true;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doShowSga(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        block37: {
            boolean amILocked = false;
            ResultSet rs = null;
            Statement s = null;
            try {
                amILocked = LockManager.lock(ctx.getBaseConnection());
                if (!amILocked) break block37;
                ctx.putProperty("sqldev.last.err.message.forsqlcode", null);
                String querySql = "SELECT DECODE(null,'','Total System Global Area','') NAME_COL_PLUS_SHOW_SGA,  to_char(SUM(VALUE)) VALUE, DECODE (null,'', 'bytes','') units_col_plus_show_sga FROM V$SGA  UNION ALL  SELECT NAME NAME_COL_PLUS_SHOW_SGA , to_char(value) VALUE,  DECODE (null,'', 'bytes','') units_col_plus_show_sga FROM V$SGA";
                s = ctx.getCurrentConnection().createStatement();
                rs = s.executeQuery(querySql);
                String overSizedSpace = "                                                                                                                                ";
                int maxsize = 0;
                if (rs != null) {
                    while (rs.next()) {
                        int size = rs.getString(2).length();
                        if (size <= maxsize) continue;
                        maxsize = size;
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception size) {
                            // empty catch block
                        }
                    }
                }
                if (rs != null) {
                    rs = s.executeQuery(querySql);
                    int[] columnSizes = new int[]{25, maxsize + 1, 10};
                    ctx.write("\n");
                    while (rs.next()) {
                        int i = 0;
                        for (int thisColumn : columnSizes) {
                            String columnString;
                            if ((columnString = rs.getString(++i)) == null) {
                                columnString = "";
                            }
                            if (i == 2) {
                                String padString = overSizedSpace + columnString;
                                columnString = padString.substring(padString.length() - thisColumn);
                            } else {
                                columnString = (columnString + overSizedSpace).substring(0, thisColumn);
                            }
                            ctx.write(columnString);
                            ctx.write(" ");
                        }
                        ctx.write("\n");
                    }
                }
            }
            catch (SQLException e) {
                ctx.putProperty("sqldev.last.err.message.forsqlcode", e.getMessage());
                ctx.write(e.getLocalizedMessage());
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Exception exception) {}
                }
                if (amILocked) {
                    try {
                        LockManager.unlock(ctx.getBaseConnection());
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return true;
    }
}

