/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.Show;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.R4)
public class ShowNumwidth
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWNUMWIDTH = new String[]{"numwidth", "numw", "numwi", "numwid", "numwidt", "num"};

    @Override
    public String[] getShowAliases() {
        return SHOWNUMWIDTH;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return this.doShowNumwidth(conn, ctx, cmd);
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowNumwidth(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        Integer val = (Integer)ctx.getProperty("script.runner.setnumwidth");
        String str = MessageFormat.format(Messages.getString("NUMWIDTH"), val.toString()) + Show.m_lineSeparator;
        ctx.write(str);
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        return StoreRegistry.getCommand("numwidth", String.valueOf(ctx.getProperty("script.runner.setnumwidth")));
    }
}

