/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.ddl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;

public class DbmsMetadataDDLGenerator {
    private Connection _conn;
    private ScriptRunnerContext _ctx;
    public static final String BODY = "BODY";
    public static final String CONSUMER = "CONSUMER";
    public static final String GROUP = "GROUP";
    public static final String LOG = "LOG";
    public static final String MATERIALIZED = "MATERIALIZED";
    public static final String PARTITION = "PARTITION";
    public static final String REDO = "REDO";
    public static final String REF = "REF";
    public static final String PL_SQL = "PL/SQL";
    public static final String PLSQL = "PLSQL";
    public static final String TABLE = "TABLE";
    public static final String VIEW = "VIEW";
    public static final String CONSTRAINT = "CONSTRAINT";
    public static final String CONSUMERGROUP = "CONSUMER GROUP";
    public static final String CONTAINERRMPLAN = "CONTAINERRMPLAN";
    public static final String DATAFILE = "DATAFILE";
    public static final String DATABASELINK = "DATABASE LINK";
    public static final String DB_LINK = "DB_LINK";
    public static final String DBLINK = "DBLINK";
    public static final String FUNCTION = "FUNCTION";
    public static final String INDEX = "INDEX";
    public static final String JOB = "JOB";
    public static final String MATVIEW = "MATERIALIZED VIEW";
    public static final String MATVIEWLOG = "MATERIALIZED VIEW LOG";
    public static final String OBJECT = "OBJECT";
    public static final String OPERATOR = "OPERATOR";
    public static final String PACKAGE = "PACKAGE";
    public static final String PACKAGEBODY = "PACKAGE BODY";
    public static final String PROCEDURE = "PROCEDURE";
    public static final String PROFILE = "PROFILE";
    public static final String QUEUE = "QUEUE";
    public static final String QUEUETABLE = "QUEUE TABLE";
    public static final String REDOLOGGROUP = "REDO LOG GROUP";
    public static final String REFCONSTRAINT = "REF CONSTRAINT";
    public static final String ROLE = "ROLE";
    public static final String SEQUENCE = "SEQUENCE";
    public static final String SYNONYM = "SYNONYM";
    public static final String TABLEPARTITION = "TABLE PARTITION";
    public static final String TABLESPACE = "TABLESPACE";
    public static final String TRIGGER = "TRIGGER";
    public static final String TYPE = "TYPE";
    public static final String TYPEBODY = "TYPE BODY";
    public static final String USER = "USER";
    public static final String MLE_ENV = "MLE ENVIRONMENT";
    public static String[][] types = new String[][]{{"CONSTRAINT"}, {"CONSUMER", "GROUP"}, {"CONTAINERRMPLAN"}, {"DATAFILE"}, {"DATABASE LINK"}, {"DB_LINK"}, {"DBLINK"}, {"FUNCTION"}, {"INDEX"}, {"JOB"}, {"MATERIALIZED", "VIEW"}, {"MATERIALIZED", "VIEW", "LOG"}, {"OBJECT"}, {"PACKAGE"}, {"PACKAGE", "BODY"}, {"PROCEDURE"}, {"PROFILE"}, {"QUEUE"}, {"QUEUE", "TABLE"}, {"REDO", "LOG", "GROUP"}, {"REF", "CONSTRAINT"}, {"ROLE"}, {"SEQUENCE"}, {"SYNONYM"}, {"TABLE"}, {"TABLE", "PARTITION"}, {"TABLESPACE"}, {"TRIGGER"}, {"TYPE"}, {"TYPE", "BODY"}, {"USER"}, {"VIEW"}, {"MLE ENVIRONMENT"}};
    public static final String COMMENT = "COMMENT";
    public static final String PACKAGEWITHBODY = "PACKAGE SPEC+BODY";
    public static final String TABLE_DDL = "table_ddl";
    public static final String VIEW_DDL = "view_ddl";
    public static final String INDEX_DDL = "index_ddl";
    public static final String JOB_DDL = "job_ddl";
    public static final String CONSTRAINT_DDL = "constraint_ddl";
    public static final String FUNCTION_DDL = "function_ddl";
    public static final String CONSUMERGROUP_DDL = "consumergroup_ddl";
    public static final String CONTAINERRMPLAN_DDL = "containerrmplan_ddl";
    public static final String DATAFILE_DDL = "datafile_ddl";
    public static final String DBLINK_DDL = "dblink_ddl";
    public static final String MATVIEW_DDL = "matview_ddl";
    public static final String MATVIEWLOG_DDL = "matviewlog_ddl";
    public static final String OBJECT_DDL = "script_ddl";
    public static final String OPERATOR_DDL = "operator_ddl";
    public static final String PROFILE_DDL = "profile_ddl";
    public static final String QUEUE_DDL = "queue_ddl";
    public static final String QUEUETABLE_DDL = "queueTable_ddl";
    public static final String REDOLOGGROUP_DDL = "redologgroup_ddl";
    public static final String PROCEDURE_DDL = "procedure_ddl";
    public static final String PACKAGESPEC_DDL = "packagespec_ddl";
    public static final String PACKAGEBODY_DDL = "packagebody_ddl";
    public static final String PACKAGE_DDL = "package_ddl";
    public static final String SEQUENCE_DDL = "seq_ddl";
    public static final String SYNONYM_DDL = "syn_ddl";
    public static final String TABLESPACE_DDL = "tablespace_ddl";
    public static final String TYPE_DDL = "type_ddl";
    public static final String TYPE_BODY_DDL = "type_body_ddl";
    public static final String USER_DDL = "user_ddl";
    public static final String ROLE_DDL = "role_ddl";
    public static final String REFCONSTRAINT_DDL = "refconstraint_ddl";
    public static final String TRIGGER_DDL = "trigger_ddl";
    public static final String MLE_ENV_DDL = "mle_env_ddl";

    public DbmsMetadataDDLGenerator(Connection conn, ScriptRunnerContext ctx) {
        this._conn = conn;
        this._ctx = ctx;
    }

    protected List<DDLObjective> getObjectives(String object, String resultType) {
        String origName;
        ResolvedDBName firstObject;
        boolean tooManyObjects;
        LinkedList<ResolvedDBName> resolvedNames;
        boolean outputComponentTypeOnly;
        String objectType;
        LinkedList<DDLObjective> ddlObjectives = new LinkedList<DDLObjective>();
        LinkedList<String> componentTypes = new LinkedList<String>();
        if (resultType != null) {
            if (resultType.equalsIgnoreCase(TABLEPARTITION)) {
                resultType = TABLE;
            }
            switch (resultType = resultType.toUpperCase()) {
                case "DB_LINK": 
                case "DBLINK": 
                case "DATABASE LINK": {
                    objectType = DATABASELINK;
                    componentTypes.add(DATABASELINK);
                    outputComponentTypeOnly = true;
                    break;
                }
                case "MATERIALIZED VIEW LOG": {
                    objectType = TABLE;
                    componentTypes.add(MATVIEWLOG);
                    outputComponentTypeOnly = true;
                    break;
                }
                case "QUEUE TABLE": {
                    objectType = TABLE;
                    componentTypes.add(QUEUETABLE);
                    outputComponentTypeOnly = true;
                    break;
                }
                default: {
                    objectType = resultType;
                    outputComponentTypeOnly = false;
                    break;
                }
            }
        } else {
            objectType = resultType;
            outputComponentTypeOnly = false;
        }
        boolean objectFound = (resolvedNames = this.getTypes(object, objectType)).size() == 1 && resolvedNames.getFirst().getObjectId() != null;
        boolean bl = tooManyObjects = resolvedNames.size() > 1;
        if (resolvedNames.size() == 2) {
            firstObject = resolvedNames.getFirst();
            ResolvedDBName lastObject = resolvedNames.getLast();
            if (PACKAGEBODY.equalsIgnoreCase(firstObject.getTopLevelType()) && PACKAGE.equalsIgnoreCase(lastObject.getTopLevelType())) {
                resolvedNames.add(resolvedNames.pollFirst());
                firstObject = resolvedNames.getFirst();
                lastObject = resolvedNames.getLast();
            }
            if (PACKAGE.equalsIgnoreCase(firstObject.getTopLevelType()) && PACKAGEBODY.equalsIgnoreCase(lastObject.getTopLevelType())) {
                objectFound = firstObject.getObjectId() != null;
                boolean bl2 = tooManyObjects = !objectFound;
                if ("OFF".equals(this._ctx.getParameterInstance().getParameter("ddl.parms", "SPECIFICATION"))) {
                    resolvedNames.remove(firstObject);
                }
                if ("OFF".equals(this._ctx.getParameterInstance().getParameter("ddl.parms", BODY))) {
                    resolvedNames.remove(lastObject);
                }
            }
        } else if (objectFound && resolvedNames.size() == 1) {
            firstObject = resolvedNames.getFirst();
            ObjectNamespace ns = firstObject.getNamespace();
            if (ns != null) {
                String topLevelType = firstObject.getTopLevelType();
                switch (ns.ordinal()) {
                    case 1: {
                        if (PL_SQL.equalsIgnoreCase(objectType) || PLSQL.equalsIgnoreCase(objectType)) {
                            if (!PACKAGE.equalsIgnoreCase(topLevelType)) break;
                            componentTypes.push(PACKAGEWITHBODY);
                            outputComponentTypeOnly = true;
                            break;
                        }
                        if (objectType.equalsIgnoreCase(topLevelType)) break;
                        objectFound = false;
                        break;
                    }
                    case 0: {
                        if (objectType == null || objectType.equalsIgnoreCase(topLevelType)) break;
                        objectFound = false;
                    }
                }
            }
        } else if (objectType != null && resolvedNames.size() == 1 && objectType.equals(DATABASELINK)) {
            objectFound = this.isNonObjectTypeFound(resolvedNames.get(0), objectType);
        }
        DDLObjective ddlObjective = new DDLObjective(object, objectType, componentTypes, outputComponentTypeOnly);
        if (tooManyObjects) {
            origName = ddlObjective.getOrigName();
            StringBuffer buf = new StringBuffer();
            for (ResolvedDBName resolvedName : resolvedNames) {
                if (buf.length() != 0) {
                    buf.append(",");
                }
                buf.append(resolvedName.getTopLevelType());
            }
            this.writeToCtx(MessageFormat.format(Messages.getString("DDL_OBJECT_NOT_UNIQUE"), origName, buf.toString()));
            return null;
        }
        if (!objectFound) {
            origName = ddlObjective.getOrigName();
            String origType = ddlObjective.getOrigType();
            if (origType != null) {
                this.writeToCtx(MessageFormat.format(Messages.getString("DDL_TYPED_OBJECT_NOT_FOUND"), origName, origType));
            } else {
                this.writeToCtx(MessageFormat.format(Messages.getString("DDL_OBJECT_NOT_FOUND"), origName));
            }
            return null;
        }
        ddlObjective.setResolvedDBName(resolvedNames);
        ddlObjectives.add(ddlObjective);
        return ddlObjectives;
    }

    private boolean isNonObjectTypeFound(ResolvedDBName resolvedDBName, String objectType) {
        HashMap<String, String> binds = new HashMap<String, String>();
        String type = resolvedDBName.getTopLevelType() != null ? resolvedDBName.getTopLevelType() : objectType;
        String query = "";
        if (type.equals(DATABASELINK)) {
            query = "select count(*) from dba_objects where object_name=:OBJECT_NAME and owner=:OWNER and object_type = :OBJECT_TYPE";
            try {
                binds.put("OWNER", resolvedDBName.getSchema() != null ? resolvedDBName.getSchema() : this._conn.getMetaData().getUserName());
                binds.put("OBJECT_NAME", resolvedDBName.getTopLevelName());
                binds.put("OBJECT_TYPE", type);
            }
            catch (SQLException e) {
                resolvedDBName.setObjectType(resolvedDBName.getObjectType());
            }
        }
        if (!binds.isEmpty()) {
            boolean bl;
            block12: {
                ResultSet rs = DBUtil.getInstance(this._conn).executeQuery(query, binds);
                try {
                    boolean bl2 = bl = rs != null && rs.next();
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                rs.close();
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkedList<ResolvedDBName> getTypes(String name, String typeHint) {
        LinkedList<ResolvedDBName> resolvedDBNames;
        block30: {
            ResolvedDBName resolvedDBName = null;
            resolvedDBNames = new LinkedList<ResolvedDBName>();
            try {
                ObjectNamespace namespace;
                if (typeHint != null && (namespace = ObjectNamespace.lookup(typeHint)) != null) {
                    resolvedDBName = this.resolveDBName(name, namespace);
                }
                if (resolvedDBName == null) {
                    resolvedDBName = this.pseudoResolveDBName(name);
                }
                if (resolvedDBName.getTopLevelType() == null) {
                    ResultSet rs;
                    String query;
                    HashMap<String, String> binds = new HashMap<String, String>();
                    if (resolvedDBName.getObjectId() != null) {
                        query = "select object_id,object_type from all_objects where object_id=:OBJECT_ID";
                        binds.put("OBJECT_ID", resolvedDBName.getObjectId().toString());
                    } else if (typeHint != null) {
                        query = "select object_id,object_type from all_objects where object_name=:OBJECT_NAME and owner=:OWNER and object_type = :OBJECT_TYPE";
                        try {
                            binds.put("OWNER", resolvedDBName.getSchema() != null ? resolvedDBName.getSchema() : this._conn.getMetaData().getUserName());
                            binds.put("OBJECT_NAME", resolvedDBName.getTopLevelName());
                            binds.put("OBJECT_TYPE", typeHint);
                        }
                        catch (SQLException e) {
                            resolvedDBName.setObjectType(typeHint);
                            binds = null;
                        }
                    } else {
                        query = "select object_id,object_type from all_objects where object_name=:OBJECT_NAME and owner=:OWNER \nand object_type != 'TABLE PARTITION' and object_type != 'TABLE SUBPARTITION' order by object_type asc";
                        try {
                            binds.put("OWNER", resolvedDBName.getSchema() != null ? resolvedDBName.getSchema() : this._conn.getMetaData().getUserName());
                            binds.put("OBJECT_NAME", resolvedDBName.getTopLevelName());
                        }
                        catch (SQLException e) {
                            resolvedDBNames.add(resolvedDBName);
                            binds = null;
                        }
                    }
                    if (binds != null && (rs = DBUtil.getInstance(this._conn).executeQuery(query, binds)) != null) {
                        try {
                            while (rs.next()) {
                                Integer id = rs.getObject(1) != null ? Integer.valueOf(rs.getInt(1)) : null;
                                String type = rs.getString(2);
                                ResolvedDBName template = resolvedDBName.clone();
                                template.setObjectId(id);
                                template.setObjectType(type);
                                resolvedDBNames.add(template);
                            }
                        }
                        catch (SQLException s) {
                        }
                        finally {
                            try {
                                if (rs != null) {
                                    Statement s = rs.getStatement();
                                    if (s != null) {
                                        s.close();
                                    }
                                    rs.close();
                                }
                            }
                            catch (SQLException s) {}
                        }
                    }
                }
                if (resolvedDBNames.size() != 0) break block30;
                resolvedDBNames.add(resolvedDBName);
            }
            catch (Throwable throwable) {
                if (resolvedDBNames.size() == 0) {
                    resolvedDBNames.add(resolvedDBName);
                }
                throw throwable;
            }
        }
        return resolvedDBNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TokenizedDBName callTokenizeDBName(String name) throws SQLException {
        String nameResolve = "begin SYS.DBMS_UTILITY.NAME_TOKENIZE(?,?,?,?,?,?); end;";
        if (LockManager.lock(this._conn)) {
            CallableStatement stmt = null;
            try {
                TokenizedDBName tokenizedDBName;
                block12: {
                    try {
                        stmt = this._conn.prepareCall("begin SYS.DBMS_UTILITY.NAME_TOKENIZE(?,?,?,?,?,?); end;");
                        stmt.setString(1, name);
                        stmt.registerOutParameter(2, 12);
                        stmt.registerOutParameter(3, 12);
                        stmt.registerOutParameter(4, 12);
                        stmt.registerOutParameter(5, 12);
                        stmt.registerOutParameter(6, 4);
                        stmt.execute();
                        String partA = stmt.getString(2);
                        String partB = stmt.getString(3);
                        String partC = stmt.getString(4);
                        String dbLink = stmt.getString(5);
                        tokenizedDBName = new TokenizedDBName(partA, partB, partC, dbLink);
                        if (stmt == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        stmt.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                return tokenizedDBName;
            }
            finally {
                LockManager.unlock(this._conn);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResolvedDBName callResolveDBName(String name, ObjectNamespace namespace) throws SQLException {
        String nameResolve = "begin SYS.DBMS_UTILITY.NAME_RESOLVE(?,?,?,?,?,?,?,?); end;";
        if (LockManager.lock(this._conn)) {
            CallableStatement stmt = null;
            try {
                ResolvedDBName resolvedDBName;
                block12: {
                    try {
                        stmt = this._conn.prepareCall("begin SYS.DBMS_UTILITY.NAME_RESOLVE(?,?,?,?,?,?,?,?); end;");
                        stmt.setString(1, name);
                        stmt.setInt(2, namespace.getIndex());
                        stmt.registerOutParameter(3, 12);
                        stmt.registerOutParameter(4, 12);
                        stmt.registerOutParameter(5, 12);
                        stmt.registerOutParameter(6, 12);
                        stmt.registerOutParameter(7, 4);
                        stmt.registerOutParameter(8, 4);
                        stmt.execute();
                        String schema = stmt.getString(3);
                        String part1 = stmt.getString(4);
                        String part2 = stmt.getString(5);
                        String dbLink = stmt.getString(6);
                        Integer part1Type = stmt.getObject(7) != null ? Integer.valueOf(stmt.getInt(7)) : null;
                        Integer objectId = stmt.getObject(8) != null ? Integer.valueOf(stmt.getInt(8)) : null;
                        TopLevelType topLevelType = TopLevelType.lookup(part1Type);
                        resolvedDBName = new ResolvedDBName(namespace, schema, part1, part2, dbLink, topLevelType, objectId);
                        if (stmt == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        stmt.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                return resolvedDBName;
            }
            finally {
                LockManager.unlock(this._conn);
            }
        }
        return null;
    }

    protected TokenizedDBName tokenizeDBName(String name) {
        TokenizedDBName tokenizedName;
        try {
            tokenizedName = this.callTokenizeDBName(name);
        }
        catch (SQLException e) {
            tokenizedName = null;
        }
        return tokenizedName != null ? tokenizedName : new TokenizedDBName(name);
    }

    protected ResolvedDBName pseudoResolveDBName(String name) {
        return this.tokenizeDBName(name).pseudoResolve();
    }

    protected ResolvedDBName resolveDBName(String name, ObjectNamespace context) {
        try {
            return this.callResolveDBName(name, context);
        }
        catch (SQLException e) {
            return this.pseudoResolveDBName(name);
        }
    }

    protected void writeToCtx(String message, BufferedWriter bw) throws IOException {
        if (message != null && bw == null) {
            this._ctx.write(message);
            this._ctx.write("\n");
        }
        if (message != null && bw != null) {
            bw.write(message);
            bw.newLine();
        }
    }

    protected void writeToCtx(String message) {
        try {
            this.writeToCtx(message, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean processDDL(BufferedWriter bw, String object, String resultType) {
        boolean ok = false;
        List<DDLObjective> ddlObjectives = this.getObjectives(object, resultType);
        if (ddlObjectives != null) {
            try {
                ok = this.getDDL(bw, ddlObjectives);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ok;
    }

    public boolean processDDL(String object, String resultType, String filename) {
        return this.processDDL(object, resultType, filename, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processDDL(String object, String resultType, String filename, boolean append) {
        boolean ok;
        block31: {
            ok = false;
            BufferedWriter bw = null;
            try {
                List<DDLObjective> ddlObjectives = this.getObjectives(object, resultType);
                if (ddlObjectives == null) break block31;
                File f = null;
                if (filename != null) {
                    f = new File(FileUtils.getCWD(this._ctx) + File.separator + filename);
                    try {
                        if (!f.exists()) {
                            f.createNewFile();
                        } else if (!append) {
                            f.delete();
                            f.createNewFile();
                        }
                    }
                    catch (IOException e) {
                        this.writeToCtx(MessageFormat.format(Messages.getString("DDL_FILE_NOT_CREATED"), filename, e.getLocalizedMessage()));
                        boolean bl = ok = false;
                        if (bw != null) {
                            try {
                                bw.flush();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            try {
                                bw.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return bl;
                    }
                    bw = new BufferedWriter(new FileWriter(f, true));
                }
                if (this._ctx.getSQLPlusBuffer() != null) {
                    this._ctx.getSQLPlusBuffer().clear();
                }
                ok = this.getDDL(bw, ddlObjectives);
            }
            catch (IOException e) {
                this.writeToCtx(MessageFormat.format(Messages.getString("DDL_FILE_NOT_WRITABLE"), filename, e.getLocalizedMessage()));
                ok = false;
            }
            finally {
                if (bw != null) {
                    try {
                        bw.flush();
                    }
                    catch (IOException iOException) {}
                    try {
                        bw.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return ok;
    }

    protected boolean getDDL(BufferedWriter bw, List<DDLObjective> ddlObjectives) throws IOException {
        boolean ok = ddlObjectives.size() > 0;
        Iterator<DDLObjective> iterator = ddlObjectives.iterator();
        while (ok && iterator.hasNext()) {
            DDLObjective ddlObjective = iterator.next();
            ok = this.getDDL(bw, ddlObjective);
        }
        return ok;
    }

    protected boolean getDDL(BufferedWriter bw, DDLObjective ddlObjective) throws IOException {
        boolean ok = ddlObjective.getResolvedDBNames().size() > 0;
        Iterator<ResolvedDBName> objectIter = ddlObjective.getResolvedDBNames().iterator();
        while (ok && objectIter.hasNext()) {
            ResolvedDBName resolvedDBName = objectIter.next();
            if (!ddlObjective.outputComponentsOnly()) {
                ok = this.getDDL(bw, ddlObjective, resolvedDBName.getTopLevelType(), resolvedDBName);
            }
            Iterator<String> componentIter = ddlObjective.getComponentTypes().iterator();
            while (ok && componentIter.hasNext()) {
                String type = componentIter.next();
                ok = this.getDDL(bw, ddlObjective, type, resolvedDBName);
            }
        }
        return ok;
    }

    protected final String getQuery(Connection conn, String id) {
        Query q = this.getQueryFromFile(conn, id, this.getQueryFile());
        if (q == null) {
            q = this.getQueryFromFile(conn, id, this.getDefaultQueryFile());
        }
        return q.getSql();
    }

    protected String getQueryFile() {
        return this.getDefaultQueryFile();
    }

    protected Query getQueryFromFile(Connection conn, String id, String file) {
        URL url = this.getClass().getResource(file);
        MetaResource res = new MetaResource(this.getClass().getClassLoader(), file);
        if (res.toURL() == null) {
            res.setUrl(url);
        }
        QueryXMLSupport xml = QueryXMLSupport.getQueryXMLSupport(res);
        Query q = xml.getQuery(id, conn);
        return q;
    }

    protected String getDefaultQueryFile() {
        return "META-INF/ddl/oracle/ObjectSql.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getDDL(BufferedWriter bw, DDLObjective ddlObjective, String type, ResolvedDBName resolvedDBName) throws IOException {
        boolean ok = false;
        ResultSet rset = null;
        SQLException se = null;
        try {
            Object sqlfilename = "META-INF/ddl/oracle/";
            Object dbafilename = "META-INF/ddl/oracledba/";
            Query query = null;
            switch (type) {
                case "TABLE PARTITION": 
                case "TABLE": {
                    sqlfilename = (String)sqlfilename + "TableSql.xml";
                    query = this.getQueryFromFile(this._conn, TABLE_DDL, (String)sqlfilename);
                    break;
                }
                case "VIEW": {
                    sqlfilename = (String)sqlfilename + "ViewSql.xml";
                    query = this.getQueryFromFile(this._conn, VIEW_DDL, (String)sqlfilename);
                    break;
                }
                case "JOB": {
                    sqlfilename = (String)sqlfilename + "JobSql.xml";
                    query = this.getQueryFromFile(this._conn, JOB_DDL, (String)sqlfilename);
                    break;
                }
                case "INDEX": {
                    sqlfilename = (String)sqlfilename + "IndexSql.xml";
                    query = this.getQueryFromFile(this._conn, INDEX_DDL, (String)sqlfilename);
                    break;
                }
                case "CONSTRAINT": {
                    sqlfilename = (String)sqlfilename + "ConstraintSql.xml";
                    query = this.getQueryFromFile(this._conn, CONSTRAINT_DDL, (String)sqlfilename);
                    break;
                }
                case "FUNCTION": {
                    sqlfilename = (String)sqlfilename + "FunctionSql.xml";
                    query = this.getQueryFromFile(this._conn, FUNCTION_DDL, (String)sqlfilename);
                    break;
                }
                case "CONSUMER GROUP": {
                    dbafilename = (String)dbafilename + "ConsumerGroupSql.xml";
                    query = this.getQueryFromFile(this._conn, CONSUMERGROUP_DDL, (String)dbafilename);
                    break;
                }
                case "CONTAINERRMPLAN": {
                    dbafilename = (String)dbafilename + "ContainerRMPlanSql.xml";
                    query = this.getQueryFromFile(this._conn, CONTAINERRMPLAN_DDL, (String)dbafilename);
                    break;
                }
                case "DATAFILE": {
                    dbafilename = (String)dbafilename + "DataFileSql.xml";
                    query = this.getQueryFromFile(this._conn, DATAFILE_DDL, (String)dbafilename);
                    break;
                }
                case "DBLINK": 
                case "DATABASE LINK": {
                    sqlfilename = (String)sqlfilename + "DbLinkSql.xml";
                    query = this.getQueryFromFile(this._conn, DBLINK_DDL, (String)sqlfilename);
                    break;
                }
                case "MATERIALIZED VIEW": {
                    sqlfilename = (String)sqlfilename + "MatViewSql.xml";
                    query = this.getQueryFromFile(this._conn, MATVIEW_DDL, (String)sqlfilename);
                    break;
                }
                case "MATERIALIZED VIEW LOG": {
                    sqlfilename = (String)sqlfilename + "MatViewLogSql.xml";
                    query = this.getQueryFromFile(this._conn, MATVIEWLOG_DDL, (String)sqlfilename);
                    break;
                }
                case "OBJECT": {
                    sqlfilename = (String)sqlfilename + "ObjectSql.xml";
                    query = this.getQueryFromFile(this._conn, OBJECT_DDL, (String)sqlfilename);
                    break;
                }
                case "OPERATOR": {
                    sqlfilename = (String)sqlfilename + "OperatorSql.xml";
                    query = this.getQueryFromFile(this._conn, OPERATOR_DDL, (String)sqlfilename);
                    break;
                }
                case "PROFILE": {
                    dbafilename = (String)dbafilename + "ProfileSql.xml";
                    query = this.getQueryFromFile(this._conn, PROFILE_DDL, (String)dbafilename);
                    break;
                }
                case "QUEUE": {
                    sqlfilename = (String)sqlfilename + "QueueSql.xml";
                    query = this.getQueryFromFile(this._conn, QUEUE_DDL, (String)sqlfilename);
                    break;
                }
                case "QUEUE TABLE": {
                    sqlfilename = (String)sqlfilename + "QueueTableSql.xml";
                    query = this.getQueryFromFile(this._conn, QUEUETABLE_DDL, (String)sqlfilename);
                    break;
                }
                case "REDO LOG GROUP": {
                    dbafilename = (String)dbafilename + "RedoLogGroupSql.xml";
                    query = this.getQueryFromFile(this._conn, REDOLOGGROUP_DDL, (String)dbafilename);
                    break;
                }
                case "PROCEDURE": {
                    sqlfilename = (String)sqlfilename + "ProcedureSql.xml";
                    query = this.getQueryFromFile(this._conn, PROCEDURE_DDL, (String)sqlfilename);
                    break;
                }
                case "PACKAGE": {
                    sqlfilename = (String)sqlfilename + "PackageSql.xml";
                    query = this.getQueryFromFile(this._conn, PACKAGESPEC_DDL, (String)sqlfilename);
                    break;
                }
                case "PACKAGE BODY": {
                    sqlfilename = (String)sqlfilename + "PackageSql.xml";
                    query = this.getQueryFromFile(this._conn, PACKAGEBODY_DDL, (String)sqlfilename);
                    break;
                }
                case "PACKAGE SPEC+BODY": {
                    sqlfilename = (String)sqlfilename + "PackageSql.xml";
                    query = this.getQueryFromFile(this._conn, PACKAGE_DDL, (String)sqlfilename);
                    break;
                }
                case "SEQUENCE": {
                    sqlfilename = (String)sqlfilename + "SequenceSql.xml";
                    query = this.getQueryFromFile(this._conn, SEQUENCE_DDL, (String)sqlfilename);
                    break;
                }
                case "SYNONYM": {
                    sqlfilename = (String)sqlfilename + "SynonymnSql.xml";
                    query = this.getQueryFromFile(this._conn, SYNONYM_DDL, (String)sqlfilename);
                    break;
                }
                case "TABLESPACE": {
                    dbafilename = (String)dbafilename + "TableSpaceSql.xml";
                    query = this.getQueryFromFile(this._conn, TABLESPACE_DDL, (String)dbafilename);
                    break;
                }
                case "TYPE": {
                    sqlfilename = (String)sqlfilename + "TypeSql.xml";
                    query = this.getQueryFromFile(this._conn, TYPE_DDL, (String)sqlfilename);
                    break;
                }
                case "TYPE BODY": {
                    sqlfilename = (String)sqlfilename + "TypeBodySql.xml";
                    query = this.getQueryFromFile(this._conn, TYPE_BODY_DDL, (String)sqlfilename);
                    break;
                }
                case "USER": {
                    dbafilename = (String)dbafilename + "UserSql.xml";
                    query = this.getQueryFromFile(this._conn, USER_DDL, (String)dbafilename);
                    break;
                }
                case "ROLE": {
                    dbafilename = (String)dbafilename + "RoleSql.xml";
                    query = this.getQueryFromFile(this._conn, ROLE_DDL, (String)dbafilename);
                    break;
                }
                case "REF CONSTRAINT": {
                    sqlfilename = (String)sqlfilename + "RefConstraintSql.xml";
                    query = this.getQueryFromFile(this._conn, REFCONSTRAINT_DDL, (String)sqlfilename);
                    break;
                }
                case "TRIGGER": {
                    sqlfilename = (String)sqlfilename + "TriggerSql.xml";
                    query = this.getQueryFromFile(this._conn, TRIGGER_DDL, (String)sqlfilename);
                    break;
                }
                case "MLE ENVIRONMENT": {
                    sqlfilename = (String)sqlfilename + "MLEEnvSql.xml";
                    query = this.getQueryFromFile(this._conn, MLE_ENV_DDL, (String)sqlfilename);
                    break;
                }
            }
            HashMap<String, String> binds = new HashMap<String, String>();
            binds.put("OWNER", resolvedDBName.getSchema() != null ? resolvedDBName.getSchema() : this._conn.getMetaData().getUserName());
            binds.put("NAME", resolvedDBName.getTopLevelName());
            DBUtil dbUtil = DBUtil.getInstance(this._conn);
            dbUtil.execute("begin dbms_metadata.set_transform_param(dbms_metadata.session_transform,'SQLTERMINATOR',true); end;");
            rset = dbUtil.executeQuery(query.getSql(), binds);
            if (rset != null) {
                try {
                    while (rset.next()) {
                        String block = rset.getString(1);
                        String[] lines = block.split("\n");
                        for (int i = 0; i < lines.length; ++i) {
                            if (this._ctx != null && this._ctx.getSQLPlusBuffer() != null) {
                                this._ctx.getSQLPlusBuffer().add(lines[i]);
                            }
                            this.writeToCtx(lines[i], bw);
                        }
                    }
                    if (this._ctx != null && this._ctx.getSQLPlusBuffer() != null) {
                        this._ctx.getSQLPlusBuffer().setBufferSafe(this._ctx.getSQLPlusBuffer().getBufferList());
                    }
                    ok = true;
                }
                finally {
                    DBUtil.closeResultSet(rset);
                }
            } else {
                se = dbUtil.getLastException();
            }
            DBUtil.closeResultSet(rset);
        }
        catch (SQLException e) {
            se = e;
        }
        finally {
            DBUtil.closeResultSet(rset);
        }
        if (se != null) {
            this.writeToCtx(MessageFormat.format(Messages.getString("DDL_OBJECT_TYPE_NOT_GENERATED"), ddlObjective.getOrigName(), type, se.getLocalizedMessage()));
            ok = false;
        }
        return ok;
    }

    public static class ResolvedDBName {
        private final ObjectNamespace namespace;
        private final TokenizedDBName dbName;
        private final TopLevelType part1Type;
        private Integer objectId;
        private String objectType;

        public ResolvedDBName(ObjectNamespace namespace, String schema, String part1, String part2, String dbLink, TopLevelType part1Type, Integer objectId) {
            this.namespace = namespace;
            this.dbName = new TokenizedDBName(schema, part1, part2, dbLink);
            this.part1Type = part1Type;
            this.objectId = objectId;
            this.objectType = null;
        }

        public ResolvedDBName(String schema, String part1, String part2, String dbLink) {
            this(null, schema, part1, part2, dbLink, null, null);
        }

        public final ObjectNamespace getNamespace() {
            return this.namespace;
        }

        public final String getSchema() {
            return this.dbName.getPartA();
        }

        public final String getPart1() {
            return this.dbName.getPartB();
        }

        public final String getPart2() {
            return this.dbName.getPartC();
        }

        public final String getDbLink() {
            return this.dbName.getDbLink();
        }

        public final TopLevelType getPart1Type() {
            return this.part1Type;
        }

        public final Integer getObjectId() {
            return this.objectId;
        }

        public final void setObjectId(Integer objectId) {
            this.objectId = objectId;
        }

        public final String getObjectType() {
            return this.objectType;
        }

        public final void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        public final String getTopLevelName() {
            if (this.part1Type != null) {
                switch (this.part1Type.ordinal()) {
                    case 3: 
                    case 4: {
                        return this.getPart2();
                    }
                }
            }
            return this.getPart1();
        }

        public final String getTopLevelType() {
            if (this.objectType != null) {
                return this.objectType;
            }
            if (this.part1Type != null) {
                return this.part1Type.getObjectType();
            }
            if (this.namespace != null) {
                return this.namespace.getObjectType();
            }
            return null;
        }

        public ResolvedDBName clone() {
            ResolvedDBName another = new ResolvedDBName(this.namespace, this.getSchema(), this.getPart1(), this.getPart2(), this.getDbLink(), this.part1Type, this.objectId);
            another.setObjectType(this.objectType);
            return another;
        }
    }

    public static enum ObjectNamespace {
        TABLE(0),
        PLSQL(1),
        SEQUENCE(2),
        TRIGGER(3),
        TYPE(7),
        INDEX(9);

        private int index;

        private ObjectNamespace(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static ObjectNamespace lookup(int index) {
            switch (index) {
                case 0: {
                    return TABLE;
                }
                case 1: {
                    return PLSQL;
                }
                case 2: {
                    return SEQUENCE;
                }
                case 3: {
                    return TRIGGER;
                }
                case 7: {
                    return TYPE;
                }
                case 9: {
                    return INDEX;
                }
            }
            return null;
        }

        public static ObjectNamespace lookup(String type) {
            if (type != null) {
                switch (type) {
                    case "TABLE": 
                    case "VIEW": {
                        return TABLE;
                    }
                    case "PL/SQL": 
                    case "PACKAGE": 
                    case "FUNCTION": 
                    case "PROCEDURE": {
                        return PLSQL;
                    }
                }
                try {
                    return ObjectNamespace.valueOf(type);
                }
                catch (Exception e) {
                    return null;
                }
            }
            return null;
        }

        public String getObjectType() {
            switch (this.ordinal()) {
                case 0: 
                case 1: {
                    return null;
                }
            }
            return this.toString();
        }
    }

    public static class DDLObjective {
        private LinkedList<ResolvedDBName> resolvedDBNames;
        private final String origName;
        private final String origType;
        private final boolean outputComponentsOnly;
        private final ArrayList<String> componentTypes;

        public DDLObjective(String origName, String origType, List<String> componentTypes, boolean outputComponentsOnly) {
            this.origName = origName;
            this.origType = origType;
            this.outputComponentsOnly = outputComponentsOnly;
            this.componentTypes = componentTypes != null ? new ArrayList<String>(componentTypes) : new ArrayList();
            this.resolvedDBNames = new LinkedList();
        }

        public DDLObjective(String origName, String origType) {
            this(origName, origType, null, false);
        }

        public String getOrigName() {
            return this.origName;
        }

        public String getOrigType() {
            return this.origType;
        }

        public boolean outputComponentsOnly() {
            return this.outputComponentsOnly;
        }

        public List<String> getComponentTypes() {
            return this.componentTypes;
        }

        public List<ResolvedDBName> getResolvedDBNames() {
            return this.resolvedDBNames;
        }

        public void setResolvedDBName(List<ResolvedDBName> resolvedDBNames) {
            this.resolvedDBNames = resolvedDBNames != null ? new LinkedList<ResolvedDBName>(resolvedDBNames) : new LinkedList();
        }
    }

    public static class TokenizedDBName {
        private String partA;
        private String partB;
        private String partC;
        private String dbLink;

        public TokenizedDBName(String partA, String partB, String partC, String dbLink) {
            this.partA = partA;
            this.partB = partB;
            this.partC = partC;
            this.dbLink = dbLink;
        }

        public TokenizedDBName(String name) {
            this(name, null, null, null);
        }

        public final String getPartA() {
            return this.partA;
        }

        public final String getPartB() {
            return this.partB;
        }

        public final String getPartC() {
            return this.partC;
        }

        public final String getDbLink() {
            return this.dbLink;
        }

        public ResolvedDBName pseudoResolve() {
            if (this.partB != null) {
                return new ResolvedDBName(this.partA.toUpperCase(), this.partB, this.partC, this.dbLink);
            }
            return new ResolvedDBName(null, this.partA, null, this.dbLink);
        }
    }

    public static enum TopLevelType {
        TABLE(2),
        VIEW(4),
        SYNONYM(5),
        PROCEDURE(7),
        FUNCTION(8),
        PACKAGE(9);

        private int index;

        private TopLevelType(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static TopLevelType lookup(int index) {
            switch (index) {
                case 2: {
                    return TABLE;
                }
                case 4: {
                    return VIEW;
                }
                case 5: {
                    return SYNONYM;
                }
                case 7: {
                    return PROCEDURE;
                }
                case 8: {
                    return FUNCTION;
                }
                case 9: {
                    return PACKAGE;
                }
            }
            return null;
        }

        public String getObjectType() {
            return this.toString();
        }
    }
}

